/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.InternalException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.event.EventSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SuspendManagerImpl
implements SuspendManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.SuspendManager");
    private final LinkedList<SuspendContextImpl> myEventContexts;
    private final LinkedList<SuspendContextImpl> myPausedContexts;
    private final Set<ThreadReferenceProxyImpl> myFrozenThreads;
    private final DebugProcessImpl myDebugProcess;
    public int suspends;

    public SuspendManagerImpl(@NotNull DebugProcessImpl debugProcess) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/engine/SuspendManagerImpl", "<init>"));
        }
        this.myEventContexts = new LinkedList();
        this.myPausedContexts = new LinkedList();
        this.myFrozenThreads = Collections.synchronizedSet(new HashSet());
        this.suspends = 0;
        this.myDebugProcess = debugProcess;
        this.myDebugProcess.addDebugProcessListener(new DebugProcessAdapterImpl(){

            @Override
            public void processDetached(DebugProcessImpl process, boolean closedByUser) {
                SuspendManagerImpl.this.myEventContexts.clear();
                SuspendManagerImpl.this.myPausedContexts.clear();
                SuspendManagerImpl.this.myFrozenThreads.clear();
            }
        });
    }

    @Override
    public SuspendContextImpl pushSuspendContext(int suspendPolicy, int nVotes) {
        SuspendContextImpl suspendContext = new SuspendContextImpl(this.myDebugProcess, suspendPolicy, nVotes, null){

            @Override
            protected void resumeImpl() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Start resuming...");
                }
                SuspendManagerImpl.this.myDebugProcess.logThreads();
                switch (this.getSuspendPolicy()) {
                    case 2: {
                        int resumeAttempts = 5;
                        while (--resumeAttempts > 0) {
                            try {
                                SuspendManagerImpl.this.myDebugProcess.getVirtualMachineProxy().resume();
                            }
                            catch (InternalException e) {
                                if (e.errorCode() == 13) continue;
                                LOG.error((Throwable)e);
                            }
                            break;
                        }
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug("VM resumed ");
                        break;
                    }
                    case 1: {
                        SuspendManagerImpl.this.myFrozenThreads.remove(this.getThread());
                        this.getThread().resume();
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug("Thread resumed : " + this.getThread().toString());
                        break;
                    }
                    case 0: {
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug("None resumed");
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Suspends = " + SuspendManagerImpl.this.suspends);
                }
                SuspendManagerImpl.this.myDebugProcess.logThreads();
            }
        };
        this.pushContext(suspendContext);
        return suspendContext;
    }

    @Override
    public SuspendContextImpl pushSuspendContext(final EventSet set) {
        SuspendContextImpl suspendContext = new SuspendContextImpl(this.myDebugProcess, set.suspendPolicy(), set.size(), set){

            @Override
            protected void resumeImpl() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Start resuming eventSet " + set.toString() + " suspendPolicy = " + set.suspendPolicy() + ",size = " + set.size());
                }
                SuspendManagerImpl.this.myDebugProcess.logThreads();
                int attempts = 5;
                while (--attempts > 0) {
                    try {
                        set.resume();
                        break;
                    }
                    catch (ObjectCollectedException e) {
                        LOG.info((Throwable)e);
                    }
                    catch (InternalException e) {
                        if (e.errorCode() == 13 && set.suspendPolicy() == 2) continue;
                        LOG.error((Throwable)e);
                        break;
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set resumed ");
                }
                SuspendManagerImpl.this.myDebugProcess.logThreads();
            }
        };
        this.pushContext(suspendContext);
        return suspendContext;
    }

    private void pushContext(SuspendContextImpl suspendContext) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myEventContexts.addFirst(suspendContext);
        ++this.suspends;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Push context : Suspends = " + this.suspends);
        }
    }

    @Override
    public void resume(SuspendContextImpl context) {
        SuspendManagerUtil.prepareForResume(context);
        this.myDebugProcess.logThreads();
        int suspendPolicy = context.getSuspendPolicy();
        this.popContext(context);
        context.resume();
        this.myDebugProcess.clearCashes(suspendPolicy);
    }

    @Override
    public void popFrame(SuspendContextImpl suspendContext) {
        this.popContext(suspendContext);
        SuspendContextImpl newSuspendContext = this.pushSuspendContext(suspendContext.getSuspendPolicy(), 0);
        newSuspendContext.setThread(suspendContext.getThread().getThreadReference());
        this.notifyPaused(newSuspendContext);
    }

    @Override
    public SuspendContextImpl getPausedContext() {
        return !this.myPausedContexts.isEmpty() ? this.myPausedContexts.getFirst() : null;
    }

    public void popContext(SuspendContextImpl suspendContext) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        --this.suspends;
        if (LOG.isDebugEnabled()) {
            LOG.debug("popContext, suspends = " + this.suspends);
        }
        this.myEventContexts.remove((Object)suspendContext);
        this.myPausedContexts.remove((Object)suspendContext);
    }

    void pushPausedContext(SuspendContextImpl suspendContext) {
        if (LOG.isDebugEnabled()) {
            LOG.assertTrue(this.myEventContexts.contains((Object)suspendContext));
        }
        this.myPausedContexts.addFirst(suspendContext);
    }

    public boolean hasEventContext(SuspendContextImpl suspendContext) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return this.myEventContexts.contains((Object)suspendContext);
    }

    @Override
    public List<SuspendContextImpl> getEventContexts() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return Collections.unmodifiableList(this.myEventContexts);
    }

    @Override
    public boolean isFrozen(ThreadReferenceProxyImpl thread) {
        return this.myFrozenThreads.contains(thread);
    }

    @Override
    public boolean isSuspended(ThreadReferenceProxyImpl thread) throws ObjectCollectedException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        boolean suspended = false;
        if (this.isFrozen(thread)) {
            suspended = true;
        } else {
            for (SuspendContextImpl suspendContext : this.myEventContexts) {
                if (!suspendContext.suspends(thread)) continue;
                suspended = true;
                break;
            }
        }
        return suspended && (thread == null || thread.isSuspended());
    }

    @Override
    public void suspendThread(SuspendContextImpl context, ThreadReferenceProxyImpl thread) {
        LOG.assertTrue(thread != context.getThread(), (Object)"Thread is already suspended at the breakpoint");
        if (context.isExplicitlyResumed(thread)) {
            context.myResumedThreads.remove(thread);
            thread.suspend();
        }
    }

    @Override
    public void resumeThread(SuspendContextImpl context, ThreadReferenceProxyImpl thread) {
        LOG.assertTrue(!context.isExplicitlyResumed(thread));
        if (context.myResumedThreads == null) {
            context.myResumedThreads = new HashSet<ThreadReferenceProxyImpl>();
        }
        context.myResumedThreads.add(thread);
        thread.resume();
    }

    @Override
    public void freezeThread(ThreadReferenceProxyImpl thread) {
        if (this.myFrozenThreads.add(thread)) {
            thread.suspend();
        }
    }

    @Override
    public void unfreezeThread(ThreadReferenceProxyImpl thread) {
        if (this.myFrozenThreads.remove(thread)) {
            thread.resume();
        }
    }

    private void processVote(final SuspendContextImpl suspendContext) {
        LOG.assertTrue(suspendContext.myVotesToVote > 0);
        --suspendContext.myVotesToVote;
        if (LOG.isDebugEnabled()) {
            LOG.debug("myVotesToVote = " + suspendContext.myVotesToVote);
        }
        if (suspendContext.myVotesToVote == 0) {
            if (suspendContext.myIsVotedForResume) {
                this.myDebugProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                    @Override
                    protected void action() throws Exception {
                        SuspendManagerImpl.this.resume(suspendContext);
                    }

                    @Override
                    public PrioritizedTask.Priority getPriority() {
                        return PrioritizedTask.Priority.HIGH;
                    }
                });
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("vote paused");
                }
                this.myDebugProcess.logThreads();
                this.myDebugProcess.cancelRunToCursorBreakpoint();
                ThreadReferenceProxyImpl thread = suspendContext.getThread();
                this.myDebugProcess.deleteStepRequests(thread != null ? thread.getThreadReference() : null);
                this.notifyPaused(suspendContext);
            }
        }
    }

    public void notifyPaused(SuspendContextImpl suspendContext) {
        this.pushPausedContext(suspendContext);
        ((DebugProcessListener)this.myDebugProcess.myDebugProcessDispatcher.getMulticaster()).paused((SuspendContext)suspendContext);
    }

    @Override
    public void voteResume(SuspendContextImpl suspendContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resume voted");
        }
        this.processVote(suspendContext);
    }

    @Override
    public void voteSuspend(SuspendContextImpl suspendContext) {
        suspendContext.myIsVotedForResume = false;
        this.processVote(suspendContext);
    }

    LinkedList<SuspendContextImpl> getPausedContexts() {
        return this.myPausedContexts;
    }
}

