/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileAwareSimpleContent
extends SimpleContent {
    @NotNull
    private final Project myProject;
    @NotNull
    private final FilePath myFilePath;

    public FileAwareSimpleContent(@NotNull Project project, @NotNull FilePath filePath, @NotNull String text, @Nullable FileType type) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/diff/FileAwareSimpleContent", "<init>"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/diff/FileAwareSimpleContent", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/FileAwareSimpleContent", "<init>"));
        }
        super(text, type);
        this.myProject = project;
        this.myFilePath = filePath;
    }

    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(this.myFilePath.getIOFile());
        return file == null ? null : new OpenFileDescriptor(this.myProject, file, offset);
    }
}

