/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.applications;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarterEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ApplicationStarterBase
extends ApplicationStarterEx {
    protected static final Logger LOG = Logger.getInstance(ApplicationStarterBase.class);

    protected abstract boolean checkArguments(@NotNull String[] var1);

    @NotNull
    protected abstract String getUsageMessage();

    protected abstract void processCommand(@NotNull String[] var1, @Nullable String var2) throws Exception;

    public boolean isHeadless() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processExternalCommandLine(@NotNull String[] args, @Nullable String currentDirectory) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/diff/applications/ApplicationStarterBase", "processExternalCommandLine"));
        }
        if (!this.checkArguments(args)) {
            Messages.showMessageDialog((String)this.getUsageMessage(), (String)StringUtil.toTitleCase((String)this.getCommandName()), (Icon)Messages.getInformationIcon());
            return;
        }
        try {
            this.processCommand(args, currentDirectory);
        }
        catch (Exception e) {
            Messages.showMessageDialog((String)String.format("Error showing %s: %s", this.getCommandName(), e.getMessage()), (String)StringUtil.toTitleCase((String)this.getCommandName()), (Icon)Messages.getErrorIcon());
        }
        finally {
            ApplicationStarterBase.saveAll();
        }
    }

    private static void saveAll() {
        FileDocumentManager.getInstance().saveAllDocuments();
        ApplicationManager.getApplication().saveSettings();
    }

    public void premain(String[] args) {
        if (!this.checkArguments(args)) {
            System.err.println(this.getUsageMessage());
            System.exit(1);
        }
    }

    public void main(String[] args) {
        try {
            this.processCommand(args, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(2);
        }
        finally {
            ApplicationStarterBase.saveAll();
        }
        System.exit(0);
    }

    @Nullable
    public static VirtualFile findFile(@NotNull String path, @Nullable String currentDirectory) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/diff/applications/ApplicationStarterBase", "findFile"));
        }
        File file = ApplicationStarterBase.getFile(path, currentDirectory);
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        if (virtualFile == null) {
            LOG.warn(String.format("Can't find file: current directory - %s; path - %s", currentDirectory, path));
        }
        return virtualFile;
    }

    @NotNull
    public static File getFile(@NotNull String path, @Nullable String currentDirectory) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/diff/applications/ApplicationStarterBase", "getFile"));
        }
        File file = new File(path);
        if (!file.isAbsolute() && currentDirectory != null) {
            file = new File(currentDirectory, path);
        }
        File file2 = file;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/applications/ApplicationStarterBase", "getFile"));
        }
        return file2;
    }

    public boolean canProcessExternalCommandLine() {
        return true;
    }
}

