/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.applications;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.applications.ApplicationStarterBase;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffApplication
extends ApplicationStarterBase {
    @Override
    protected boolean checkArguments(@NotNull String[] args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/diff/applications/DiffApplication", "checkArguments"));
        }
        return args.length == 3 && "diff".equals(args[0]);
    }

    public String getCommandName() {
        return "diff";
    }

    @Override
    @NotNull
    public String getUsageMessage() {
        String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
        String string = DiffBundle.message((String)"diff.application.usage.parameters.and.description", (Object[])new Object[]{scriptName});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/applications/DiffApplication", "getUsageMessage"));
        }
        return string;
    }

    @Override
    public void processCommand(@NotNull String[] args, @Nullable String currentDirectory) throws Exception {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/diff/applications/DiffApplication", "processCommand"));
        }
        String path1 = args[1];
        String path2 = args[2];
        VirtualFile file1 = DiffApplication.findFile(path1, currentDirectory);
        VirtualFile file2 = DiffApplication.findFile(path2, currentDirectory);
        if (file1 == null) {
            throw new Exception("Can't find file " + path1);
        }
        if (file2 == null) {
            throw new Exception("Can't find file " + path2);
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{file1, file2});
        ContentDiffRequest request = DiffRequestFactory.getInstance().createFromFiles(null, file1, file2);
        Project project = DefaultProjectFactory.getInstance().getDefaultProject();
        DiffManagerEx.getInstance().showDiffBuiltin(project, (DiffRequest)request, DiffDialogHints.MODAL);
    }
}

