/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.ui.EditorNotificationPanel;
import java.awt.Color;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DiffNotifications {
    @NotNull
    public static final JPanel INSERTED_CONTENT = DiffNotifications.createNotification("Content added", TextDiffType.INSERTED.getColor(null));
    @NotNull
    public static final JPanel REMOVED_CONTENT = DiffNotifications.createNotification("Content removed", TextDiffType.DELETED.getColor(null));
    @NotNull
    public static final JPanel EQUAL_CONTENTS = DiffNotifications.createNotification(DiffBundle.message((String)"diff.contents.are.identical.message.text", (Object[])new Object[0]));
    @NotNull
    public static final JPanel ERROR = DiffNotifications.createNotification("Can not calculate diff");
    @NotNull
    public static final JPanel OPERATION_CANCELED = DiffNotifications.createNotification("Can not calculate diff. Operation canceled.");
    @NotNull
    public static final JPanel DIFF_TOO_BIG = DiffNotifications.createNotification("Can not calculate diff. File is too big and there are too many changes.");

    @NotNull
    public static JPanel createNotification(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/tools/util/DiffNotifications", "createNotification"));
        }
        EditorNotificationPanel editorNotificationPanel = new EditorNotificationPanel().text(text);
        if (editorNotificationPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/DiffNotifications", "createNotification"));
        }
        return editorNotificationPanel;
    }

    @NotNull
    public static JPanel createNotification(@NotNull String text, final @NotNull Color background) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/tools/util/DiffNotifications", "createNotification"));
        }
        if (background == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "background", "com/intellij/diff/tools/util/DiffNotifications", "createNotification"));
        }
        EditorNotificationPanel editorNotificationPanel = new EditorNotificationPanel(){

            public Color getBackground() {
                return background;
            }
        }.text(text);
        if (editorNotificationPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/DiffNotifications", "createNotification"));
        }
        return editorNotificationPanel;
    }
}

