/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.TIntFunction;
import java.awt.Component;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldingModelSupport {
    public static final String PLACEHOLDER = "     ";
    private static final Key<FoldingCache> CACHE_KEY = Key.create((String)"Diff.FoldingUtil.Cache");
    protected final int myCount;
    @NotNull
    protected final EditorEx[] myEditors;
    @NotNull
    protected final List<FoldedBlock[]> myFoldings;
    private boolean myDuringSynchronize;
    private final boolean[] myShouldUpdateLineNumbers;

    public FoldingModelSupport(@NotNull EditorEx[] editors, @NotNull Disposable disposable) {
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/util/FoldingModelSupport", "<init>"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/tools/util/FoldingModelSupport", "<init>"));
        }
        this.myFoldings = new ArrayList<FoldedBlock[]>();
        this.myEditors = editors;
        this.myCount = this.myEditors.length;
        this.myShouldUpdateLineNumbers = new boolean[this.myCount];
        if (this.myCount > 1) {
            for (int i = 0; i < this.myCount; ++i) {
                this.myEditors[i].getFoldingModel().addListener(new MyFoldingListener(i), disposable);
                this.myEditors[i].getGutterComponentEx().setLineNumberConvertor(this.getLineConvertor(i));
            }
        }
    }

    protected void install(final @Nullable Iterator<int[]> changedLines, final @NotNull UserDataHolder context, final @NotNull Settings settings) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/FoldingModelSupport", "install"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/FoldingModelSupport", "install"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (changedLines == null) {
            return;
        }
        if (settings.range == -1) {
            return;
        }
        this.runBatchOperation(new Runnable(){

            @Override
            public void run() {
                FoldingBuilder builder = new FoldingBuilder(context, settings);
                builder.build(changedLines);
            }
        });
        this.updateLineNumbers(true);
    }

    @Nullable
    private static FoldRegion addFolding(@NotNull EditorEx editor, int start, int end, boolean expanded) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/FoldingModelSupport", "addFolding"));
        }
        DocumentEx document = editor.getDocument();
        int startOffset = document.getLineStartOffset(start);
        int endOffset = document.getLineEndOffset(end - 1);
        FoldRegion value = editor.getFoldingModel().addFoldRegion(startOffset, endOffset, PLACEHOLDER);
        if (value != null) {
            value.setExpanded(expanded);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBatchOperation(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/diff/tools/util/FoldingModelSupport", "runBatchOperation"));
        }
        Runnable lastRunnable = runnable;
        for (int i = 0; i < this.myCount; ++i) {
            final EditorEx editor = this.myEditors[i];
            final Runnable finalRunnable = lastRunnable;
            lastRunnable = new Runnable(){

                @Override
                public void run() {
                    Runnable operation = new Runnable(){

                        @Override
                        public void run() {
                            finalRunnable.run();
                        }
                    };
                    if (DiffUtil.isFocusedComponent(editor.getComponent())) {
                        editor.getFoldingModel().runBatchFoldingOperationDoNotCollapseCaret(operation);
                    } else {
                        editor.getFoldingModel().runBatchFoldingOperation(operation);
                    }
                }
            };
        }
        this.myDuringSynchronize = true;
        try {
            lastRunnable.run();
        }
        finally {
            this.myDuringSynchronize = false;
        }
    }

    public void destroy() {
        for (int i = 0; i < this.myCount; ++i) {
            this.destroyFoldings(i);
        }
        for (FoldedBlock folding : this.getFoldedBlocks()) {
            folding.destroyHighlighter();
        }
        this.myFoldings.clear();
    }

    private void destroyFoldings(final int index) {
        final FoldingModelEx model = this.myEditors[index].getFoldingModel();
        model.runBatchFoldingOperation(new Runnable(){

            @Override
            public void run() {
                for (FoldedBlock folding : FoldingModelSupport.this.getFoldedBlocks()) {
                    FoldRegion region = folding.getRegion(index);
                    if (region == null) continue;
                    model.removeFoldRegion(region);
                }
            }
        });
    }

    public void onDocumentChanged(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/util/FoldingModelSupport", "onDocumentChanged"));
        }
        if (StringUtil.indexOf((CharSequence)e.getOldFragment(), (char)'\n') != -1 || StringUtil.indexOf((CharSequence)e.getNewFragment(), (char)'\n') != -1) {
            for (int i = 0; i < this.myCount; ++i) {
                if (this.myEditors[i].getDocument() != e.getDocument()) continue;
                this.myShouldUpdateLineNumbers[i] = true;
            }
        }
    }

    @NotNull
    protected TIntFunction getLineConvertor(final int index) {
        TIntFunction tIntFunction = new TIntFunction(){

            public int execute(int value) {
                FoldingModelSupport.this.updateLineNumbers(false);
                for (FoldedBlock folding : FoldingModelSupport.this.getFoldedBlocks()) {
                    int line = folding.getLine(index);
                    if (line == -1) continue;
                    if (line > value) break;
                    FoldRegion region = folding.getRegion(index);
                    if (line != value || region == null || region.isExpanded()) continue;
                    return -1;
                }
                return value;
            }
        };
        if (tIntFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FoldingModelSupport", "getLineConvertor"));
        }
        return tIntFunction;
    }

    private void updateLineNumbers(boolean force) {
        for (int i = 0; i < this.myCount; ++i) {
            if (!this.myShouldUpdateLineNumbers[i] && !force) continue;
            this.myShouldUpdateLineNumbers[i] = false;
            ApplicationManager.getApplication().assertReadAccessAllowed();
            for (FoldedBlock folding : this.getFoldedBlocks()) {
                folding.updateLineNumber(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expandAll(final boolean expanded) {
        if (this.myDuringSynchronize) {
            return;
        }
        this.myDuringSynchronize = true;
        try {
            int i = 0;
            while (i < this.myCount) {
                final int index = i++;
                FoldingModelEx model = this.myEditors[index].getFoldingModel();
                model.runBatchFoldingOperation(new Runnable(){

                    @Override
                    public void run() {
                        for (FoldedBlock folding : FoldingModelSupport.this.getFoldedBlocks()) {
                            FoldRegion region = folding.getRegion(index);
                            if (region == null) continue;
                            region.setExpanded(expanded);
                        }
                    }
                });
            }
        }
        finally {
            this.myDuringSynchronize = false;
        }
    }

    public void updateContext(@NotNull UserDataHolder context, @NotNull Settings settings) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/FoldingModelSupport", "updateContext"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/FoldingModelSupport", "updateContext"));
        }
        if (this.myFoldings.isEmpty()) {
            return;
        }
        context.putUserData(CACHE_KEY, (Object)this.getFoldingCache(settings));
    }

    @NotNull
    private FoldingCache getFoldingCache(final @NotNull Settings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/FoldingModelSupport", "getFoldingCache"));
        }
        FoldingCache foldingCache = (FoldingCache)ApplicationManager.getApplication().runReadAction((Computable)new Computable<FoldingCache>(){

            public FoldingCache compute() {
                List[] result = new List[FoldingModelSupport.this.myCount];
                for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                    result[i] = FoldingModelSupport.this.getFoldedRanges(i, settings);
                }
                return new FoldingCache(result, settings.defaultExpanded);
            }
        });
        if (foldingCache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FoldingModelSupport", "getFoldingCache"));
        }
        return foldingCache;
    }

    @NotNull
    private List<FoldedRangeState> getFoldedRanges(int index, @NotNull Settings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/FoldingModelSupport", "getFoldedRanges"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ArrayList<FoldedRangeState> ranges = new ArrayList<FoldedRangeState>();
        DocumentEx document = this.myEditors[index].getDocument();
        for (FoldedBlock[] blocks : this.myFoldings) {
            LineRange expanded = null;
            LineRange collapsed = null;
            for (FoldedBlock folding : blocks) {
                int line2;
                int line1;
                FoldRegion region = folding.getRegion(index);
                if (region == null || !region.isValid()) continue;
                if (region.isExpanded()) {
                    if (expanded != null) continue;
                    line1 = document.getLineNumber(region.getStartOffset());
                    line2 = document.getLineNumber(region.getEndOffset()) + 1;
                    expanded = new LineRange(line1, line2);
                    continue;
                }
                line1 = document.getLineNumber(region.getStartOffset());
                line2 = document.getLineNumber(region.getEndOffset()) + 1;
                collapsed = new LineRange(line1, line2);
                break;
            }
            if (expanded == null && collapsed == null) continue;
            ranges.add(new FoldedRangeState(expanded, collapsed));
        }
        ArrayList<FoldedRangeState> arrayList = ranges;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FoldingModelSupport", "getFoldedRanges"));
        }
        return arrayList;
    }

    @NotNull
    private Iterable<FoldedBlock> getFoldedBlocks() {
        Iterable<FoldedBlock> iterable = new Iterable<FoldedBlock>(){

            @Override
            @NotNull
            public Iterator<FoldedBlock> iterator() {
                Iterator<FoldedBlock> iterator = new Iterator<FoldedBlock>(){
                    private int myGroupIndex = 0;
                    private int myBlockIndex = 0;

                    @Override
                    public boolean hasNext() {
                        return this.myGroupIndex < FoldingModelSupport.this.myFoldings.size();
                    }

                    @Override
                    public FoldedBlock next() {
                        FoldedBlock[] group = FoldingModelSupport.this.myFoldings.get(this.myGroupIndex);
                        FoldedBlock folding = group[this.myBlockIndex];
                        if (group.length > this.myBlockIndex + 1) {
                            ++this.myBlockIndex;
                        } else {
                            ++this.myGroupIndex;
                            this.myBlockIndex = 0;
                        }
                        return folding;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                if (iterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FoldingModelSupport$7", "iterator"));
                }
                return iterator;
            }
        };
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FoldingModelSupport", "getFoldedBlocks"));
        }
        return iterable;
    }

    private static int getRangeShift(int range, int number) {
        switch (number) {
            case 0: {
                return range;
            }
            case 1: {
                return range * 2;
            }
            case 2: {
                return range * 4;
            }
        }
        return -1;
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    protected static <T, V> Iterator<V> map(@Nullable List<T> list, final @NotNull Function<T, V> mapping) {
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/diff/tools/util/FoldingModelSupport", "map"));
        }
        if (list == null) {
            return null;
        }
        final Iterator<T> it = list.iterator();
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public V next() {
                return mapping.fun(it.next());
            }

            @Override
            public void remove() {
            }
        };
    }

    public static class Settings {
        public final int range;
        public final boolean defaultExpanded;

        public Settings(int range, boolean defaultExpanded) {
            this.range = range;
            this.defaultExpanded = defaultExpanded;
        }
    }

    protected class FoldedBlock {
        @NotNull
        private final FoldRegion[] myRegions;
        @NotNull
        private final int[] myLines;
        @NotNull
        private final List<RangeHighlighter> myHighlighters;

        public FoldedBlock(FoldRegion[] regions) {
            if (regions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regions", "com/intellij/diff/tools/util/FoldingModelSupport$FoldedBlock", "<init>"));
            }
            this.myHighlighters = new ArrayList<RangeHighlighter>(FoldingModelSupport.this.myCount);
            assert (regions.length == FoldingModelSupport.this.myCount);
            this.myRegions = regions;
            this.myLines = new int[FoldingModelSupport.this.myCount];
        }

        public void installHighlighter(@NotNull FoldedBlock[] block) {
            if (block == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/diff/tools/util/FoldingModelSupport$FoldedBlock", "installHighlighter"));
            }
            assert (this.myHighlighters.isEmpty());
            for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                FoldRegion region = this.myRegions[i];
                if (region == null || !region.isValid()) continue;
                this.myHighlighters.addAll(DiffDrawUtil.createLineSeparatorHighlighter(FoldingModelSupport.this.myEditors[i], region.getStartOffset(), region.getEndOffset(), this.getHighlighterCondition(block, i)));
            }
        }

        public void destroyHighlighter() {
            for (RangeHighlighter highlighter : this.myHighlighters) {
                highlighter.dispose();
            }
            this.myHighlighters.clear();
        }

        public void updateLineNumber(int index) {
            FoldRegion region = this.myRegions[index];
            this.myLines[index] = region == null || !region.isValid() ? -1 : FoldingModelSupport.this.myEditors[index].getDocument().getLineNumber(region.getStartOffset());
        }

        @Nullable
        public FoldRegion getRegion(int index) {
            return this.myRegions[index];
        }

        public int getLine(int index) {
            return this.myLines[index];
        }

        @NotNull
        private BooleanGetter getHighlighterCondition(final @NotNull FoldedBlock[] block, final int index) {
            if (block == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/diff/tools/util/FoldingModelSupport$FoldedBlock", "getHighlighterCondition"));
            }
            BooleanGetter booleanGetter = new BooleanGetter(){

                public boolean get() {
                    if (!FoldingModelSupport.this.myEditors[index].getFoldingModel().isFoldingEnabled()) {
                        return false;
                    }
                    for (FoldedBlock folding : block) {
                        boolean visible;
                        FoldRegion region = folding.getRegion(index);
                        boolean bl = visible = region != null && region.isValid() && !region.isExpanded();
                        if (folding == FoldedBlock.this) {
                            return visible;
                        }
                        if (!visible) continue;
                        return false;
                    }
                    return false;
                }
            };
            if (booleanGetter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FoldingModelSupport$FoldedBlock", "getHighlighterCondition"));
            }
            return booleanGetter;
        }
    }

    private static class FoldedRangeState {
        @Nullable
        public final LineRange expanded;
        @Nullable
        public final LineRange collapsed;

        public FoldedRangeState(@Nullable LineRange expanded, @Nullable LineRange collapsed) {
            assert (expanded != null || collapsed != null);
            this.expanded = expanded;
            this.collapsed = collapsed;
        }

        @NotNull
        public LineRange getLineRange() {
            LineRange lineRange = this.expanded != null ? this.expanded : this.collapsed;
            if (lineRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FoldingModelSupport$FoldedRangeState", "getLineRange"));
            }
            return lineRange;
        }
    }

    private static class FoldingCache {
        public final boolean expandByDefault;
        @NotNull
        public final List<FoldedRangeState>[] ranges;

        public FoldingCache(@NotNull List<FoldedRangeState>[] ranges, boolean expandByDefault) {
            if (ranges == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingCache", "<init>"));
            }
            this.ranges = ranges;
            this.expandByDefault = expandByDefault;
        }
    }

    private class ExpandSuggester {
        @Nullable
        private final FoldingCache myCache;
        private final int[] myIndex;
        private final boolean myDefault;

        public ExpandSuggester(FoldingCache cache, boolean defaultValue) {
            this.myIndex = new int[FoldingModelSupport.this.myCount];
            this.myCache = cache;
            this.myDefault = defaultValue;
        }

        public boolean isExpanded(int[] starts, int[] ends) {
            if (this.myCache == null || this.myCache.ranges.length != FoldingModelSupport.this.myCount) {
                return this.myDefault;
            }
            if (this.myDefault != this.myCache.expandByDefault) {
                return this.myDefault;
            }
            Boolean state = null;
            for (int index = 0; index < FoldingModelSupport.this.myCount; ++index) {
                Boolean sideState = this.getCachedExpanded(starts[index], ends[index], index);
                if (sideState == null) continue;
                if (state == null) {
                    state = sideState;
                    continue;
                }
                if (state == sideState) continue;
                return this.myDefault;
            }
            return state == null ? this.myDefault : state;
        }

        @Nullable
        private Boolean getCachedExpanded(int start, int end, int index) {
            if (start == end) {
                return null;
            }
            List<FoldedRangeState> ranges = this.myCache.ranges[index];
            while (this.myIndex[index] < ranges.size()) {
                FoldedRangeState range = ranges.get(this.myIndex[index]);
                LineRange lineRange = range.getLineRange();
                if (lineRange.end > start) {
                    if (lineRange.contains(start, end)) {
                        if (range.collapsed != null && range.collapsed.contains(start, end)) {
                            return false;
                        }
                        if (range.expanded != null && range.expanded.contains(start, end)) {
                            return true;
                        }
                        assert (false) : "Invalid LineRange" + range.expanded + ", " + range.collapsed + ", " + new LineRange(start, end);
                    }
                    if (lineRange.start >= start) {
                        return null;
                    }
                }
                int n = index;
                this.myIndex[n] = this.myIndex[n] + 1;
            }
            return null;
        }
    }

    protected class MyPaintable
    implements DiffDividerDrawUtil.DividerSeparatorPaintable {
        private final int myLeft;
        private final int myRight;

        public MyPaintable(int left, int right) {
            this.myLeft = left;
            this.myRight = right;
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerSeparatorPaintable.Handler handler) {
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/diff/tools/util/FoldingModelSupport$MyPaintable", "process"));
            }
            block0: for (FoldedBlock[] block : FoldingModelSupport.this.myFoldings) {
                for (FoldedBlock folding : block) {
                    int line2;
                    FoldRegion region1 = folding.getRegion(this.myLeft);
                    FoldRegion region2 = folding.getRegion(this.myRight);
                    if (region1 == null || !region1.isValid() || region1.isExpanded() || region2 == null || !region2.isValid() || region2.isExpanded()) continue;
                    int line1 = FoldingModelSupport.this.myEditors[this.myLeft].getDocument().getLineNumber(region1.getStartOffset());
                    if (handler.process(line1, line2 = FoldingModelSupport.this.myEditors[this.myRight].getDocument().getLineNumber(region2.getStartOffset()))) continue block0;
                    return;
                }
            }
        }

        public void paintOnDivider(@NotNull Graphics2D gg, @NotNull Component divider) {
            if (gg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/tools/util/FoldingModelSupport$MyPaintable", "paintOnDivider"));
            }
            if (divider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "divider", "com/intellij/diff/tools/util/FoldingModelSupport$MyPaintable", "paintOnDivider"));
            }
            DiffDividerDrawUtil.paintSeparators(gg, divider.getWidth(), FoldingModelSupport.this.myEditors[this.myLeft], FoldingModelSupport.this.myEditors[this.myRight], this);
        }

        public void paintOnScrollbar(@NotNull Graphics2D gg, int width) {
            if (gg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/tools/util/FoldingModelSupport$MyPaintable", "paintOnScrollbar"));
            }
            DiffDividerDrawUtil.paintSeparatorsOnScrollbar(gg, width, FoldingModelSupport.this.myEditors[this.myLeft], FoldingModelSupport.this.myEditors[this.myRight], this);
        }
    }

    private class MyFoldingListener
    implements FoldingListener {
        private final int myIndex;
        @NotNull
        Set<FoldRegion> myModifiedRegions = new HashSet();

        public MyFoldingListener(int index) {
            this.myIndex = index;
        }

        @Override
        public void onFoldRegionStateChange(@NotNull FoldRegion region) {
            if (region == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/diff/tools/util/FoldingModelSupport$MyFoldingListener", "onFoldRegionStateChange"));
            }
            if (FoldingModelSupport.this.myDuringSynchronize) {
                return;
            }
            this.myModifiedRegions.add(region);
        }

        @Override
        public void onFoldProcessingEnd() {
            if (this.myModifiedRegions.isEmpty()) {
                return;
            }
            FoldingModelSupport.this.myDuringSynchronize = true;
            try {
                for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                    if (i == this.myIndex) continue;
                    final int pairedIndex = i;
                    FoldingModelSupport.this.myEditors[pairedIndex].getFoldingModel().runBatchFoldingOperation(new Runnable(){

                        @Override
                        public void run() {
                            for (FoldedBlock folding : FoldingModelSupport.this.getFoldedBlocks()) {
                                FoldRegion pairedRegion;
                                FoldRegion region = folding.getRegion(MyFoldingListener.this.myIndex);
                                if (region == null || !region.isValid() || !MyFoldingListener.this.myModifiedRegions.contains(region) || (pairedRegion = folding.getRegion(pairedIndex)) == null || !pairedRegion.isValid()) continue;
                                pairedRegion.setExpanded(region.isExpanded());
                            }
                        }
                    });
                }
                this.myModifiedRegions.clear();
            }
            finally {
                FoldingModelSupport.this.myDuringSynchronize = false;
            }
        }
    }

    private class FoldingBuilder {
        @NotNull
        private final Settings mySettings;
        @NotNull
        private final ExpandSuggester myExpandSuggester;
        @NotNull
        private final int[] myLineCount;

        public FoldingBuilder(@NotNull UserDataHolder context, Settings settings) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingBuilder", "<init>"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingBuilder", "<init>"));
            }
            this.myExpandSuggester = new ExpandSuggester((FoldingCache)context.getUserData(CACHE_KEY), settings.defaultExpanded);
            this.mySettings = settings;
            this.myLineCount = new int[FoldingModelSupport.this.myCount];
            for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                this.myLineCount[i] = FoldingModelSupport.this.myEditors[i].getDocument().getLineCount();
            }
        }

        private void build(@NotNull Iterator<int[]> changedLines) {
            int i;
            if (changedLines == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedLines", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingBuilder", "build"));
            }
            int[] starts = new int[FoldingModelSupport.this.myCount];
            int[] ends = new int[FoldingModelSupport.this.myCount];
            int[] last = new int[FoldingModelSupport.this.myCount];
            for (i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                last[i] = Integer.MIN_VALUE;
            }
            while (changedLines.hasNext()) {
                int[] offsets = changedLines.next();
                for (int i2 = 0; i2 < FoldingModelSupport.this.myCount; ++i2) {
                    starts[i2] = last[i2];
                    ends[i2] = offsets[i2 * 2];
                    last[i2] = offsets[i2 * 2 + 1];
                }
                this.addRange(starts, ends);
            }
            for (i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                starts[i] = last[i];
                ends[i] = Integer.MAX_VALUE;
            }
            this.addRange(starts, ends);
        }

        private void addRange(int[] starts, int[] ends) {
            int shift;
            ArrayList result = new ArrayList(3);
            int[] rangeStarts = new int[FoldingModelSupport.this.myCount];
            int[] rangeEnds = new int[FoldingModelSupport.this.myCount];
            int number = 0;
            while ((shift = FoldingModelSupport.getRangeShift(this.mySettings.range, number)) != -1) {
                for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                    rangeStarts[i] = this.bound(starts[i] + shift, i);
                    rangeEnds[i] = this.bound(ends[i] - shift, i);
                }
                ContainerUtil.addAllNotNull(result, (Object[])new FoldedBlock[]{this.createRange(rangeStarts, rangeEnds, this.myExpandSuggester.isExpanded(rangeStarts, rangeEnds))});
                ++number;
            }
            if (result.size() > 0) {
                FoldedBlock[] block;
                for (FoldedBlock folding : block = (FoldedBlock[])ContainerUtil.toArray(result, (Object[])new FoldedBlock[result.size()])) {
                    folding.installHighlighter(block);
                }
                FoldingModelSupport.this.myFoldings.add(block);
            }
        }

        @Nullable
        private FoldedBlock createRange(int[] starts, int[] ends, boolean expanded) {
            boolean hasFolding = false;
            FoldRegion[] regions = new FoldRegion[FoldingModelSupport.this.myCount];
            boolean hasExpanded = false;
            for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                if (ends[i] - starts[i] < 2) continue;
                regions[i] = FoldingModelSupport.addFolding(FoldingModelSupport.this.myEditors[i], starts[i], ends[i], expanded);
                hasFolding |= regions[i] != null;
                hasExpanded |= regions[i] != null && regions[i].isExpanded();
            }
            if (hasExpanded && !expanded) {
                for (FoldRegion region : regions) {
                    if (region == null) continue;
                    region.setExpanded(true);
                }
            }
            return hasFolding ? new FoldedBlock(regions) : null;
        }

        private int bound(int value, int index) {
            return Math.min(Math.max(value, 0), this.myLineCount[index]);
        }
    }
}

