/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.LineFragment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineFragmentCache {
    private final long myModificationStamp1;
    private final long myModificationStamp2;
    @NotNull
    private final Map<ComparisonPolicy, PolicyData> myFragments;

    public LineFragmentCache(@NotNull LineFragmentCache cache) {
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/diff/tools/util/LineFragmentCache", "<init>"));
        }
        this.myModificationStamp1 = cache.myModificationStamp1;
        this.myModificationStamp2 = cache.myModificationStamp2;
        this.myFragments = new HashMap<ComparisonPolicy, PolicyData>(3);
        for (Map.Entry<ComparisonPolicy, PolicyData> entry : cache.myFragments.entrySet()) {
            this.myFragments.put(entry.getKey(), entry.getValue());
        }
    }

    public LineFragmentCache(long modificationStamp1, long modificationStamp2) {
        this.myModificationStamp1 = modificationStamp1;
        this.myModificationStamp2 = modificationStamp2;
        this.myFragments = new HashMap<ComparisonPolicy, PolicyData>(3);
    }

    public boolean checkStamps(long stamp1, long stamp2) {
        return this.myModificationStamp1 == stamp1 && this.myModificationStamp2 == stamp2;
    }

    @Nullable
    public PolicyData getData(@NotNull ComparisonPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/tools/util/LineFragmentCache", "getData"));
        }
        return this.myFragments.get(policy);
    }

    public void putData(@NotNull ComparisonPolicy policy, @NotNull List<LineFragment> fragments, boolean isInnerFragments) {
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/tools/util/LineFragmentCache", "putData"));
        }
        if (fragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/diff/tools/util/LineFragmentCache", "putData"));
        }
        this.myFragments.put(policy, new PolicyData(fragments, isInnerFragments));
    }

    public static class PolicyData {
        @NotNull
        private final List<LineFragment> myFragments;
        private final boolean myInnerFragments;

        public PolicyData(@NotNull List<LineFragment> fragments, boolean innerFragments) {
            if (fragments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/diff/tools/util/LineFragmentCache$PolicyData", "<init>"));
            }
            this.myFragments = fragments;
            this.myInnerFragments = innerFragments;
        }

        @NotNull
        public List<LineFragment> getFragments() {
            List<LineFragment> list = this.myFragments;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/LineFragmentCache$PolicyData", "getFragments"));
            }
            return list;
        }

        public boolean isInnerFragments() {
            return this.myInnerFragments;
        }
    }
}

