/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.util.Side;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreeDiffSplitter
extends JPanel {
    @NotNull
    private final List<Divider> myDividers;
    @NotNull
    private final List<? extends JComponent> myContents;

    public ThreeDiffSplitter(@NotNull List<? extends JComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/diff/tools/util/ThreeDiffSplitter", "<init>"));
        }
        this.myDividers = ContainerUtil.list((Object[])new Divider[]{new Divider(), new Divider()});
        this.myContents = components;
        this.addAll(this.myContents);
        this.addAll(this.myDividers);
    }

    public void setPainter(@Nullable DiffSplitter.Painter painter, @NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/ThreeDiffSplitter", "setPainter"));
        }
        this.getDivider(side).setPainter(painter);
    }

    public void repaintDividers() {
        this.repaintDivider(Side.LEFT);
        this.repaintDivider(Side.RIGHT);
    }

    public void repaintDivider(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/ThreeDiffSplitter", "repaintDivider"));
        }
        this.getDivider(side).repaint();
    }

    @NotNull
    private Divider getDivider(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/ThreeDiffSplitter", "getDivider"));
        }
        Divider divider = this.myDividers.get(side.getIndex());
        if (divider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/ThreeDiffSplitter", "getDivider"));
        }
        return divider;
    }

    private void addAll(@NotNull List<? extends JComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/diff/tools/util/ThreeDiffSplitter", "addAll"));
        }
        for (JComponent jComponent : components) {
            this.add((Component)jComponent, -1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doLayout() {
        int width = this.getWidth();
        int height = this.getHeight();
        int dividersTotalWidth = 0;
        for (JComponent jComponent : this.myDividers) {
            dividersTotalWidth += jComponent.getPreferredSize().width;
        }
        int panelWidth = (width - dividersTotalWidth) / 3;
        boolean bl = false;
        for (int i = 0; i < this.myContents.size(); ++i) {
            void var5_8;
            JComponent component = this.myContents.get(i);
            component.setBounds((int)var5_8, 0, panelWidth, height);
            component.validate();
            var5_8 += panelWidth;
            if (i >= this.myDividers.size()) continue;
            JComponent divider = this.myDividers.get(i);
            int dividerWidth = divider.getPreferredSize().width;
            divider.setBounds((int)var5_8, 0, dividerWidth, height);
            divider.validate();
            var5_8 += dividerWidth;
        }
    }

    private static class Divider
    extends JComponent {
        @Nullable
        private DiffSplitter.Painter myPainter;

        private Divider() {
        }

        @Override
        public Dimension getPreferredSize() {
            return JBUI.size((int)30, (int)1);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.myPainter != null) {
                this.myPainter.paint(g, this);
            }
        }

        public void setPainter(@Nullable DiffSplitter.Painter painter) {
            this.myPainter = painter;
        }
    }
}

