/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffPanelBase
extends JPanel
implements DataProvider {
    @Nullable
    protected final Project myProject;
    @NotNull
    private final DataProvider myDataProvider;
    @NotNull
    protected final DiffContext myContext;
    @NotNull
    protected final JPanel myContentPanel;
    @NotNull
    protected final JPanel myNotificationsPanel;
    @NotNull
    protected final CardLayout myCardLayout;
    @NotNull
    protected String myCurrentCard;

    public DiffPanelBase(@Nullable Project project, @NotNull DataProvider provider, @NotNull DiffContext context) {
        JComponent bottomPanel;
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/diff/tools/util/base/DiffPanelBase", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/base/DiffPanelBase", "<init>"));
        }
        super(new BorderLayout());
        this.myProject = project;
        this.myDataProvider = provider;
        this.myContext = context;
        this.myCardLayout = new CardLayout();
        this.myContentPanel = new JPanel(this.myCardLayout);
        this.myNotificationsPanel = new JPanel();
        this.myNotificationsPanel.setLayout(new BoxLayout(this.myNotificationsPanel, 1));
        this.add((Component)this.myContentPanel, "Center");
        JComponent topPanel = this.createTopPanel();
        if (topPanel != null) {
            this.add((Component)topPanel, "North");
        }
        if ((bottomPanel = this.createBottomPanel()) != null) {
            this.add((Component)bottomPanel, "South");
        }
    }

    @Nullable
    public JComponent createTopPanel() {
        return null;
    }

    @Nullable
    public JComponent createBottomPanel() {
        return null;
    }

    protected void setCurrentCard(@NotNull String card) {
        if (card == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "card", "com/intellij/diff/tools/util/base/DiffPanelBase", "setCurrentCard"));
        }
        this.setCurrentCard(card, true);
    }

    protected void setCurrentCard(@NotNull String card, boolean keepFocus) {
        if (card == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "card", "com/intellij/diff/tools/util/base/DiffPanelBase", "setCurrentCard"));
        }
        boolean restoreFocus = keepFocus && this.myContext.isFocused();
        this.myCardLayout.show(this.myContentPanel, card);
        this.myCurrentCard = card;
        this.myContentPanel.revalidate();
        if (restoreFocus) {
            this.myContext.requestFocus();
        }
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        return this.myDataProvider.getData(dataId);
    }

    public void resetNotifications() {
        this.myNotificationsPanel.removeAll();
        this.myNotificationsPanel.revalidate();
    }

    public void addNotification(@NotNull JComponent notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/diff/tools/util/base/DiffPanelBase", "addNotification"));
        }
        this.myNotificationsPanel.add(notification);
        this.myNotificationsPanel.revalidate();
    }
}

