/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.impl.OpenInEditorWithMouseAction;
import com.intellij.diff.actions.impl.SetEditorSettingsAction;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.tools.holders.TextEditorHolder;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.InitialScrollPositionSupport;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.ThreesideDiffViewer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ThreesideTextDiffViewer
extends ThreesideDiffViewer<TextEditorHolder> {
    public static final Logger LOG = Logger.getInstance(ThreesideTextDiffViewer.class);
    @Nullable
    private List<? extends EditorEx> myEditors;
    @NotNull
    private final List<? extends EditorEx> myEditableEditors;
    @NotNull
    private final MyVisibleAreaListener myVisibleAreaListener1;
    @NotNull
    private final MyVisibleAreaListener myVisibleAreaListener2;
    @Nullable
    protected SyncScrollSupport.ThreesideSyncScrollSupport mySyncScrollSupport;
    @NotNull
    protected final SetEditorSettingsAction myEditorSettingsAction;

    public ThreesideTextDiffViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "<init>"));
        }
        super(context, request, TextEditorHolder.TextEditorHolderFactory.INSTANCE);
        this.myVisibleAreaListener1 = new MyVisibleAreaListener(Side.LEFT);
        this.myVisibleAreaListener2 = new MyVisibleAreaListener(Side.RIGHT);
        this.myEditorSettingsAction = new SetEditorSettingsAction(this.getTextSettings(), this.getEditors());
        this.myEditorSettingsAction.applyDefaults();
        new MyOpenInEditorWithMouseAction().register(this.getEditors());
        this.myEditableEditors = TextDiffViewerUtil.getEditableEditors(this.getEditors());
        TextDiffViewerUtil.checkDifferentDocuments(this.myRequest);
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.installEditorListeners();
    }

    @Override
    protected void onDispose() {
        this.destroyEditorListeners();
        super.onDispose();
    }

    @Override
    @NotNull
    protected List<TextEditorHolder> createEditorHolders(@NotNull EditorHolderFactory<TextEditorHolder> factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "createEditorHolders"));
        }
        List<TextEditorHolder> holders = super.createEditorHolders(factory);
        boolean[] forceReadOnly = TextDiffViewerUtil.checkForceReadOnly(this.myContext, this.myRequest);
        for (int i = 0; i < 3; ++i) {
            if (!forceReadOnly[i]) continue;
            holders.get(i).getEditor().setViewer(true);
        }
        ((TextEditorHolder)ThreeSide.LEFT.select(holders)).getEditor().setVerticalScrollbarOrientation(0);
        ((EditorMarkupModel)((Object)((TextEditorHolder)ThreeSide.BASE.select(holders)).getEditor().getMarkupModel())).setErrorStripeVisible(false);
        if (Registry.is((String)"diff.divider.repainting.disable.blitting")) {
            for (TextEditorHolder holder : holders) {
                holder.getEditor().getScrollPane().getViewport().setScrollMode(0);
            }
        }
        List<TextEditorHolder> list = holders;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "createEditorHolders"));
        }
        return list;
    }

    @Override
    @NotNull
    protected List<JComponent> createTitles() {
        List<JComponent> list = DiffUtil.createTextTitles(this.myRequest, this.getEditors());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "createTitles"));
        }
        return list;
    }

    protected void installEditorListeners() {
        new TextDiffViewerUtil.EditorActionsPopup(this.createEditorPopupActions()).install(this.getEditors());
        new TextDiffViewerUtil.EditorFontSizeSynchronizer(this.getEditors()).install((Disposable)this);
        this.getEditor(ThreeSide.LEFT).getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener1);
        this.getEditor(ThreeSide.BASE).getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener1);
        this.getEditor(ThreeSide.BASE).getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener2);
        this.getEditor(ThreeSide.RIGHT).getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener2);
        SyncScrollSupport.SyncScrollable scrollable1 = this.getSyncScrollable(Side.LEFT);
        SyncScrollSupport.SyncScrollable scrollable2 = this.getSyncScrollable(Side.RIGHT);
        if (scrollable1 != null && scrollable2 != null) {
            this.mySyncScrollSupport = new SyncScrollSupport.ThreesideSyncScrollSupport(this.getEditors(), scrollable1, scrollable2);
        }
    }

    public void destroyEditorListeners() {
        this.getEditor(ThreeSide.LEFT).getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener1);
        this.getEditor(ThreeSide.BASE).getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener1);
        this.getEditor(ThreeSide.BASE).getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener2);
        this.getEditor(ThreeSide.RIGHT).getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener2);
        this.mySyncScrollSupport = null;
    }

    protected void disableSyncScrollSupport(boolean disable) {
        if (this.mySyncScrollSupport != null) {
            this.mySyncScrollSupport.setDisabled(disable);
        }
    }

    @NotNull
    public TextDiffSettingsHolder.TextDiffSettings getTextSettings() {
        TextDiffSettingsHolder.TextDiffSettings textDiffSettings = TextDiffViewerUtil.getTextSettings(this.myContext);
        if (textDiffSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "getTextSettings"));
        }
        return textDiffSettings;
    }

    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        List<AnAction> list = TextDiffViewerUtil.createEditorPopupActions();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "createEditorPopupActions"));
        }
        return list;
    }

    @Override
    protected void onDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "onDocumentChange"));
        }
        super.onDocumentChange(event);
        this.myContentPanel.repaintDividers();
    }

    @NotNull
    public EditorEx getCurrentEditor() {
        EditorEx editorEx = this.getEditor(this.getCurrentSide());
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "getCurrentEditor"));
        }
        return editorEx;
    }

    @NotNull
    public DocumentContent getCurrentContent() {
        DocumentContent documentContent = this.getContent(this.getCurrentSide());
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "getCurrentContent"));
        }
        return documentContent;
    }

    @NotNull
    protected List<? extends DocumentContent> getContents() {
        List list = this.myRequest.getContents();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "getContents"));
        }
        return list;
    }

    @NotNull
    public List<? extends EditorEx> getEditors() {
        if (this.myEditors == null) {
            this.myEditors = ContainerUtil.map(this.getEditorHolders(), (Function)new Function<TextEditorHolder, EditorEx>(){

                public EditorEx fun(TextEditorHolder holder) {
                    return holder.getEditor();
                }
            });
        }
        List<? extends EditorEx> list = this.myEditors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "getEditors"));
        }
        return list;
    }

    @NotNull
    protected List<? extends EditorEx> getEditableEditors() {
        List<? extends EditorEx> list = this.myEditableEditors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "getEditableEditors"));
        }
        return list;
    }

    @NotNull
    public EditorEx getEditor(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "getEditor"));
        }
        EditorEx editorEx = (EditorEx)side.select(this.getEditors());
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "getEditor"));
        }
        return editorEx;
    }

    @NotNull
    public DocumentContent getContent(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "getContent"));
        }
        DocumentContent documentContent = (DocumentContent)side.select(this.getContents());
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "getContent"));
        }
        return documentContent;
    }

    protected void scrollToLine(@NotNull ThreeSide side, int line) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "scrollToLine"));
        }
        DiffUtil.scrollEditor(this.getEditor(side), line, false);
        this.setCurrentSide(side);
    }

    @Nullable
    protected abstract SyncScrollSupport.SyncScrollable getSyncScrollable(@NotNull Side var1);

    @Override
    @Nullable
    protected OpenFileDescriptor getOpenFileDescriptor() {
        int offset = this.getCurrentEditor().getCaretModel().getOffset();
        return this.getCurrentContent().getOpenFileDescriptor(offset);
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer", "canShowRequest"));
        }
        return ThreesideDiffViewer.canShowRequest(context, request, TextEditorHolder.TextEditorHolderFactory.INSTANCE);
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        if (DiffDataKeys.CURRENT_EDITOR.is(dataId)) {
            return this.getCurrentEditor();
        }
        return super.getData(dataId);
    }

    protected abstract class MyInitialScrollPositionHelper
    extends InitialScrollPositionSupport.ThreesideInitialScrollHelper {
        protected MyInitialScrollPositionHelper() {
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            List<? extends EditorEx> list = ThreesideTextDiffViewer.this.getEditors();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer$MyInitialScrollPositionHelper", "getEditors"));
            }
            return list;
        }

        @Override
        protected void disableSyncScroll(boolean value) {
            ThreesideTextDiffViewer.this.disableSyncScrollSupport(value);
        }

        @Override
        protected boolean doScrollToLine() {
            if (this.myScrollToLine == null) {
                return false;
            }
            ThreesideTextDiffViewer.this.scrollToLine((ThreeSide)this.myScrollToLine.first, (Integer)this.myScrollToLine.second);
            return true;
        }
    }

    private class MyVisibleAreaListener
    implements VisibleAreaListener {
        @NotNull
        Side mySide;

        public MyVisibleAreaListener(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer$MyVisibleAreaListener", "<init>"));
            }
            this.mySide = side;
        }

        public void visibleAreaChanged(VisibleAreaEvent e) {
            if (ThreesideTextDiffViewer.this.mySyncScrollSupport != null) {
                ThreesideTextDiffViewer.this.mySyncScrollSupport.visibleAreaChanged(e);
            }
            if (Registry.is((String)"diff.divider.repainting.fix")) {
                ThreesideTextDiffViewer.this.myContentPanel.repaint();
            } else {
                ThreesideTextDiffViewer.this.myContentPanel.repaintDivider(this.mySide);
            }
        }
    }

    protected class MyToggleAutoScrollAction
    extends TextDiffViewerUtil.ToggleAutoScrollAction {
        public MyToggleAutoScrollAction() {
            super(ThreesideTextDiffViewer.this.getTextSettings());
        }
    }

    private class MyOpenInEditorWithMouseAction
    extends OpenInEditorWithMouseAction {
        private MyOpenInEditorWithMouseAction() {
        }

        @Override
        protected OpenFileDescriptor getDescriptor(@NotNull Editor editor, int line) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/side/ThreesideTextDiffViewer$MyOpenInEditorWithMouseAction", "getDescriptor"));
            }
            ThreeSide side = null;
            if (editor == ThreesideTextDiffViewer.this.getEditor(ThreeSide.LEFT)) {
                side = ThreeSide.LEFT;
            }
            if (editor == ThreesideTextDiffViewer.this.getEditor(ThreeSide.RIGHT)) {
                side = ThreeSide.RIGHT;
            }
            if (editor == ThreesideTextDiffViewer.this.getEditor(ThreeSide.BASE)) {
                side = ThreeSide.BASE;
            }
            if (side == null) {
                return null;
            }
            int offset = editor.logicalPositionToOffset(new LogicalPosition(line, 0));
            return ThreesideTextDiffViewer.this.getContent(side).getOpenFileDescriptor(offset);
        }
    }
}

