/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class DiffLineMarkerRenderer
implements LineMarkerRenderer {
    @NotNull
    private final TextDiffType myDiffType;
    private final boolean myIgnoredFoldingOutline;

    public DiffLineMarkerRenderer(@NotNull TextDiffType diffType) {
        if (diffType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffType", "com/intellij/diff/util/DiffLineMarkerRenderer", "<init>"));
        }
        this(diffType, false);
    }

    public DiffLineMarkerRenderer(@NotNull TextDiffType diffType, boolean ignoredFoldingOutline) {
        if (diffType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffType", "com/intellij/diff/util/DiffLineMarkerRenderer", "<init>"));
        }
        this.myDiffType = diffType;
        this.myIgnoredFoldingOutline = ignoredFoldingOutline;
    }

    public void paint(Editor editor, Graphics g, Rectangle range) {
        Color color = this.myDiffType.getColor(editor);
        EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
        Graphics2D g2 = (Graphics2D)g;
        int x1 = 0;
        int x2 = x1 + gutter.getWidth();
        int y = range.y;
        int height = range.height;
        if (height > 2) {
            if (this.myIgnoredFoldingOutline) {
                int xOutline = gutter.getWhitespaceSeparatorOffset();
                g.setColor(this.myDiffType.getIgnoredColor(editor));
                g.fillRect(xOutline, y, x2 - xOutline, height);
                g.setColor(color);
                g.fillRect(x1, y, xOutline - x1, height);
            } else {
                g.setColor(color);
                g.fillRect(x1, y, x2 - x1, height);
            }
            DiffDrawUtil.drawChunkBorderLine(g2, x1, x2, y - 1, color);
            DiffDrawUtil.drawChunkBorderLine(g2, x1, x2, y + height - 1, color);
        } else {
            DiffDrawUtil.drawDoubleChunkBorderLine(g2, x1, x2, y - 1, color);
        }
    }
}

