/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.UnknownRunConfiguration;
import com.intellij.execution.impl.ConfigurationSettingsEditorWrapper;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.ValidationResult;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorConfigurable;
import com.intellij.openapi.options.SettingsEditorListener;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class SingleConfigurationConfigurable<Config extends RunConfiguration>
extends SettingsEditorConfigurable<RunnerAndConfigurationSettings> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.impl.SingleConfigurationConfigurable");
    private final PlainDocument myNameDocument = new PlainDocument();
    @Nullable
    private Executor myExecutor;
    private ValidationResult myLastValidationResult = null;
    private boolean myValidationResultValid = false;
    private MyValidatableComponent myComponent;
    private final String myDisplayName;
    private final String myHelpTopic;
    private final boolean myBrokenConfiguration;
    private boolean myStoreProjectConfiguration;
    private boolean mySingleton;
    private String myFolderName;
    private boolean myChangingNameFromCode;

    private SingleConfigurationConfigurable(RunnerAndConfigurationSettings settings, @Nullable Executor executor) {
        super((SettingsEditor)new ConfigurationSettingsEditorWrapper(settings), (Object)settings);
        this.myExecutor = executor;
        Config configuration = this.getConfiguration();
        this.myDisplayName = ((RunnerAndConfigurationSettings)this.getSettings()).getName();
        this.myHelpTopic = "reference.dialogs.rundebug." + configuration.getType().getId();
        this.myBrokenConfiguration = configuration instanceof UnknownRunConfiguration;
        this.setFolderName(((RunnerAndConfigurationSettings)this.getSettings()).getFolderName());
        this.setNameText(configuration.getName());
        this.myNameDocument.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                RunConfiguration runConfiguration;
                SingleConfigurationConfigurable.this.setModified(true);
                if (!SingleConfigurationConfigurable.this.myChangingNameFromCode && (runConfiguration = ((RunnerAndConfigurationSettings)SingleConfigurationConfigurable.this.getSettings()).getConfiguration()) instanceof LocatableConfigurationBase) {
                    ((LocatableConfigurationBase)runConfiguration).setNameChangedByUser(true);
                }
            }
        });
        this.getEditor().addSettingsEditorListener((SettingsEditorListener)new SettingsEditorListener<RunnerAndConfigurationSettings>(){

            public void stateChanged(SettingsEditor<RunnerAndConfigurationSettings> settingsEditor) {
                SingleConfigurationConfigurable.this.myValidationResultValid = false;
            }
        });
    }

    public static <Config extends RunConfiguration> SingleConfigurationConfigurable<Config> editSettings(RunnerAndConfigurationSettings settings, @Nullable Executor executor) {
        SingleConfigurationConfigurable<Config> configurable = new SingleConfigurationConfigurable<Config>(settings, executor);
        configurable.reset();
        return configurable;
    }

    public void apply() throws ConfigurationException {
        RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)this.getSettings();
        RunConfiguration runConfiguration = settings.getConfiguration();
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(runConfiguration.getProject());
        runManager.shareConfiguration(settings, this.myStoreProjectConfiguration);
        settings.setName(this.getNameText());
        settings.setSingleton(this.mySingleton);
        settings.setFolderName(this.myFolderName);
        super.apply();
        runManager.addConfiguration(settings, this.myStoreProjectConfiguration, runManager.getBeforeRunTasks(settings.getConfiguration()), false);
    }

    public void reset() {
        RunnerAndConfigurationSettings configuration = (RunnerAndConfigurationSettings)this.getSettings();
        this.setNameText(configuration.getName());
        super.reset();
        if (this.myComponent == null) {
            this.myComponent = new MyValidatableComponent();
        }
        this.myComponent.doReset(configuration);
    }

    void updateWarning() {
        this.myValidationResultValid = false;
        if (this.myComponent != null) {
            this.myComponent.updateWarning();
        }
    }

    public final JComponent createComponent() {
        this.myComponent.myNameText.setEnabled(!this.myBrokenConfiguration);
        JComponent result = this.myComponent.getWholePanel();
        DataManager.registerDataProvider((JComponent)result, (DataProvider)new MyDataProvider());
        return result;
    }

    final JComponent getValidationComponent() {
        return this.myComponent.myValidationPanel;
    }

    public boolean isStoreProjectConfiguration() {
        return this.myStoreProjectConfiguration;
    }

    public boolean isSingleton() {
        return this.mySingleton;
    }

    @Nullable
    private ValidationResult getValidationResult() {
        if (!this.myValidationResultValid) {
            this.myLastValidationResult = null;
            RunnerAndConfigurationSettings snapshot = null;
            try {
                snapshot = this.getSnapshot();
                if (snapshot != null) {
                    snapshot.setName(this.getNameText());
                    snapshot.checkSettings(this.myExecutor);
                    for (Executor executor : ExecutorRegistry.getInstance().getRegisteredExecutors()) {
                        ProgramRunner runner = RunnerRegistry.getInstance().getRunner(executor.getId(), (RunProfile)snapshot.getConfiguration());
                        if (runner == null) continue;
                        SingleConfigurationConfigurable.checkConfiguration(runner, snapshot);
                    }
                }
            }
            catch (RuntimeConfigurationException exception) {
                Runnable resultQuickFix;
                final Runnable quickFix = exception.getQuickFix();
                if (quickFix != null && snapshot != null) {
                    final RunnerAndConfigurationSettings fixedSettings = snapshot;
                    resultQuickFix = new Runnable(){

                        @Override
                        public void run() {
                            quickFix.run();
                            SingleConfigurationConfigurable.this.getEditor().resetFrom((Object)fixedSettings);
                        }
                    };
                } else {
                    resultQuickFix = quickFix;
                }
                this.myLastValidationResult = new ValidationResult(exception.getLocalizedMessage(), exception.getTitle(), resultQuickFix);
            }
            catch (ConfigurationException e) {
                this.myLastValidationResult = new ValidationResult(e.getLocalizedMessage(), ExecutionBundle.message((String)"invalid.data.dialog.title", (Object[])new Object[0]), null);
            }
            this.myValidationResultValid = true;
        }
        return this.myLastValidationResult;
    }

    private static void checkConfiguration(ProgramRunner runner, RunnerAndConfigurationSettings snapshot) throws RuntimeConfigurationException {
        RunnerSettings runnerSettings = snapshot.getRunnerSettings(runner);
        ConfigurationPerRunnerSettings configurationSettings = snapshot.getConfigurationSettings(runner);
        try {
            runner.checkConfiguration(runnerSettings, configurationSettings);
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    public final void disposeUIResources() {
        super.disposeUIResources();
        this.myComponent = null;
    }

    public final String getNameText() {
        try {
            return this.myNameDocument.getText(0, this.myNameDocument.getLength());
        }
        catch (BadLocationException e) {
            LOG.error((Throwable)e);
            return "";
        }
    }

    public final void addNameListener(DocumentListener listener) {
        this.myNameDocument.addDocumentListener(listener);
    }

    public final void addSharedListener(ChangeListener changeListener) {
        this.myComponent.myCbStoreProjectConfiguration.addChangeListener(changeListener);
    }

    public final void setNameText(String name) {
        this.myChangingNameFromCode = true;
        try {
            try {
                if (!this.myNameDocument.getText(0, this.myNameDocument.getLength()).equals(name)) {
                    this.myNameDocument.replace(0, this.myNameDocument.getLength(), name, null);
                }
            }
            catch (BadLocationException e) {
                LOG.error((Throwable)e);
            }
        }
        finally {
            this.myChangingNameFromCode = false;
        }
    }

    public final boolean isValid() {
        return this.getValidationResult() == null;
    }

    public final JTextField getNameTextField() {
        return this.myComponent.myNameText;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public String getHelpTopic() {
        return this.myHelpTopic;
    }

    public Config getConfiguration() {
        return (Config)((RunnerAndConfigurationSettings)this.getSettings()).getConfiguration();
    }

    public RunnerAndConfigurationSettings getSnapshot() throws ConfigurationException {
        SettingsEditor editor = this.getEditor();
        return editor == null ? null : (RunnerAndConfigurationSettings)editor.getSnapshot();
    }

    public String toString() {
        return this.myDisplayName;
    }

    public void setFolderName(@Nullable String folderName) {
        if (!Comparing.equal((String)this.myFolderName, (String)folderName)) {
            this.myFolderName = folderName;
            this.setModified(true);
        }
    }

    @Nullable
    public String getFolderName() {
        return this.myFolderName;
    }

    private class MyDataProvider
    implements DataProvider {
        private MyDataProvider() {
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (ConfigurationSettingsEditorWrapper.CONFIGURATION_EDITOR_KEY.is(dataId)) {
                return SingleConfigurationConfigurable.this.getEditor();
            }
            return null;
        }
    }

    private class MyValidatableComponent {
        private JLabel myNameLabel;
        private JTextField myNameText;
        private JComponent myWholePanel;
        private JPanel myComponentPlace;
        private JLabel myWarningLabel;
        private JButton myFixButton;
        private JSeparator mySeparator;
        private JCheckBox myCbStoreProjectConfiguration;
        private JBCheckBox myCbSingleton;
        private JPanel myValidationPanel;
        private Runnable myQuickFix = null;

        public MyValidatableComponent() {
            this.$$$setupUI$$$();
            this.myNameLabel.setLabelFor(this.myNameText);
            this.myNameText.setDocument(SingleConfigurationConfigurable.this.myNameDocument);
            SingleConfigurationConfigurable.this.getEditor().addSettingsEditorListener(new SettingsEditorListener(){

                public void stateChanged(SettingsEditor settingsEditor) {
                    MyValidatableComponent.this.updateWarning();
                }
            });
            this.myWarningLabel.setIcon(AllIcons.RunConfigurations.ConfigurationWarning);
            this.myComponentPlace.setLayout(new GridBagLayout());
            this.myComponentPlace.add((Component)this.getEditorComponent(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.myComponentPlace.doLayout();
            this.myFixButton.setIcon(AllIcons.Actions.QuickfixBulb);
            this.updateWarning();
            this.myFixButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MyValidatableComponent.this.myQuickFix == null) {
                        return;
                    }
                    MyValidatableComponent.this.myQuickFix.run();
                    SingleConfigurationConfigurable.this.myValidationResultValid = false;
                    MyValidatableComponent.this.updateWarning();
                }
            });
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SingleConfigurationConfigurable.this.setModified(true);
                    SingleConfigurationConfigurable.this.myStoreProjectConfiguration = MyValidatableComponent.this.myCbStoreProjectConfiguration.isSelected();
                    SingleConfigurationConfigurable.this.mySingleton = MyValidatableComponent.this.myCbSingleton.isSelected();
                }
            };
            this.myCbStoreProjectConfiguration.addActionListener(actionListener);
            this.myCbSingleton.addActionListener(actionListener);
            this.settingAnchor();
        }

        private void doReset(RunnerAndConfigurationSettings settings) {
            RunConfiguration runConfiguration = settings.getConfiguration();
            RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(runConfiguration.getProject());
            SingleConfigurationConfigurable.this.myStoreProjectConfiguration = runManager.isConfigurationShared(settings);
            this.myCbStoreProjectConfiguration.setEnabled(!(runConfiguration instanceof UnknownRunConfiguration));
            this.myCbStoreProjectConfiguration.setSelected(SingleConfigurationConfigurable.this.myStoreProjectConfiguration);
            this.myCbStoreProjectConfiguration.setVisible(!settings.isTemplate());
            SingleConfigurationConfigurable.this.mySingleton = settings.isSingleton();
            this.myCbSingleton.setEnabled(!(runConfiguration instanceof UnknownRunConfiguration));
            this.myCbSingleton.setSelected(SingleConfigurationConfigurable.this.mySingleton);
            ConfigurationFactory factory = settings.getFactory();
            this.myCbSingleton.setVisible(factory != null && factory.canConfigurationBeSingleton());
        }

        private void settingAnchor() {
        }

        public final JComponent getWholePanel() {
            return this.myWholePanel;
        }

        public JComponent getEditorComponent() {
            return SingleConfigurationConfigurable.this.getEditor().getComponent();
        }

        @Nullable
        public ValidationResult getValidationResult() {
            return SingleConfigurationConfigurable.this.getValidationResult();
        }

        private void updateWarning() {
            ValidationResult configurationException = this.getValidationResult();
            if (configurationException != null) {
                this.mySeparator.setVisible(true);
                this.myWarningLabel.setVisible(true);
                this.myWarningLabel.setText(this.generateWarningLabelText(configurationException));
                Runnable quickFix = configurationException.getQuickFix();
                if (quickFix == null) {
                    this.myFixButton.setVisible(false);
                } else {
                    this.myFixButton.setVisible(true);
                    this.myQuickFix = quickFix;
                }
                this.myValidationPanel.setVisible(true);
            } else {
                this.mySeparator.setVisible(false);
                this.myWarningLabel.setVisible(false);
                this.myFixButton.setVisible(false);
                this.myValidationPanel.setVisible(false);
            }
        }

        @NonNls
        private String generateWarningLabelText(ValidationResult configurationException) {
            return "<html><body><b>" + configurationException.getTitle() + ": </b>" + configurationException.getMessage() + "</body></html>";
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBCheckBox jBCheckBox;
            JCheckBox jCheckBox;
            JTextField jTextField;
            JLabel jLabel;
            JPanel jPanel;
            JSeparator jSeparator;
            JButton jButton;
            JLabel jLabel2;
            JPanel jPanel2;
            JPanel jPanel3 = new JPanel();
            this.myWholePanel = jPanel3;
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 5, 0, 0), -1, -1, false, false));
            jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 2, 1, 3, 3, null, null, null));
            this.myValidationPanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myWarningLabel = jLabel2 = new JLabel();
            jLabel2.setText("####################");
            jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, new Dimension(10, -1), new Dimension(10, -1), null));
            this.myFixButton = jButton = new JButton();
            this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/ExecutionBundle").getString("fix.run.configuration.problem.button"));
            jPanel2.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
            this.mySeparator = jSeparator = new JSeparator();
            jPanel2.add((Component)jSeparator, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 0, null, null, null));
            this.myComponentPlace = jPanel = new JPanel();
            jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 5, 3, 0), -1, -1, false, false));
            jPanel3.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myNameLabel = jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ExecutionBundle").getString("edit.run.configuration.run.configuration.name.label"));
            jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myNameText = jTextField = new JTextField();
            jTextField.setColumns(15);
            jPanel5.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
            this.myCbStoreProjectConfiguration = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ExecutionBundle").getString("run.configuration.store.place.option"));
            jPanel5.add((Component)jCheckBox, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myCbSingleton = jBCheckBox = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/ExecutionBundle").getString("run.configuration.singleton"));
            jPanel5.add((Component)jBCheckBox, new GridConstraints(0, 4, 1, 1, 0, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel5.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 1, new Dimension(20, -1), new Dimension(20, -1), null));
            jLabel.setLabelFor(jTextField);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

