/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.junit2.segments.Extractor;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;

public class JUnitProcessHandler
extends KillableColoredProcessHandler {
    private final Extractor myOut;
    private final Extractor myErr;

    private JUnitProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/junit/JUnitProcessHandler", "<init>"));
        }
        super(commandLine);
        this.myOut = new Extractor(this.getProcess().getInputStream(), commandLine.getCharset());
        this.myErr = new Extractor(this.getProcess().getErrorStream(), commandLine.getCharset());
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                Disposer.dispose((Disposable)JUnitProcessHandler.this.myOut);
                Disposer.dispose((Disposable)JUnitProcessHandler.this.myErr);
            }
        });
    }

    protected Reader createProcessOutReader() {
        return this.myOut.createReader();
    }

    protected Reader createProcessErrReader() {
        return this.myErr.createReader();
    }

    @NotNull
    public Extractor getErr() {
        Extractor extractor = this.myErr;
        if (extractor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/JUnitProcessHandler", "getErr"));
        }
        return extractor;
    }

    @NotNull
    public Extractor getOut() {
        Extractor extractor = this.myOut;
        if (extractor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/JUnitProcessHandler", "getOut"));
        }
        return extractor;
    }

    @NotNull
    public static JUnitProcessHandler runCommandLine(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/junit/JUnitProcessHandler", "runCommandLine"));
        }
        JUnitProcessHandler processHandler = new JUnitProcessHandler(commandLine);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        JUnitProcessHandler jUnitProcessHandler = processHandler;
        if (jUnitProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/JUnitProcessHandler", "runCommandLine"));
        }
        return jUnitProcessHandler;
    }
}

