/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JUnitRecognizer;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitUtil {
    @NonNls
    public static final String TESTCASE_CLASS = "junit.framework.TestCase";
    @NonNls
    private static final String TEST_INTERFACE = "junit.framework.Test";
    @NonNls
    private static final String TESTSUITE_CLASS = "junit.framework.TestSuite";
    @NonNls
    public static final String TEST_ANNOTATION = "org.junit.Test";
    @NonNls
    public static final String IGNORE_ANNOTATION = "org.junit.Ignore";
    @NonNls
    public static final String RUN_WITH = "org.junit.runner.RunWith";
    @NonNls
    public static final String DATA_POINT = "org.junit.experimental.theories.DataPoint";
    @NonNls
    public static final String SUITE_METHOD_NAME = "suite";
    public static final String BEFORE_ANNOTATION_NAME = "org.junit.Before";
    public static final String AFTER_ANNOTATION_NAME = "org.junit.After";
    public static final String PARAMETRIZED_PARAMETERS_ANNOTATION_NAME = "org.junit.runners.Parameterized.Parameters";
    private static final String AFTER_CLASS_ANNOTATION_NAME = "org.junit.AfterClass";
    private static final String BEFORE_CLASS_ANNOTATION_NAME = "org.junit.BeforeClass";
    private static final Collection<String> CONFIGURATIONS_ANNOTATION_NAME = Collections.unmodifiableList(Arrays.asList("org.junit.experimental.theories.DataPoint", "org.junit.After", "org.junit.Before", "org.junit.AfterClass", "org.junit.BeforeClass"));
    @NonNls
    public static final String PARAMETERIZED_CLASS_NAME = "org.junit.runners.Parameterized";
    @NonNls
    public static final String SUITE_CLASS_NAME = "org.junit.runners.Suite";

    public static boolean isSuiteMethod(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/execution/junit/JUnitUtil", "isSuiteMethod"));
        }
        if (!psiMethod.hasModifierProperty("public")) {
            return false;
        }
        if (!psiMethod.hasModifierProperty("static")) {
            return false;
        }
        if (psiMethod.isConstructor()) {
            return false;
        }
        if (psiMethod.getParameterList().getParametersCount() > 0) {
            return false;
        }
        PsiType returnType = psiMethod.getReturnType();
        if (returnType == null || returnType instanceof PsiPrimitiveType) {
            return false;
        }
        return returnType.equalsToText(TEST_INTERFACE) || returnType.equalsToText(TESTSUITE_CLASS) || InheritanceUtil.isInheritor((PsiType)returnType, (String)TEST_INTERFACE);
    }

    public static boolean isTestMethod(Location<? extends PsiMethod> location) {
        return JUnitUtil.isTestMethod(location, true);
    }

    public static boolean isTestMethod(Location<? extends PsiMethod> location, boolean checkAbstract) {
        PsiClass aClass;
        PsiMethod psiMethod = (PsiMethod)location.getPsiElement();
        PsiClass psiClass = aClass = location instanceof MethodLocation ? ((MethodLocation)location).getContainingClass() : psiMethod.getContainingClass();
        if (aClass == null || !JUnitUtil.isTestClass(aClass, checkAbstract, true)) {
            return false;
        }
        if (JUnitUtil.isTestAnnotated(psiMethod)) {
            return true;
        }
        if (psiMethod.isConstructor()) {
            return false;
        }
        if (!psiMethod.hasModifierProperty("public")) {
            return false;
        }
        if (psiMethod.hasModifierProperty("abstract")) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, CONFIGURATIONS_ANNOTATION_NAME, (boolean)false)) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)RUN_WITH, (boolean)true)) {
            return true;
        }
        if (psiMethod.getParameterList().getParametersCount() > 0) {
            return false;
        }
        if (psiMethod.hasModifierProperty("static") && SUITE_METHOD_NAME.equals(psiMethod.getName())) {
            return false;
        }
        if (!psiMethod.getName().startsWith("test")) {
            return false;
        }
        PsiClass testCaseClass = JUnitUtil.getTestCaseClassOrNull(location);
        return testCaseClass != null && psiMethod.getContainingClass().isInheritor(testCaseClass, true);
    }

    public static boolean isTestCaseInheritor(PsiClass aClass) {
        if (!aClass.isValid()) {
            return false;
        }
        Location location = PsiLocation.fromPsiElement((PsiElement)aClass);
        PsiClass testCaseClass = JUnitUtil.getTestCaseClassOrNull(location);
        return testCaseClass != null && aClass.isInheritor(testCaseClass, true);
    }

    public static boolean isTestClass(PsiClass psiClass) {
        return JUnitUtil.isTestClass(psiClass, true, true);
    }

    public static boolean isTestClass(@NotNull PsiClass psiClass, boolean checkAbstract, boolean checkForTestCaseInheritance) {
        String runnerName;
        PsiAnnotationMemberValue attributeValue;
        PsiAnnotation annotation;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/execution/junit/JUnitUtil", "isTestClass"));
        }
        if (psiClass.getQualifiedName() == null) {
            return false;
        }
        PsiClass topLevelClass = (PsiClass)PsiTreeUtil.getTopmostParentOfType((PsiElement)psiClass, PsiClass.class);
        if (topLevelClass != null && (annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)topLevelClass, Collections.singleton(RUN_WITH))) != null && (attributeValue = annotation.findAttributeValue("value")) instanceof PsiClassObjectAccessExpression && !PARAMETERIZED_CLASS_NAME.equals(runnerName = ((PsiClassObjectAccessExpression)attributeValue).getOperand().getType().getCanonicalText()) && !SUITE_CLASS_NAME.equals(runnerName)) {
            return true;
        }
        if (!PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)true, (boolean)checkAbstract)) {
            return false;
        }
        if (checkForTestCaseInheritance && JUnitUtil.isTestCaseInheritor(psiClass)) {
            return true;
        }
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList == null) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)RUN_WITH, (boolean)true)) {
            return true;
        }
        for (PsiMethod method : psiClass.getAllMethods()) {
            ProgressManager.checkCanceled();
            if (JUnitUtil.isSuiteMethod(method)) {
                return true;
            }
            if (!JUnitUtil.isTestAnnotated(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isJUnit3TestClass(PsiClass clazz) {
        return JUnitUtil.isTestCaseInheritor(clazz);
    }

    public static boolean isJUnit4TestClass(PsiClass psiClass) {
        return JUnitUtil.isJUnit4TestClass(psiClass, true);
    }

    private static boolean isJUnit4TestClass(PsiClass psiClass, boolean checkAbstract) {
        if (!PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)true, (boolean)checkAbstract)) {
            return false;
        }
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList == null) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)RUN_WITH, (boolean)true)) {
            return true;
        }
        for (PsiMethod method : psiClass.getAllMethods()) {
            ProgressManager.checkCanceled();
            if (!JUnitUtil.isTestAnnotated(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTestAnnotated(PsiMethod method) {
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)TEST_ANNOTATION, (boolean)false) || JUnitRecognizer.willBeAnnotatedAfterCompilation((PsiMethod)method)) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method.getContainingClass(), Collections.singleton(RUN_WITH));
            if (annotation != null) {
                PsiNameValuePair[] attributes;
                for (PsiNameValuePair attribute : attributes = annotation.getParameterList().getAttributes()) {
                    PsiTypeElement typeElement;
                    PsiAnnotationMemberValue value = attribute.getValue();
                    if (!(value instanceof PsiClassObjectAccessExpression) || !(typeElement = ((PsiClassObjectAccessExpression)value).getOperand()).getType().getCanonicalText().equals(PARAMETERIZED_CLASS_NAME)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiClass getTestCaseClassOrNull(Location<?> location) {
        Location ancestorOrSelf = location.getAncestorOrSelf(PsiClass.class);
        if (ancestorOrSelf == null) {
            return null;
        }
        PsiClass aClass = (PsiClass)ancestorOrSelf.getPsiElement();
        Module module = JavaExecutionUtil.findModule((PsiClass)aClass);
        if (module == null) {
            return null;
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true);
        return JUnitUtil.getTestCaseClassOrNull(scope, module.getProject());
    }

    public static PsiClass getTestCaseClass(Module module) throws NoJUnitException {
        if (module == null) {
            throw new NoJUnitException();
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true);
        return JUnitUtil.getTestCaseClass(scope, module.getProject());
    }

    public static PsiClass getTestCaseClass(SourceScope scope) throws NoJUnitException {
        if (scope == null) {
            throw new NoJUnitException();
        }
        return JUnitUtil.getTestCaseClass(scope.getLibrariesScope(), scope.getProject());
    }

    private static PsiClass getTestCaseClass(GlobalSearchScope scope, Project project) throws NoJUnitException {
        PsiClass testCaseClass = JUnitUtil.getTestCaseClassOrNull(scope, project);
        if (testCaseClass == null) {
            throw new NoJUnitException(scope.getDisplayName());
        }
        return testCaseClass;
    }

    @Nullable
    private static PsiClass getTestCaseClassOrNull(GlobalSearchScope scope, Project project) {
        return JavaPsiFacade.getInstance((Project)project).findClass(TESTCASE_CLASS, scope);
    }

    public static boolean isTestMethodOrConfig(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/execution/junit/JUnitUtil", "isTestMethodOrConfig"));
        }
        if (JUnitUtil.isTestMethod((Location<? extends PsiMethod>)PsiLocation.fromPsiElement((PsiElement)psiMethod), false)) {
            PsiClass containingClass = psiMethod.getContainingClass();
            assert (containingClass != null) : psiMethod + "; " + psiMethod.getClass() + "; " + psiMethod.getParent();
            if (containingClass.hasModifierProperty("abstract")) {
                final boolean[] foundNonAbstractInheritor = new boolean[1];
                ClassInheritorsSearch.search((PsiClass)containingClass).forEach((Processor)new Processor<PsiClass>(){

                    public boolean process(PsiClass psiClass) {
                        if (!psiClass.hasModifierProperty("abstract")) {
                            foundNonAbstractInheritor[0] = true;
                            return false;
                        }
                        return true;
                    }
                });
                if (foundNonAbstractInheritor[0]) {
                    return true;
                }
            } else {
                return true;
            }
        }
        String name = psiMethod.getName();
        if (psiMethod.hasModifierProperty("public") && !psiMethod.hasModifierProperty("abstract")) {
            if (SUITE_METHOD_NAME.equals(name) || "setUp".equals(name) || "tearDown".equals(name)) {
                return true;
            }
            if (psiMethod.hasModifierProperty("static") ? AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, Arrays.asList(BEFORE_CLASS_ANNOTATION_NAME, AFTER_CLASS_ANNOTATION_NAME, PARAMETRIZED_PARAMETERS_ANNOTATION_NAME)) : AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, Arrays.asList(BEFORE_ANNOTATION_NAME, AFTER_ANNOTATION_NAME))) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static PsiMethod findFirstTestMethod(PsiClass clazz) {
        PsiMethod testMethod = null;
        for (PsiMethod method : clazz.getMethods()) {
            if (!JUnitUtil.isTestMethod(MethodLocation.elementInClass(method, clazz)) && !JUnitUtil.isSuiteMethod(method)) continue;
            testMethod = method;
            break;
        }
        return testMethod;
    }

    @Nullable
    public static PsiMethod findSuiteMethod(PsiClass clazz) {
        PsiMethod[] suiteMethods;
        for (PsiMethod method : suiteMethods = clazz.findMethodsByName(SUITE_METHOD_NAME, false)) {
            if (!JUnitUtil.isSuiteMethod(method)) continue;
            return method;
        }
        return null;
    }

    public static PsiClass findPsiClass(String qualifiedName, Module module, Project project) {
        GlobalSearchScope scope = module == null ? GlobalSearchScope.projectScope((Project)project) : GlobalSearchScope.moduleWithDependenciesScope((Module)module);
        return JavaPsiFacade.getInstance((Project)project).findClass(qualifiedName, scope);
    }

    public static PsiPackage getContainingPackage(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/execution/junit/JUnitUtil", "getContainingPackage"));
        }
        PsiDirectory directory = psiClass.getContainingFile().getContainingDirectory();
        return directory == null ? null : JavaDirectoryService.getInstance().getPackage(directory);
    }

    public static PsiClass getTestClass(PsiElement element) {
        return JUnitUtil.getTestClass(PsiLocation.fromPsiElement((PsiElement)element));
    }

    public static PsiClass getTestClass(Location<?> location) {
        PsiClass[] classes;
        Iterator iterator = location.getAncestors(PsiClass.class, false);
        while (iterator.hasNext()) {
            Location classLocation = (Location)iterator.next();
            if (!JUnitUtil.isTestClass((PsiClass)classLocation.getPsiElement(), false, true)) continue;
            return (PsiClass)classLocation.getPsiElement();
        }
        PsiElement element = location.getPsiElement();
        if (element instanceof PsiClassOwner && (classes = ((PsiClassOwner)element).getClasses()).length == 1) {
            return classes[0];
        }
        return null;
    }

    public static PsiMethod getTestMethod(PsiElement element) {
        return JUnitUtil.getTestMethod(element, true);
    }

    public static PsiMethod getTestMethod(PsiElement element, boolean checkAbstract) {
        PsiManager manager = element.getManager();
        Location location = PsiLocation.fromPsiElement((Project)manager.getProject(), (PsiElement)element);
        Iterator iterator = location.getAncestors(PsiMethod.class, false);
        while (iterator.hasNext()) {
            Location methodLocation = (Location)iterator.next();
            if (!JUnitUtil.isTestMethod((Location<? extends PsiMethod>)methodLocation, checkAbstract)) continue;
            return (PsiMethod)methodLocation.getPsiElement();
        }
        return null;
    }

    public static class NoJUnitException
    extends CantRunException {
        public NoJUnitException() {
            super(ExecutionBundle.message((String)"no.junit.error.message", (Object[])new Object[0]));
        }

        public NoJUnitException(String message) {
            super(ExecutionBundle.message((String)"no.junit.in.scope.error.message", (Object[])new Object[]{message}));
        }
    }

    public static class TestMethodFilter
    implements Condition<PsiMethod> {
        private final PsiClass myClass;

        public TestMethodFilter(PsiClass aClass) {
            this.myClass = aClass;
        }

        public boolean value(PsiMethod method) {
            return JUnitUtil.isTestMethod(MethodLocation.elementInClass(method, this.myClass));
        }
    }
}

