/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.lineMarker;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunLineMarkerInfo
extends LineMarkerInfo<PsiElement> {
    private final PsiElement myElement;

    public RunLineMarkerInfo(PsiElement element, Icon icon, Function<? super PsiElement, String> tooltipProvider) {
        super(element, element.getTextOffset(), icon, 4, tooltipProvider, null, GutterIconRenderer.Alignment.CENTER);
        this.myElement = element;
    }

    @Nullable
    public GutterIconRenderer createGutterRenderer() {
        return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

            public boolean isNavigateAction() {
                return true;
            }

            @NotNull
            public ActionGroup getPopupMenuActions() {
                ArrayList<Separator> actions2 = new ArrayList<Separator>();
                Object[] executors = ExecutorRegistry.getInstance().getRegisteredExecutors();
                actions2.addAll(ContainerUtil.mapNotNull((Object[])executors, (Function)new Function<Executor, AnAction>(){

                    public AnAction fun(Executor executor) {
                        return new ActionWrapper(ActionManager.getInstance().getAction(executor.getContextActionId()));
                    }
                }));
                actions2.add(Separator.getInstance());
                actions2.addAll(ContainerUtil.mapNotNull((Collection)RunLineMarkerContributor.EXTENSION.allForLanguage(RunLineMarkerInfo.this.myElement.getLanguage()), (Function)new NullableFunction<RunLineMarkerContributor, AnAction>(){

                    @Nullable
                    public AnAction fun(RunLineMarkerContributor contributor) {
                        AnAction action = contributor.getAdditionalAction(RunLineMarkerInfo.this.myElement);
                        return action != null ? new ActionWrapper(action) : null;
                    }
                }));
                DefaultActionGroup defaultActionGroup = new DefaultActionGroup(actions2);
                if (defaultActionGroup == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/lineMarker/RunLineMarkerInfo$1", "getPopupMenuActions"));
                }
                return defaultActionGroup;
            }

            public AnAction getClickAction() {
                return null;
            }
        };
    }

    private class MyDataContext
    extends UserDataHolderBase
    implements DataContext {
        private final DataContext myDelegate;

        public MyDataContext(DataContext delegate) {
            this.myDelegate = delegate;
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (Location.DATA_KEY.is(dataId)) {
                return RunLineMarkerInfo.this.myElement.isValid() ? new PsiLocation(RunLineMarkerInfo.this.myElement) : null;
            }
            return this.myDelegate.getData(dataId);
        }
    }

    private class ActionWrapper
    extends AnAction {
        private final AnAction myOrigin;

        public ActionWrapper(AnAction origin) {
            if (origin == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "com/intellij/execution/lineMarker/RunLineMarkerInfo$ActionWrapper", "<init>"));
            }
            this.myOrigin = origin;
            this.copyFrom(origin);
        }

        public void update(AnActionEvent e) {
            this.myOrigin.update(this.createEvent(e));
        }

        @NotNull
        private AnActionEvent createEvent(AnActionEvent e) {
            AnActionEvent anActionEvent = new AnActionEvent(e.getInputEvent(), (DataContext)new MyDataContext(e.getDataContext()), e.getPlace(), e.getPresentation(), e.getActionManager(), e.getModifiers());
            if (anActionEvent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/lineMarker/RunLineMarkerInfo$ActionWrapper", "createEvent"));
            }
            return anActionEvent;
        }

        public void actionPerformed(AnActionEvent e) {
            this.myOrigin.actionPerformed(this.createEvent(e));
        }
    }
}

