/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.stacktrace.StackTraceLine;
import com.intellij.execution.testframework.ResetConfigurationModuleAdapter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaAwareTestConsoleProperties<T extends ModuleBasedConfiguration<JavaRunConfigurationModule>>
extends SMTRunnerConsoleProperties {
    public JavaAwareTestConsoleProperties(String testFrameworkName, RunConfiguration configuration, Executor executor) {
        super(configuration, testFrameworkName, executor);
        this.setPrintTestingStartedTime(false);
    }

    @Override
    public boolean isPaused() {
        DebuggerSession debuggerSession = this.getDebugSession();
        return debuggerSession != null && debuggerSession.isPaused();
    }

    public T getConfiguration() {
        return (T)((ModuleBasedConfiguration)super.getConfiguration());
    }

    @Override
    protected int getSelectionMode() {
        return 4;
    }

    @Override
    public boolean fixEmptySuite() {
        return ResetConfigurationModuleAdapter.tryWithAnotherModule(this.getConfiguration(), this.isDebug());
    }

    @Override
    @Nullable
    public Navigatable getErrorNavigatable(@NotNull Location<?> location, @NotNull String stacktrace) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/execution/testframework/JavaAwareTestConsoleProperties", "getErrorNavigatable"));
        }
        if (stacktrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stacktrace", "com/intellij/execution/testframework/JavaAwareTestConsoleProperties", "getErrorNavigatable"));
        }
        String[] stackTrace = new LineTokenizer(stacktrace).execute();
        PsiLocation psiLocation = location.toPsiLocation();
        PsiClass containingClass = (PsiClass)psiLocation.getParentElement(PsiClass.class);
        if (containingClass == null) {
            return null;
        }
        String qualifiedName = containingClass.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        String containingMethod = null;
        Iterator iterator = psiLocation.getAncestors(PsiMethod.class, false);
        while (iterator.hasNext()) {
            PsiMethod psiMethod = (PsiMethod)((Location)iterator.next()).getPsiElement();
            if (!containingClass.equals(psiMethod.getContainingClass())) continue;
            containingMethod = psiMethod.getName();
        }
        if (containingMethod == null) {
            return null;
        }
        StackTraceLine lastLine = null;
        for (String aStackTrace : stackTrace) {
            StackTraceLine line = new StackTraceLine(containingClass.getProject(), aStackTrace);
            if (!containingMethod.equals(line.getMethodName()) || !qualifiedName.equals(line.getClassName())) continue;
            lastLine = line;
            break;
        }
        return lastLine != null ? lastLine.getOpenFileDescriptor(containingClass.getContainingFile().getVirtualFile()) : null;
    }

    @Nullable
    public DebuggerSession getDebugSession() {
        DebuggerManagerEx debuggerManager = DebuggerManagerEx.getInstanceEx(this.getProject());
        if (debuggerManager == null) {
            return null;
        }
        Collection<DebuggerSession> sessions = debuggerManager.getSessions();
        for (DebuggerSession debuggerSession : sessions) {
            if (this.getConsole() != debuggerSession.getProcess().getExecutionResult().getExecutionConsole()) continue;
            return debuggerSession;
        }
        return null;
    }
}

