/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.Location;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public interface SMTestLocator {
    @NotNull
    public List<Location> getLocation(@NotNull String var1, @NotNull String var2, @NotNull Project var3, @NotNull GlobalSearchScope var4);

    public static class Composite
    implements SMTestLocator,
    DumbAware {
        private final Map<String, ? extends SMTestLocator> myLocators;

        public Composite(@NotNull Pair<String, ? extends SMTestLocator> first, Pair<String, ? extends SMTestLocator> ... rest) {
            if (first == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/execution/testframework/sm/runner/SMTestLocator$Composite", "<init>"));
            }
            if (rest == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rest", "com/intellij/execution/testframework/sm/runner/SMTestLocator$Composite", "<init>"));
            }
            this.myLocators = ContainerUtil.newHashMap(first, rest);
        }

        @Override
        @NotNull
        public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
            if (protocol == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/intellij/execution/testframework/sm/runner/SMTestLocator$Composite", "getLocation"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/execution/testframework/sm/runner/SMTestLocator$Composite", "getLocation"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/sm/runner/SMTestLocator$Composite", "getLocation"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/execution/testframework/sm/runner/SMTestLocator$Composite", "getLocation"));
            }
            SMTestLocator locator = this.myLocators.get(protocol);
            if (locator != null && (!DumbService.isDumb((Project)project) || DumbService.isDumbAware((Object)locator))) {
                List<Location> list = locator.getLocation(protocol, path, project, scope);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/SMTestLocator$Composite", "getLocation"));
                }
                return list;
            }
            List<Location> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/SMTestLocator$Composite", "getLocation"));
            }
            return list;
        }
    }
}

