/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.history.actions;

import com.intellij.execution.testframework.sm.TestHistoryConfiguration;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.history.actions.AbstractImportTestsAction;
import com.intellij.execution.testframework.sm.runner.history.actions.ImportTestsFromFileAction;
import com.intellij.execution.testframework.sm.runner.history.actions.ImportTestsFromHistoryAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportTestsGroup
extends ActionGroup {
    private SMTRunnerConsoleProperties myProperties;

    public ImportTestsGroup() {
        super("Import Test Results", "Import Test Results", AllIcons.Vcs.History);
        this.setPopup(true);
    }

    public ImportTestsGroup(SMTRunnerConsoleProperties properties) {
        this();
        this.myProperties = properties;
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/history/actions/ImportTestsGroup", "getChildren"));
            }
            return EMPTY_ARRAY;
        }
        Project project = e.getProject();
        if (project == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/history/actions/ImportTestsGroup", "getChildren"));
            }
            return EMPTY_ARRAY;
        }
        Collection<String> filePaths = TestHistoryConfiguration.getInstance(project).getFiles();
        final File testHistoryRoot = AbstractImportTestsAction.getTestHistoryRoot(project);
        List fileNames = ContainerUtil.map(filePaths, (Function)new Function<String, File>(){

            public File fun(String fileName) {
                return new File(testHistoryRoot, fileName);
            }
        });
        Collections.sort(fileNames, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return f1.lastModified() > f2.lastModified() ? -1 : 1;
            }
        });
        int historySize = fileNames.size();
        AnAction[] actions2 = new AnAction[historySize + 2];
        for (int i = 0; i < historySize; ++i) {
            actions2[i] = new ImportTestsFromHistoryAction(this.myProperties, project, ((File)fileNames.get(i)).getName());
        }
        actions2[historySize] = Separator.getInstance();
        actions2[historySize + 1] = new ImportTestsFromFileAction(this.myProperties);
        if (actions2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/history/actions/ImportTestsGroup", "getChildren"));
        }
        return actions2;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }
}

