/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.ui;

import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkPropertyListener;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.ToolbarPanel;
import com.intellij.execution.testframework.ui.SameHeightPanel;
import com.intellij.execution.testframework.ui.TestStatusLine;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SideBorder;
import com.intellij.util.Producer;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestResultsPanel
extends JPanel
implements Disposable,
DataProvider {
    private JScrollPane myLeftPane;
    private JComponent myStatisticsComponent;
    private Splitter myStatisticsSplitter;
    protected final JComponent myConsole;
    protected ToolbarPanel myToolbarPanel;
    private final String mySplitterProportionProperty;
    private final String myStatisticsSplitterProportionProperty;
    private final float mySplitterDefaultProportion;
    protected final AnAction[] myConsoleActions;
    protected final TestConsoleProperties myProperties;
    protected TestStatusLine myStatusLine;
    private Splitter mySplitter;

    protected TestResultsPanel(@NotNull JComponent console, AnAction[] consoleActions, TestConsoleProperties properties, String splitterProportionProperty, float splitterDefaultProportion) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/testframework/ui/TestResultsPanel", "<init>"));
        }
        super(new BorderLayout(0, 1));
        this.myConsole = console;
        this.myConsoleActions = consoleActions;
        this.myProperties = properties;
        this.mySplitterProportionProperty = splitterProportionProperty;
        this.mySplitterDefaultProportion = splitterDefaultProportion;
        this.myStatisticsSplitterProportionProperty = this.mySplitterProportionProperty + "_Statistics";
    }

    public void initUI() {
        this.myLeftPane = ScrollPaneFactory.createScrollPane();
        this.myLeftPane.putClientProperty(UIUtil.KEEP_BORDER_SIDES, 2);
        this.myStatisticsComponent = this.createStatisticsPanel();
        this.myStatusLine = this.createStatusLine();
        JComponent testTreeView = this.createTestTreeView();
        this.myToolbarPanel = this.createToolbarPanel();
        Disposer.register((Disposable)this, (Disposable)this.myToolbarPanel);
        String windowId = this.myProperties.getExecutor().getToolWindowId();
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProperties.getProject()).getToolWindow(windowId);
        boolean splitVertically = false;
        if (toolWindow != null) {
            ToolWindowAnchor anchor = toolWindow.getAnchor();
            splitVertically = anchor == ToolWindowAnchor.LEFT || anchor == ToolWindowAnchor.RIGHT;
        }
        this.myStatusLine.setPreferredSize(splitVertically);
        this.mySplitter = TestResultsPanel.createSplitter(this.mySplitterProportionProperty, this.mySplitterDefaultProportion, splitVertically);
        if (this.mySplitter instanceof OnePixelSplitter) {
            ((OnePixelSplitter)this.mySplitter).setBlindZone((Producer)new Producer<Insets>(){

                @Nullable
                public Insets produce() {
                    return new Insets(TestResultsPanel.this.myToolbarPanel.getHeight(), 0, 0, 0);
                }
            });
        }
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                TestResultsPanel.this.remove((Component)TestResultsPanel.this.mySplitter);
                TestResultsPanel.this.mySplitter.dispose();
            }
        });
        this.add((Component)this.mySplitter, "Center");
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.myLeftPane, "Center");
        leftPanel.add((Component)this.myToolbarPanel, "North");
        this.mySplitter.setFirstComponent((JComponent)leftPanel);
        this.myStatusLine.setMinimumSize(new Dimension(0, this.myStatusLine.getMinimumSize().height));
        this.myStatusLine.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add((Component)SameHeightPanel.wrap(this.myStatusLine, this.myToolbarPanel), "North");
        this.myStatisticsSplitter = TestResultsPanel.createSplitter(this.myStatisticsSplitterProportionProperty, 0.5f, false);
        this.myStatisticsSplitter.setFirstComponent(this.createOutputTab(this.myConsole, this.myConsoleActions));
        if (Registry.is((String)"tests.view.old.statistics.panel")) {
            if (TestConsoleProperties.SHOW_STATISTICS.value((AbstractProperty.AbstractPropertyContainer)this.myProperties)) {
                this.showStatistics();
            }
            this.myProperties.addListener(TestConsoleProperties.SHOW_STATISTICS, new TestFrameworkPropertyListener<Boolean>(){

                @Override
                public void onChanged(Boolean value) {
                    if (value.booleanValue()) {
                        TestResultsPanel.this.showStatistics();
                    } else {
                        TestResultsPanel.this.myStatisticsSplitter.setSecondComponent(null);
                    }
                }
            });
        }
        rightPanel.add((Component)this.myStatisticsSplitter, "Center");
        this.mySplitter.setSecondComponent((JComponent)rightPanel);
        testTreeView.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        this.setLeftComponent(testTreeView);
    }

    private void showStatistics() {
        this.myStatisticsSplitter.setSecondComponent(this.myStatisticsComponent);
    }

    protected abstract JComponent createStatisticsPanel();

    protected ToolbarPanel createToolbarPanel() {
        return new ToolbarPanel(this.myProperties, this);
    }

    protected TestStatusLine createStatusLine() {
        return new TestStatusLine();
    }

    protected abstract JComponent createTestTreeView();

    @Nullable
    protected TestTreeView getTreeView() {
        return null;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        TestTreeView view = this.getTreeView();
        if (view != null) {
            return view.getData(dataId);
        }
        return null;
    }

    private JComponent createOutputTab(JComponent console, AnAction[] consoleActions) {
        JPanel outputTab = new JPanel(new BorderLayout());
        console.setFocusable(true);
        Color editorBackground = EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
        console.setBorder(new CompoundBorder(IdeBorderFactory.createBorder((int)6), (Border)new SideBorder(editorBackground, 1)));
        outputTab.add((Component)console, "Center");
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)new DefaultActionGroup(consoleActions), false);
        outputTab.add((Component)toolbar.getComponent(), "East");
        return outputTab;
    }

    public void dispose() {
    }

    protected static Splitter createSplitter(final String proportionProperty, float defaultProportion, boolean splitVertically) {
        float proportion;
        OnePixelSplitter splitter = new OnePixelSplitter(splitVertically);
        splitter.setHonorComponentsMinimumSize(true);
        final PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        String value = propertiesComponent.getValue(proportionProperty);
        if (value != null) {
            try {
                proportion = Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                proportion = defaultProportion;
            }
        } else {
            proportion = defaultProportion;
        }
        splitter.addPropertyChangeListener(new PropertyChangeListener((Splitter)splitter){
            final /* synthetic */ Splitter val$splitter;
            {
                this.val$splitter = splitter;
            }

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/testframework/ui/TestResultsPanel$4", "propertyChange"));
                }
                if (event.getPropertyName().equals("proportion")) {
                    propertiesComponent.setValue(proportionProperty, String.valueOf(this.val$splitter.getProportion()));
                }
            }
        });
        splitter.setProportion(proportion);
        return splitter;
    }

    protected void setLeftComponent(JComponent component) {
        if (component != this.myLeftPane.getViewport().getView()) {
            this.myLeftPane.setViewportView(component);
        }
    }
}

