/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.CommonBundle;
import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.IntelliJLaf;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class CustomizeUIThemeStepPanel
extends AbstractCustomizeWizardStep {
    protected static final ThemeInfo AQUA = new ThemeInfo("Default", "Aqua", "com.apple.laf.AquaLookAndFeel");
    protected static final ThemeInfo DARCULA = new ThemeInfo("Darcula", "Darcula", DarculaLaf.class.getName());
    protected static final ThemeInfo INTELLIJ = new ThemeInfo("IntelliJ", "IntelliJ", IntelliJLaf.class.getName());
    protected static final ThemeInfo ALLOY = new ThemeInfo("Alloy. IDEA Theme", "Alloy", "com.incors.plaf.alloy.AlloyIdea");
    protected static final ThemeInfo GTK = new ThemeInfo("GTK+", "GTK", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
    private boolean myInitial = true;
    private boolean myColumnMode;
    private JLabel myPreviewLabel;
    private Set<ThemeInfo> myThemes = new LinkedHashSet<ThemeInfo>();

    public CustomizeUIThemeStepPanel() {
        this.setLayout(CustomizeUIThemeStepPanel.createSmallBorderLayout());
        IconLoader.activate();
        this.initThemes(this.myThemes);
        this.myColumnMode = this.myThemes.size() > 2;
        JPanel buttonsPanel = new JPanel(new GridLayout(this.myColumnMode ? this.myThemes.size() : 1, this.myColumnMode ? 1 : this.myThemes.size(), 5, 5));
        ButtonGroup group = new ButtonGroup();
        ThemeInfo myDefaultTheme = null;
        for (final ThemeInfo theme : this.myThemes) {
            JRadioButton radioButton = new JRadioButton(theme.name, myDefaultTheme == null);
            radioButton.setOpaque(false);
            if (myDefaultTheme == null) {
                radioButton.setSelected(true);
                myDefaultTheme = theme;
            }
            JPanel panel = CustomizeUIThemeStepPanel.createBigButtonPanel(CustomizeUIThemeStepPanel.createSmallBorderLayout(), radioButton, new Runnable(){

                @Override
                public void run() {
                    CustomizeUIThemeStepPanel.this.applyLaf(theme, CustomizeUIThemeStepPanel.this);
                    theme.apply();
                }
            });
            panel.setBorder(CustomizeUIThemeStepPanel.createSmallEmptyBorder());
            panel.add((Component)radioButton, this.myColumnMode ? "West" : "North");
            Icon icon = theme.getIcon();
            JLabel label = new JLabel(this.myColumnMode ? IconUtil.scale((Icon)IconUtil.cropIcon((Icon)icon, (int)(icon.getIconWidth() * 2 / 3), (int)(icon.getIconHeight() * 2 / 3)), (double)0.5) : icon);
            label.setVerticalAlignment(1);
            label.setHorizontalAlignment(4);
            panel.add((Component)label, "Center");
            group.add(radioButton);
            buttonsPanel.add(panel);
        }
        this.add((Component)buttonsPanel, "Center");
        this.myPreviewLabel = new JLabel();
        this.myPreviewLabel.setHorizontalAlignment(this.myColumnMode ? 2 : 0);
        this.myPreviewLabel.setVerticalAlignment(0);
        if (this.myColumnMode) {
            this.add((Component)buttonsPanel, "West");
            JPanel wrapperPanel = new JPanel(new FlowLayout(0, 0, 0));
            wrapperPanel.add(this.myPreviewLabel);
            this.add((Component)wrapperPanel, "Center");
        }
        this.applyLaf(myDefaultTheme, this);
        this.myInitial = false;
    }

    protected void initThemes(Collection<ThemeInfo> result) {
        if (SystemInfo.isMac) {
            result.add(AQUA);
            result.add(DARCULA);
        } else if (SystemInfo.isWindows) {
            result.add(INTELLIJ);
            result.add(DARCULA);
        } else {
            result.add(INTELLIJ);
            result.add(DARCULA);
            result.add(GTK);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width += 30;
        return size;
    }

    @Override
    public String getTitle() {
        return "UI Themes";
    }

    @Override
    public String getHTMLHeader() {
        return "<html><body><h2>Set UI theme</h2>&nbsp;</body></html>";
    }

    @Override
    public String getHTMLFooter() {
        return "UI theme can be changed later in " + CommonBundle.settingsTitle() + " | " + OptionsBundle.message((String)"configurable.group.appearance.settings.display.name", (Object[])new Object[0]) + " | " + "Appearance";
    }

    private void applyLaf(ThemeInfo theme, Component component) {
        UIManager.LookAndFeelInfo info = new UIManager.LookAndFeelInfo(theme.name, theme.laf);
        if (info == null) {
            return;
        }
        try {
            Window window;
            UIManager.setLookAndFeel(info.getClassName());
            String className = info.getClassName();
            if (!this.myInitial) {
                WelcomeWizardUtil.setWizardLAF((String)className);
            }
            if ((window = SwingUtilities.getWindowAncestor(component)) != null) {
                if (SystemInfo.isMac) {
                    window.setBackground(new Color(UIUtil.getPanelBackground().getRGB()));
                }
                SwingUtilities.updateComponentTreeUI(window);
            }
            if (ApplicationManager.getApplication() != null) {
                LafManager.getInstance().setCurrentLookAndFeel(info);
            }
            if (this.myColumnMode) {
                this.myPreviewLabel.setIcon(theme.getIcon());
                this.myPreviewLabel.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Label.disabledForeground")));
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
    }

    public static class ThemeInfo {
        public final String name;
        public final String previewFileName;
        public final String laf;
        private Icon icon;

        public ThemeInfo(String name, String previewFileName, String laf) {
            this.name = name;
            this.previewFileName = previewFileName;
            this.laf = laf;
        }

        private Icon getIcon() {
            if (this.icon == null) {
                String selector = SystemInfo.isMac ? "OSX" : (SystemInfo.isWindows ? "Windows" : "Linux");
                this.icon = IconLoader.getIcon((String)("/lafs/" + selector + this.previewFileName + ".png"));
            }
            return this.icon;
        }

        public void apply() {
        }
    }
}

