/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.scratch.LRUPopupBuilder;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.lang.Language;
import com.intellij.lang.PerFileMappings;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewScratchFileAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/scratch/NewScratchFileAction", "update"));
        }
        e.getPresentation().setEnabledAndVisible(NewScratchFileAction.isEnabled(e));
    }

    public static boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/scratch/NewScratchFileAction", "isEnabled"));
        }
        return e.getProject() != null && Registry.is((String)"ide.scratch.enabled");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/scratch/NewScratchFileAction", "actionPerformed"));
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        String text = StringUtil.notNullize((String)this.getSelectionText(editor));
        Language language = (Language)ObjectUtils.notNull(text.isEmpty() ? null : this.getLanguageFromCaret(project, editor, file), (Object)Language.ANY);
        NewScratchFileAction.openNewFile(project, language, text);
    }

    @Nullable
    public String getSelectionText(@Nullable Editor editor) {
        if (editor == null) {
            return null;
        }
        return editor.getSelectionModel().getSelectedText();
    }

    @Nullable
    public Language getLanguageFromCaret(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/NewScratchFileAction", "getLanguageFromCaret"));
        }
        if (editor == null || psiFile == null) {
            return null;
        }
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        int offset = caret.getOffset();
        PsiElement element = InjectedLanguageManager.getInstance((Project)project).findInjectedElementAt(psiFile, offset);
        PsiFile file = element != null ? element.getContainingFile() : psiFile;
        return file.getLanguage();
    }

    public static VirtualFile openNewFile(final @NotNull Project project, @NotNull Language language, @NotNull String text) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/NewScratchFileAction", "openNewFile"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/ide/scratch/NewScratchFileAction", "openNewFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/scratch/NewScratchFileAction", "openNewFile"));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("scratch");
        Language initialLanguage = language == Language.ANY ? StdLanguages.TEXT : language;
        final VirtualFile file = ScratchRootType.getInstance().createScratchFile(project, "scratch", initialLanguage, text);
        if (file != null) {
            FileEditor[] editors = FileEditorManager.getInstance((Project)project).openFile(file, true);
            if (language == Language.ANY && editors.length != 0 && editors[0] instanceof TextEditor) {
                final TextEditor textEditor = (TextEditor)editors[0];
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!textEditor.isValid()) {
                            return;
                        }
                        PerFileMappings<Language> mappings = ScratchFileService.getInstance().getScratchesMapping();
                        LRUPopupBuilder.forFileLanguages(project, file, mappings).showInBestPositionFor(textEditor.getEditor());
                    }
                });
            }
        }
        return file;
    }

    public static class LanguageAction
    extends DumbAwareAction {
        public void update(AnActionEvent e) {
            Project project = e.getProject();
            VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
            if (project == null || file == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            ScratchFileService fileService = ScratchFileService.getInstance();
            if (!(fileService.getRootType(file) instanceof ScratchRootType)) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Language lang = (Language)fileService.getScratchesMapping().getMapping(file);
            if (lang == null) {
                lang = LanguageSubstitutors.INSTANCE.substituteLanguage(((LanguageFileType)file.getFileType()).getLanguage(), file, project);
            }
            e.getPresentation().setText("Change Language (" + lang.getDisplayName() + ")...");
            e.getPresentation().setEnabledAndVisible(true);
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = e.getProject();
            VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
            if (project == null || file == null) {
                return;
            }
            PerFileMappings<Language> mapping = ScratchFileService.getInstance().getScratchesMapping();
            LRUPopupBuilder.forFileLanguages(project, file, mapping).showInBestPositionFor(e.getDataContext());
        }
    }
}

