/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;

public class MacIntelliJTextFieldUI
extends TextFieldWithPopupHandlerUI {
    public MacIntelliJTextFieldUI(JTextField textField) {
        super(textField);
    }

    public static ComponentUI createUI(JComponent c) {
        return new MacIntelliJTextFieldUI((JTextField)c);
    }

    @Override
    public void showSearchPopup() {
        Object value = this.myTextField.getClientProperty("JTextField.Search.FindPopup");
        JTextComponent editor = this.getComponent();
        if (editor != null && value instanceof JPopupMenu) {
            JPopupMenu popup = (JPopupMenu)value;
            popup.show(editor, this.getSearchIconCoord().x, editor.getHeight());
        }
    }

    private boolean hasText() {
        JTextComponent component = this.getComponent();
        return component != null && !StringUtil.isEmpty((String)component.getText());
    }

    @Override
    public TextFieldWithPopupHandlerUI.SearchAction getActionUnder(MouseEvent e) {
        int off = JBUI.scale((int)8);
        Point point = new Point(e.getX() - off, e.getY() - off);
        return point.distance(this.getSearchIconCoord()) <= (double)off ? TextFieldWithPopupHandlerUI.SearchAction.POPUP : (this.hasText() && point.distance(this.getClearIconCoord()) <= (double)off ? TextFieldWithPopupHandlerUI.SearchAction.CLEAR : null);
    }

    protected Rectangle getDrawingRect() {
        JTextField c = this.myTextField;
        JBInsets i = JBInsets.create((Insets)c.getInsets());
        int x = i.right - JBUI.scale((int)4) - JBUI.scale((int)16);
        int y = i.top - 3;
        int w = c.getWidth() - i.width() + JBUI.scale((int)41);
        int h = c.getBounds().height - i.height() + JBUI.scale((int)5);
        if (h % 2 == 1) {
            ++h;
        }
        return new Rectangle(x, y, w, h);
    }

    protected Point getSearchIconCoord() {
        Rectangle r = this.getDrawingRect();
        return new Point(r.x + JBUI.scale((int)3), r.y + (r.height - JBUI.scale((int)16)) / 2 + JBUI.scale((int)1));
    }

    protected Point getClearIconCoord() {
        Rectangle r = this.getDrawingRect();
        return new Point(r.x + r.width - JBUI.scale((int)16) - JBUI.scale((int)2), r.y + (r.height - JBUI.scale((int)16)) / 2);
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        JTextComponent c = this.getComponent();
        Container parent = c.getParent();
        Rectangle r = this.getDrawingRect();
        if (c.isOpaque() && parent != null) {
            g.setColor(parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        GraphicsConfig config = new GraphicsConfig((Graphics)g);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        if (MacIntelliJTextFieldUI.isSearchField(c)) {
            this.paintSearchField(g, c, r);
        } else {
            super.paintBackground(g);
        }
        config.restore();
    }

    protected void paintDarculaBackground(Graphics2D g, JTextComponent c, Border border) {
        if (c.isEnabled() && c.isEditable()) {
            g.setColor(c.getBackground());
        }
        int width = c.getWidth();
        int height = c.getHeight();
        Insets i = border.getBorderInsets(c);
        if (c.hasFocus()) {
            g.fillRoundRect(i.left - JBUI.scale((int)5), i.top - JBUI.scale((int)2), width - i.right - i.left + JBUI.scale((int)10), height - i.top - i.bottom + JBUI.scale((int)6), JBUI.scale((int)5), JBUI.scale((int)5));
        } else {
            g.fillRect(i.left - JBUI.scale((int)5), i.top - JBUI.scale((int)2), width - i.right - i.left + JBUI.scale((int)12), height - i.top - i.bottom + JBUI.scale((int)6));
        }
    }

    protected void paintSearchField(Graphics2D g, JTextComponent c, Rectangle r) {
        Icon searchIcon;
        g.setColor(c.getBackground());
        boolean noBorder = c.getClientProperty("JTextField.Search.noBorderRing") == Boolean.TRUE;
        int radius = r.height - 1;
        g.fillRoundRect(r.x, r.y + 1, r.width, r.height - (noBorder ? 2 : 1), radius, radius);
        g.setColor((Color)(c.isEnabled() ? Gray._100 : Gray._83));
        if (!noBorder) {
            if (c.hasFocus()) {
                DarculaUIUtil.paintSearchFocusRing(g, r);
            } else {
                g.drawRoundRect(r.x, r.y, r.width, r.height - 1, radius, radius);
            }
        }
        Point p = this.getSearchIconCoord();
        Icon icon = searchIcon = this.myTextField.getClientProperty("JTextField.Search.FindPopup") instanceof JPopupMenu ? UIManager.getIcon("TextField.darcula.searchWithHistory.icon") : UIManager.getIcon("TextField.darcula.search.icon");
        if (searchIcon == null) {
            searchIcon = IconLoader.findIcon((String)"/com/intellij/ide/ui/laf/icons/search.png", DarculaTextFieldUI.class, (boolean)true);
        }
        searchIcon.paintIcon(null, g, p.x, p.y);
        if (this.hasText()) {
            p = this.getClearIconCoord();
            Icon clearIcon = UIManager.getIcon("TextField.darcula.clear.icon");
            if (clearIcon == null) {
                clearIcon = IconLoader.findIcon((String)"/com/intellij/ide/ui/laf/icons/clear.png", DarculaTextFieldUI.class, (boolean)true);
            }
            clearIcon.paintIcon(null, g, p.x, p.y);
        }
    }

    @Override
    protected void paintSafely(Graphics g) {
        this.paintBackground(g);
        super.paintSafely(g);
    }
}

