/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.CompositePathMacroFilter;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

public class BasePathMacroManager
extends PathMacroManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.BasePathMacroManager");
    private PathMacrosImpl myPathMacros;

    public BasePathMacroManager(@Nullable PathMacros pathMacros) {
        this.myPathMacros = (PathMacrosImpl)pathMacros;
    }

    protected static void addFileHierarchyReplacements(@NotNull ExpandMacroToPathMap result, @NotNull String macroName, @Nullable String path) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/components/impl/BasePathMacroManager", "addFileHierarchyReplacements"));
        }
        if (macroName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "macroName", "com/intellij/openapi/components/impl/BasePathMacroManager", "addFileHierarchyReplacements"));
        }
        if (path != null) {
            BasePathMacroManager.addFileHierarchyReplacements(result, BasePathMacroManager.getLocalFileSystem().findFileByPath(path), '$' + macroName + '$');
        }
    }

    private static void addFileHierarchyReplacements(@NotNull ExpandMacroToPathMap result, @Nullable VirtualFile f, @NotNull String macro) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/components/impl/BasePathMacroManager", "addFileHierarchyReplacements"));
        }
        if (macro == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "macro", "com/intellij/openapi/components/impl/BasePathMacroManager", "addFileHierarchyReplacements"));
        }
        if (f == null) {
            return;
        }
        BasePathMacroManager.addFileHierarchyReplacements(result, f.getParent(), macro + "/..");
        result.put(macro, StringUtil.trimEnd((String)f.getPath(), (String)"/"));
    }

    protected static void addFileHierarchyReplacements(ReplacePathToMacroMap result, String macroName, @Nullable String path, @Nullable String stopAt) {
        if (path == null) {
            return;
        }
        String macro = '$' + macroName + '$';
        path = StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)path), (String)"/");
        boolean overwrite = true;
        while (StringUtil.isNotEmpty((String)path) && path.contains("/")) {
            result.addReplacement(path, macro, overwrite);
            if (path.equals(stopAt)) break;
            macro = macro + "/..";
            overwrite = false;
            path = StringUtil.getPackageName((String)path, (char)'/');
        }
    }

    @NotNull
    private static VirtualFileSystem getLocalFileSystem() {
        VirtualFileSystem virtualFileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        if (virtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/BasePathMacroManager", "getLocalFileSystem"));
        }
        return virtualFileSystem;
    }

    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap() {
        ExpandMacroToPathMap result = new ExpandMacroToPathMap();
        for (Map.Entry entry : PathMacroUtil.getGlobalSystemMacros().entrySet()) {
            result.addMacroExpand((String)entry.getKey(), (String)entry.getValue());
        }
        this.getPathMacros().addMacroExpands(result);
        ExpandMacroToPathMap expandMacroToPathMap = result;
        if (expandMacroToPathMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/BasePathMacroManager", "getExpandMacroMap"));
        }
        return expandMacroToPathMap;
    }

    @NotNull
    protected ReplacePathToMacroMap getReplacePathMap() {
        ReplacePathToMacroMap result = new ReplacePathToMacroMap();
        for (Map.Entry entry : PathMacroUtil.getGlobalSystemMacros().entrySet()) {
            result.addMacroReplacement((String)entry.getValue(), (String)entry.getKey());
        }
        this.getPathMacros().addMacroReplacements(result);
        ReplacePathToMacroMap replacePathToMacroMap = result;
        if (replacePathToMacroMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/BasePathMacroManager", "getReplacePathMap"));
        }
        return replacePathToMacroMap;
    }

    @Override
    @NotNull
    public TrackingPathMacroSubstitutor createTrackingSubstitutor() {
        MyTrackingPathMacroSubstitutor myTrackingPathMacroSubstitutor = new MyTrackingPathMacroSubstitutor();
        if (myTrackingPathMacroSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/BasePathMacroManager", "createTrackingSubstitutor"));
        }
        return myTrackingPathMacroSubstitutor;
    }

    @Override
    public String expandPath(String path) {
        return this.getExpandMacroMap().substitute(path, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public String collapsePath(@Nullable String path) {
        return this.getReplacePathMap().substitute(path, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public void collapsePathsRecursively(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/BasePathMacroManager", "collapsePathsRecursively"));
        }
        this.getReplacePathMap().substitute(element, SystemInfo.isFileSystemCaseSensitive, true);
    }

    @Override
    @NotNull
    public String collapsePathsRecursively(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/components/impl/BasePathMacroManager", "collapsePathsRecursively"));
        }
        String string = this.getReplacePathMap().substituteRecursively(text, SystemInfo.isFileSystemCaseSensitive);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/BasePathMacroManager", "collapsePathsRecursively"));
        }
        return string;
    }

    @Override
    public void expandPaths(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/BasePathMacroManager", "expandPaths"));
        }
        this.getExpandMacroMap().substitute(element, SystemInfo.isFileSystemCaseSensitive);
    }

    @Override
    public void collapsePaths(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/BasePathMacroManager", "collapsePaths"));
        }
        this.getReplacePathMap().substitute(element, SystemInfo.isFileSystemCaseSensitive);
    }

    @NotNull
    private PathMacrosImpl getPathMacros() {
        if (this.myPathMacros == null) {
            this.myPathMacros = PathMacrosImpl.getInstanceEx();
        }
        PathMacrosImpl pathMacrosImpl = this.myPathMacros;
        if (pathMacrosImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/BasePathMacroManager", "getPathMacros"));
        }
        return pathMacrosImpl;
    }

    protected static boolean pathsEqual(@Nullable String path1, @Nullable String path2) {
        return path1 != null && path2 != null && FileUtil.pathsEqual((String)FileUtil.toSystemIndependentName((String)path1), (String)FileUtil.toSystemIndependentName((String)path2));
    }

    private class MyTrackingPathMacroSubstitutor
    implements TrackingPathMacroSubstitutor {
        private final String myLock = new String("MyTrackingPathMacroSubstitutor.lock");
        private final MultiMap<String, String> myMacroToComponentNames = MultiMap.createSet();
        private final MultiMap<String, String> myComponentNameToMacros = MultiMap.createSet();

        private MyTrackingPathMacroSubstitutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() {
            String string = this.myLock;
            synchronized (string) {
                this.myMacroToComponentNames.clear();
                this.myComponentNameToMacros.clear();
            }
        }

        @Override
        public String expandPath(String path) {
            return BasePathMacroManager.this.getExpandMacroMap().substitute(path, SystemInfo.isFileSystemCaseSensitive);
        }

        @Override
        public String collapsePath(@Nullable String path) {
            return BasePathMacroManager.this.getReplacePathMap().substitute(path, SystemInfo.isFileSystemCaseSensitive);
        }

        @Override
        public void expandPaths(@NotNull Element element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/BasePathMacroManager$MyTrackingPathMacroSubstitutor", "expandPaths"));
            }
            BasePathMacroManager.this.getExpandMacroMap().substitute(element, SystemInfo.isFileSystemCaseSensitive);
        }

        @Override
        public void collapsePaths(@NotNull Element element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/BasePathMacroManager$MyTrackingPathMacroSubstitutor", "collapsePaths"));
            }
            BasePathMacroManager.this.getReplacePathMap().substitute(element, SystemInfo.isFileSystemCaseSensitive, false, Holder.FILTER);
        }

        public int hashCode() {
            return BasePathMacroManager.this.getExpandMacroMap().hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidateUnknownMacros(@NotNull Set<String> macros) {
            if (macros == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "macros", "com/intellij/openapi/components/impl/BasePathMacroManager$MyTrackingPathMacroSubstitutor", "invalidateUnknownMacros"));
            }
            String string = this.myLock;
            synchronized (string) {
                for (String macro : macros) {
                    Collection componentNames = this.myMacroToComponentNames.remove((Object)macro);
                    if (ContainerUtil.isEmpty((Collection)componentNames)) continue;
                    for (String component : componentNames) {
                        this.myComponentNameToMacros.remove((Object)component);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public Collection<String> getComponents(@NotNull Collection<String> macros) {
            if (macros == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "macros", "com/intellij/openapi/components/impl/BasePathMacroManager$MyTrackingPathMacroSubstitutor", "getComponents"));
            }
            String string = this.myLock;
            // MONITORENTER : string
            SmartHashSet result = new SmartHashSet();
            Iterator<String> iterator = macros.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    SmartHashSet smartHashSet = result;
                    // MONITOREXIT : string
                    if (smartHashSet != null) return smartHashSet;
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/BasePathMacroManager$MyTrackingPathMacroSubstitutor", "getComponents"));
                }
                String macro = iterator.next();
                result.addAll(this.myMacroToComponentNames.get((Object)macro));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public Collection<String> getUnknownMacros(@Nullable String componentName) {
            String string = this.myLock;
            // MONITORENTER : string
            Collection collection = componentName == null ? this.myMacroToComponentNames.keySet() : this.myComponentNameToMacros.get((Object)componentName);
            THashSet tHashSet = ContainerUtil.isEmpty((Collection)collection) ? Collections.emptyList() : new THashSet(collection);
            // MONITOREXIT : string
            if (tHashSet != null) return tHashSet;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/BasePathMacroManager$MyTrackingPathMacroSubstitutor", "getUnknownMacros"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addUnknownMacros(@NotNull String componentName, @NotNull Collection<String> unknownMacros) {
            if (componentName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/BasePathMacroManager$MyTrackingPathMacroSubstitutor", "addUnknownMacros"));
            }
            if (unknownMacros == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unknownMacros", "com/intellij/openapi/components/impl/BasePathMacroManager$MyTrackingPathMacroSubstitutor", "addUnknownMacros"));
            }
            if (unknownMacros.isEmpty()) {
                return;
            }
            LOG.debug("Registering unknown macros " + new ArrayList<String>(unknownMacros) + " in component " + componentName);
            String string = this.myLock;
            synchronized (string) {
                for (String unknownMacro : unknownMacros) {
                    this.myMacroToComponentNames.putValue((Object)unknownMacro, (Object)componentName);
                }
                this.myComponentNameToMacros.putValues((Object)componentName, unknownMacros);
            }
        }
    }

    private static class Holder {
        private static final CompositePathMacroFilter FILTER = new CompositePathMacroFilter((PathMacroFilter[])Extensions.getExtensions(PathMacrosCollector.MACRO_FILTER_EXTENSION_POINT_NAME));

        private Holder() {
        }
    }
}

