/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.impl.BasePathMacroManager;
import com.intellij.openapi.module.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

public class ModulePathMacroManager
extends BasePathMacroManager {
    private final Module myModule;

    public ModulePathMacroManager(PathMacros pathMacros, Module module) {
        super(pathMacros);
        this.myModule = module;
    }

    @Override
    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap() {
        ExpandMacroToPathMap result = new ExpandMacroToPathMap();
        if (!this.myModule.isDisposed()) {
            ModulePathMacroManager.addFileHierarchyReplacements(result, "MODULE_DIR", PathMacroUtil.getModuleDir((String)this.myModule.getModuleFilePath()));
        }
        result.putAll(super.getExpandMacroMap());
        ExpandMacroToPathMap expandMacroToPathMap = result;
        if (expandMacroToPathMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/ModulePathMacroManager", "getExpandMacroMap"));
        }
        return expandMacroToPathMap;
    }

    @Override
    @NotNull
    public ReplacePathToMacroMap getReplacePathMap() {
        ReplacePathToMacroMap result = super.getReplacePathMap();
        if (!this.myModule.isDisposed()) {
            String modulePath = PathMacroUtil.getModuleDir((String)this.myModule.getModuleFilePath());
            ModulePathMacroManager.addFileHierarchyReplacements(result, "MODULE_DIR", modulePath, PathMacroUtil.getUserHomePath());
        }
        ReplacePathToMacroMap replacePathToMacroMap = result;
        if (replacePathToMacroMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/ModulePathMacroManager", "getReplacePathMap"));
        }
        return replacePathToMacroMap;
    }
}

