/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.DirectoryStorageData;
import com.intellij.openapi.components.impl.stores.SaveSessionBase;
import com.intellij.openapi.components.impl.stores.StateStorageBase;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.store.ReadOnlyModificationException;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.TObjectObjectProcedure;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryBasedStorage
extends StateStorageBase<DirectoryStorageData> {
    private final File myDir;
    private volatile VirtualFile myVirtualFile;
    private final StateSplitter mySplitter;

    public DirectoryBasedStorage(@Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor, @NotNull File dir, @NotNull StateSplitter splitter) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "<init>"));
        }
        if (splitter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitter", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "<init>"));
        }
        super(pathMacroSubstitutor);
        this.myDir = dir;
        this.mySplitter = splitter;
    }

    public void setVirtualDir(@Nullable VirtualFile dir) {
        this.myVirtualFile = dir;
    }

    public void analyzeExternalChangesAndUpdateIfNeed(@NotNull Set<String> componentNames) {
        if (componentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentNames", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "analyzeExternalChangesAndUpdateIfNeed"));
        }
        DirectoryStorageData oldData = (DirectoryStorageData)this.myStorageData;
        DirectoryStorageData newData = this.loadData();
        this.myStorageData = newData;
        if (oldData == null) {
            componentNames.addAll(newData.getComponentNames());
        } else {
            componentNames.addAll(oldData.getComponentNames());
            componentNames.addAll(newData.getComponentNames());
        }
    }

    @Override
    @Nullable
    protected Element getStateAndArchive(@NotNull DirectoryStorageData storageData, Object component, @NotNull String componentName) {
        if (storageData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "getStateAndArchive"));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "getStateAndArchive"));
        }
        return storageData.getCompositeStateAndArchive(componentName, this.mySplitter);
    }

    @Override
    @NotNull
    protected DirectoryStorageData loadData() {
        DirectoryStorageData storageData = new DirectoryStorageData();
        storageData.loadFrom(this.getVirtualFile(), this.myPathMacroSubstitutor);
        DirectoryStorageData directoryStorageData = storageData;
        if (directoryStorageData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "loadData"));
        }
        return directoryStorageData;
    }

    @Nullable
    private VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            this.myVirtualFile = virtualFile = LocalFileSystem.getInstance().findFileByIoFile(this.myDir);
        }
        return virtualFile;
    }

    @Nullable
    public StateStorage.ExternalizationSession startExternalization() {
        return this.checkIsSavingDisabled() ? null : new MySaveSession(this, (DirectoryStorageData)this.getStorageData());
    }

    @NotNull
    public static VirtualFile createDir(@NotNull File ioDir, @NotNull Object requestor) throws IOException {
        VirtualFile parentVirtualFile;
        if (ioDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioDir", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "createDir"));
        }
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "createDir"));
        }
        ioDir.mkdirs();
        String parentFile = ioDir.getParent();
        VirtualFile virtualFile = parentVirtualFile = parentFile == null ? null : LocalFileSystem.getInstance().refreshAndFindFileByPath(parentFile.replace(File.separatorChar, '/'));
        if (parentVirtualFile == null) {
            throw new StateStorageException(ProjectBundle.message((String)"project.configuration.save.file.not.found", (Object[])new Object[]{parentFile}));
        }
        VirtualFile virtualFile2 = StorageUtil.getFile(ioDir.getName(), parentVirtualFile, requestor);
        if (virtualFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "createDir"));
        }
        return virtualFile2;
    }

    private static class MySaveSession
    extends SaveSessionBase {
        private final DirectoryBasedStorage storage;
        private final DirectoryStorageData originalStorageData;
        private DirectoryStorageData copiedStorageData;
        private final Set<String> dirtyFileNames;
        private final Set<String> removedFileNames;

        private MySaveSession(@NotNull DirectoryBasedStorage storage2, @NotNull DirectoryStorageData storageData) {
            if (storage2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MySaveSession", "<init>"));
            }
            if (storageData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MySaveSession", "<init>"));
            }
            this.dirtyFileNames = new SmartHashSet();
            this.removedFileNames = new SmartHashSet();
            this.storage = storage2;
            this.originalStorageData = storageData;
        }

        @Override
        protected void setSerializedState(@NotNull Object component, @NotNull String componentName, @Nullable Element element) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MySaveSession", "setSerializedState"));
            }
            if (componentName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MySaveSession", "setSerializedState"));
            }
            this.removedFileNames.addAll(this.originalStorageData.getFileNames(componentName));
            if (JDOMUtil.isEmpty((Element)element)) {
                this.doSetState(componentName, null, null);
            } else {
                for (Pair pair : this.storage.mySplitter.splitState(element)) {
                    this.removedFileNames.remove(pair.second);
                    this.doSetState(componentName, (String)pair.second, (Element)pair.first);
                }
                if (!this.removedFileNames.isEmpty()) {
                    for (String fileName : this.removedFileNames) {
                        this.doSetState(componentName, fileName, null);
                    }
                }
            }
        }

        private void doSetState(@NotNull String componentName, @Nullable String fileName, @Nullable Element subState) {
            if (componentName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MySaveSession", "doSetState"));
            }
            if (this.copiedStorageData == null) {
                this.copiedStorageData = DirectoryStorageData.setStateAndCloneIfNeed(componentName, fileName, subState, this.originalStorageData);
                if (this.copiedStorageData != null && fileName != null) {
                    this.dirtyFileNames.add(fileName);
                }
            } else if (this.copiedStorageData.setState(componentName, fileName, subState) != null && fileName != null) {
                this.dirtyFileNames.add(fileName);
            }
        }

        @Nullable
        public StateStorage.SaveSession createSaveSession() {
            return this.storage.checkIsSavingDisabled() || this.copiedStorageData == null ? null : this;
        }

        public void save() throws IOException {
            VirtualFile dir = this.storage.getVirtualFile();
            if (this.copiedStorageData.isEmpty()) {
                if (dir != null && dir.exists()) {
                    StorageUtil.deleteFile(this, dir);
                }
                this.storage.myStorageData = this.copiedStorageData;
                return;
            }
            if (dir == null || !dir.isValid()) {
                dir = DirectoryBasedStorage.createDir(this.storage.myDir, this);
            }
            if (!this.dirtyFileNames.isEmpty()) {
                this.saveStates(dir);
            }
            if (dir.exists() && !this.removedFileNames.isEmpty()) {
                this.deleteFiles(dir);
            }
            this.storage.myVirtualFile = dir;
            this.storage.myStorageData = this.copiedStorageData;
        }

        private void saveStates(final @NotNull VirtualFile dir) {
            if (dir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MySaveSession", "saveStates"));
            }
            final Element storeElement = new Element("component");
            for (final String componentName : this.copiedStorageData.getComponentNames()) {
                this.copiedStorageData.processComponent(componentName, new TObjectObjectProcedure<String, Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean execute(String fileName, Object state) {
                        if (!MySaveSession.this.dirtyFileNames.contains(fileName)) {
                            return true;
                        }
                        Element element = MySaveSession.this.copiedStorageData.stateToElement(fileName, state);
                        if (((MySaveSession)MySaveSession.this).storage.myPathMacroSubstitutor != null) {
                            ((MySaveSession)MySaveSession.this).storage.myPathMacroSubstitutor.collapsePaths(element);
                        }
                        try {
                            storeElement.setAttribute("name", componentName);
                            storeElement.addContent(element);
                            VirtualFile file = StorageUtil.getFile(fileName, dir, MySaveSession.this);
                            StorageUtil.writeFile(null, MySaveSession.this, file, storeElement, LineSeparator.fromString((String)(file.exists() ? (String)StorageUtil.loadFile((VirtualFile)file).second : SystemProperties.getLineSeparator())), false);
                        }
                        catch (IOException e) {
                            StateStorageBase.LOG.error((Throwable)e);
                        }
                        finally {
                            element.detach();
                        }
                        return true;
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteFiles(@NotNull VirtualFile dir) throws IOException {
            if (dir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MySaveSession", "deleteFiles"));
            }
            AccessToken token = WriteAction.start();
            try {
                for (VirtualFile file : dir.getChildren()) {
                    if (!this.removedFileNames.contains(file.getName())) continue;
                    try {
                        file.delete((Object)this);
                    }
                    catch (FileNotFoundException e) {
                        throw new ReadOnlyModificationException(file, e, null);
                    }
                }
            }
            finally {
                token.finish();
            }
        }
    }
}

