/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.StateStorageBase;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.components.impl.stores.XmlElementStorage;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Set;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileBasedStorage
extends XmlElementStorage {
    private File myFile;
    private volatile VirtualFile myCachedVirtualFile;
    private LineSeparator myLineSeparator;

    public FileBasedStorage(@NotNull File file, @NotNull String fileSpec, @Nullable RoamingType roamingType, @Nullable TrackingPathMacroSubstitutor pathMacroManager, @NotNull String rootElementName, @Nullable StreamProvider streamProvider) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/components/impl/stores/FileBasedStorage", "<init>"));
        }
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/FileBasedStorage", "<init>"));
        }
        if (rootElementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElementName", "com/intellij/openapi/components/impl/stores/FileBasedStorage", "<init>"));
        }
        super(fileSpec, roamingType, pathMacroManager, rootElementName, streamProvider);
        if (ApplicationManager.getApplication().isUnitTestMode() && StringUtil.startsWithChar((CharSequence)file.getPath(), (char)'$')) {
            throw new AssertionError((Object)("It seems like some macros were not expanded for path: " + file));
        }
        this.myFile = file;
    }

    public void setFile(@Nullable VirtualFile file, @Nullable File ioFileIfChanged) {
        this.myCachedVirtualFile = file;
        if (ioFileIfChanged != null) {
            this.myFile = ioFileIfChanged;
        }
    }

    protected boolean isUseXmlProlog() {
        return false;
    }

    @Override
    @NotNull
    protected XmlElementStorage.XmlElementStorageSaveSession createSaveSession(@NotNull StorageData storageData) {
        if (storageData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/components/impl/stores/FileBasedStorage", "createSaveSession"));
        }
        FileSaveSession fileSaveSession = new FileSaveSession(storageData);
        if (fileSaveSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/FileBasedStorage", "createSaveSession"));
        }
        return fileSaveSession;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myCachedVirtualFile;
        if (virtualFile == null) {
            this.myCachedVirtualFile = virtualFile = LocalFileSystem.getInstance().findFileByIoFile(this.myFile);
        }
        return virtualFile;
    }

    @NotNull
    public File getFile() {
        File file = this.myFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/FileBasedStorage", "getFile"));
        }
        return file;
    }

    @NotNull
    public String getFilePath() {
        String string = PathUtil.toSystemIndependentName((String)this.myFile.getPath());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/FileBasedStorage", "getFilePath"));
        }
        return string;
    }

    @Override
    @Nullable
    protected Element loadLocalData() {
        this.myBlockSavingTheContent = false;
        try {
            VirtualFile file = this.getVirtualFile();
            if (file == null || file.isDirectory() || !file.isValid()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Document was not loaded for " + this.myFileSpec + " file is " + (file == null ? "null" : "directory"));
                }
                return null;
            }
            if (file.getLength() == 0L) {
                return this.processReadException(null);
            }
            CharBuffer charBuffer = CharsetToolkit.UTF8_CHARSET.decode(ByteBuffer.wrap(file.contentsToByteArray()));
            this.myLineSeparator = StorageUtil.detectLineSeparators(charBuffer, this.isUseXmlProlog() ? null : LineSeparator.LF);
            return JDOMUtil.loadDocument((CharSequence)charBuffer).detachRootElement();
        }
        catch (JDOMException e) {
            return this.processReadException((Exception)((Object)e));
        }
        catch (IOException e) {
            return this.processReadException(e);
        }
    }

    @Nullable
    private Element processReadException(@Nullable Exception e) {
        boolean contentTruncated = e == null;
        boolean bl = this.myBlockSavingTheContent = !contentTruncated && (StorageUtil.isProjectOrModuleFile(this.myFileSpec) || this.myFileSpec.equals("$WORKSPACE_FILE$"));
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            if (e != null) {
                LOG.info((Throwable)e);
            }
            new Notification("System Messages", "Load Settings", "Cannot load settings from file '" + this.myFile + "': " + (e == null ? "content truncated" : e.getMessage()) + "\n" + (this.myBlockSavingTheContent ? "Please correct the file content" : "File content will be recreated"), NotificationType.WARNING).notify(null);
        }
        return null;
    }

    @Override
    public void setDefaultState(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/FileBasedStorage", "setDefaultState"));
        }
        element.setName(this.myRootElementName);
        super.setDefaultState(element);
    }

    public void updatedFromStreamProvider(@NotNull Set<String> changedComponentNames, boolean deleted) {
        if (changedComponentNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedComponentNames", "com/intellij/openapi/components/impl/stores/FileBasedStorage", "updatedFromStreamProvider"));
        }
        if (this.myRoamingType == RoamingType.DISABLED) {
            return;
        }
        try {
            Element newElement;
            Element element = newElement = deleted ? null : this.loadDataFromStreamProvider();
            if (newElement == null) {
                StorageUtil.deleteFile(this.myFile, this, this.myCachedVirtualFile);
                if (this.myStorageData != null) {
                    changedComponentNames.addAll(((StorageData)this.myStorageData).getComponentNames());
                    this.myStorageData = null;
                }
            } else if (this.myStorageData != null) {
                StorageData newStorageData = this.createStorageData();
                this.loadState(newStorageData, newElement);
                changedComponentNames.addAll(((StorageData)this.myStorageData).getChangedComponentNames(newStorageData, this.myPathMacroSubstitutor));
                this.myStorageData = newStorageData;
            }
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    public String toString() {
        return this.getFilePath();
    }

    protected class FileSaveSession
    extends XmlElementStorage.XmlElementStorageSaveSession {
        protected FileSaveSession(StorageData storageData) {
            if (storageData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/components/impl/stores/FileBasedStorage$FileSaveSession", "<init>"));
            }
            super(FileBasedStorage.this, storageData);
        }

        @Override
        protected void doSave(@Nullable Element element) throws IOException {
            if (StateStorageBase.LOG.isDebugEnabled() && FileBasedStorage.this.myFileSpec.equals("$MODULE_FILE$")) {
                StateStorageBase.LOG.debug("doSave " + FileBasedStorage.this.getFilePath());
            }
            if (FileBasedStorage.this.myStreamProvider != null && FileBasedStorage.this.myStreamProvider.getEnabled()) {
                this.saveForProvider(element == null ? null : StorageUtil.writeToBytes((Parent)element, LineSeparator.LF.getSeparatorString()), element);
            } else {
                if (FileBasedStorage.this.myLineSeparator == null) {
                    FileBasedStorage.this.myLineSeparator = FileBasedStorage.this.isUseXmlProlog() ? LineSeparator.LF : LineSeparator.getSystemLineSeparator();
                }
                VirtualFile virtualFile = FileBasedStorage.this.getVirtualFile();
                if (element == null) {
                    StorageUtil.deleteFile(FileBasedStorage.this.myFile, this, virtualFile);
                    FileBasedStorage.this.myCachedVirtualFile = null;
                } else {
                    FileBasedStorage.this.myCachedVirtualFile = StorageUtil.writeFile(FileBasedStorage.this.myFile, this, virtualFile, element, FileBasedStorage.this.isUseXmlProlog() ? FileBasedStorage.this.myLineSeparator : LineSeparator.LF, FileBasedStorage.this.isUseXmlProlog());
                }
            }
        }
    }
}

