/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentsPackage;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.components.impl.stores.UnknownMacroNotification;
import com.intellij.openapi.components.store.ReadOnlyModificationException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.event.HyperlinkEvent;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageUtil {
    static final Logger LOG = Logger.getInstance(StorageUtil.class);
    public static String DEBUG_LOG = null;
    private static final byte[] XML_PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes(CharsetToolkit.UTF8_CHARSET);
    private static final Pair<byte[], String> NON_EXISTENT_FILE_DATA = Pair.create(null, (Object)SystemProperties.getLineSeparator());

    private StorageUtil() {
    }

    public static void checkUnknownMacros(final @NotNull ComponentManager componentManager, final @NotNull Project project) {
        if (componentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentManager", "com/intellij/openapi/components/impl/stores/StorageUtil", "checkUnknownMacros"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/components/impl/stores/StorageUtil", "checkUnknownMacros"));
        }
        Application application = ApplicationManager.getApplication();
        if (!application.isHeadlessEnvironment() && !application.isUnitTestMode()) {
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(){

                @Override
                public void run() {
                    TrackingPathMacroSubstitutor substitutor = ComponentsPackage.getStateStore(componentManager).getStateStorageManager().getMacroSubstitutor();
                    if (substitutor != null) {
                        StorageUtil.notifyUnknownMacros(substitutor, project, null);
                    }
                }
            });
        }
    }

    public static void notifyUnknownMacros(@NotNull TrackingPathMacroSubstitutor substitutor, final @NotNull Project project, final @Nullable String componentName) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/openapi/components/impl/stores/StorageUtil", "notifyUnknownMacros"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/components/impl/stores/StorageUtil", "notifyUnknownMacros"));
        }
        final LinkedHashSet<String> macros = new LinkedHashSet<String>(substitutor.getUnknownMacros(componentName));
        if (macros.isEmpty()) {
            return;
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                SmartList notified = null;
                NotificationsManager manager = NotificationsManager.getNotificationsManager();
                for (UnknownMacroNotification notification : (UnknownMacroNotification[])manager.getNotificationsOfType(UnknownMacroNotification.class, project)) {
                    if (notified == null) {
                        notified = new SmartList();
                    }
                    notified.addAll(notification.getMacros());
                }
                if (!ContainerUtil.isEmpty(notified)) {
                    macros.removeAll((Collection<?>)notified);
                }
                if (!macros.isEmpty()) {
                    LOG.debug("Reporting unknown path macros " + macros + " in component " + componentName);
                    String format = "<p><i>%s</i> %s undefined. <a href=\"define\">Fix it</a></p>";
                    String productName = ApplicationNamesInfo.getInstance().getProductName();
                    String content = String.format(format, StringUtil.join((Collection)macros, (String)", "), macros.size() == 1 ? "is" : "are") + "<br>Path variables are used to substitute absolute paths " + "in " + productName + " project files " + "and allow project file sharing in version control systems.<br>" + "Some of the files describing the current project settings contain unknown path variables " + "and " + productName + " cannot restore those paths.";
                    new UnknownMacroNotification("Load Error", "Load error: undefined path variables", content, NotificationType.ERROR, new NotificationListener(){

                        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                            if (notification == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/components/impl/stores/StorageUtil$2$1", "hyperlinkUpdate"));
                            }
                            if (event == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/components/impl/stores/StorageUtil$2$1", "hyperlinkUpdate"));
                            }
                            ((ProjectEx)project).checkUnknownMacros(true);
                        }
                    }, macros).notify(project);
                }
            }
        });
    }

    @NotNull
    public static VirtualFile writeFile(@Nullable File file, @NotNull Object requestor, @Nullable VirtualFile virtualFile, @NotNull Element element, @NotNull LineSeparator lineSeparator, boolean prependXmlProlog) throws IOException {
        VirtualFile result;
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/components/impl/stores/StorageUtil", "writeFile"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/StorageUtil", "writeFile"));
        }
        if (lineSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineSeparator", "com/intellij/openapi/components/impl/stores/StorageUtil", "writeFile"));
        }
        if (!(file == null || virtualFile != null && virtualFile.isValid())) {
            result = StorageUtil.getOrCreateVirtualFile(requestor, file);
        } else {
            result = virtualFile;
            assert (result != null);
        }
        if (LOG.isDebugEnabled() || ApplicationManager.getApplication().isUnitTestMode()) {
            BufferExposingByteArrayOutputStream content = StorageUtil.writeToBytes((Parent)element, lineSeparator.getSeparatorString());
            if (StorageUtil.isEqualContent(result, lineSeparator, content)) {
                throw new IllegalStateException("Content equals, but it must be handled not on this level: " + result.getName());
            }
            if (DEBUG_LOG != null && ApplicationManager.getApplication().isUnitTestMode()) {
                DEBUG_LOG = result.getPath() + ":\n" + content + "\nOld Content:\n" + LoadTextUtil.loadText(result) + "\n---------";
            }
        }
        StorageUtil.doWrite(requestor, result, element, lineSeparator, prependXmlProlog);
        VirtualFile virtualFile2 = result;
        if (virtualFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "writeFile"));
        }
        return virtualFile2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doWrite(final @NotNull Object requestor, final @NotNull VirtualFile file, @NotNull Object content, final @NotNull LineSeparator lineSeparator, final boolean prependXmlProlog) throws IOException {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/components/impl/stores/StorageUtil", "doWrite"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/components/impl/stores/StorageUtil", "doWrite"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/components/impl/stores/StorageUtil", "doWrite"));
        }
        if (lineSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineSeparator", "com/intellij/openapi/components/impl/stores/StorageUtil", "doWrite"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Save " + file.getPresentableUrl());
        }
        AccessToken token = WriteAction.start();
        try {
            OutputStream out = file.getOutputStream(requestor);
            try {
                if (prependXmlProlog) {
                    out.write(XML_PROLOG);
                    out.write(lineSeparator.getSeparatorBytes());
                }
                if (content instanceof Element) {
                    JDOMUtil.writeParent((Parent)((Element)content), (OutputStream)out, (String)lineSeparator.getSeparatorString());
                } else {
                    ((BufferExposingByteArrayOutputStream)content).writeTo(out);
                }
            }
            finally {
                out.close();
            }
        }
        catch (FileNotFoundException e) {
            final BufferExposingByteArrayOutputStream byteArray = content instanceof Element ? StorageUtil.writeToBytes((Parent)((Element)content), lineSeparator.getSeparatorString()) : (BufferExposingByteArrayOutputStream)content;
            throw new ReadOnlyModificationException(file, e, new StateStorage.SaveSession(){

                public void save() throws IOException {
                    StorageUtil.doWrite(requestor, file, byteArray, lineSeparator, prependXmlProlog);
                }
            });
        }
        finally {
            token.finish();
        }
    }

    private static boolean isEqualContent(@NotNull VirtualFile result, @Nullable LineSeparator lineSeparatorIfPrependXmlProlog, @NotNull BufferExposingByteArrayOutputStream content) throws IOException {
        int headerLength;
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/components/impl/stores/StorageUtil", "isEqualContent"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/components/impl/stores/StorageUtil", "isEqualContent"));
        }
        int n = headerLength = lineSeparatorIfPrependXmlProlog == null ? 0 : XML_PROLOG.length + lineSeparatorIfPrependXmlProlog.getSeparatorBytes().length;
        if (result.getLength() != (long)(headerLength + content.size())) {
            return false;
        }
        byte[] oldContent = result.contentsToByteArray();
        if (!(lineSeparatorIfPrependXmlProlog == null || ArrayUtil.startsWith((byte[])oldContent, (byte[])XML_PROLOG) && ArrayUtil.startsWith((byte[])oldContent, (int)XML_PROLOG.length, (byte[])lineSeparatorIfPrependXmlProlog.getSeparatorBytes()))) {
            return false;
        }
        for (int i = headerLength; i < oldContent.length; ++i) {
            if (oldContent[i] == content.getInternalBuffer()[i - headerLength]) continue;
            return false;
        }
        return true;
    }

    public static void deleteFile(@NotNull File file, final @NotNull Object requestor, final @Nullable VirtualFile virtualFile) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/components/impl/stores/StorageUtil", "deleteFile"));
        }
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/components/impl/stores/StorageUtil", "deleteFile"));
        }
        if (virtualFile == null) {
            LOG.warn("Cannot find virtual file " + file.getAbsolutePath());
        }
        if (virtualFile == null) {
            if (file.exists()) {
                FileUtil.delete((File)file);
            }
        } else if (virtualFile.exists()) {
            try {
                StorageUtil.deleteFile(requestor, virtualFile);
            }
            catch (FileNotFoundException e) {
                throw new ReadOnlyModificationException(virtualFile, e, new StateStorage.SaveSession(){

                    public void save() throws IOException {
                        StorageUtil.deleteFile(requestor, virtualFile);
                    }
                });
            }
        }
    }

    public static void deleteFile(@NotNull Object requestor, @NotNull VirtualFile virtualFile) throws IOException {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/components/impl/stores/StorageUtil", "deleteFile"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/components/impl/stores/StorageUtil", "deleteFile"));
        }
        AccessToken token = WriteAction.start();
        try {
            virtualFile.delete(requestor);
        }
        finally {
            token.finish();
        }
    }

    @NotNull
    public static BufferExposingByteArrayOutputStream writeToBytes(@NotNull Parent element, @NotNull String lineSeparator) throws IOException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/StorageUtil", "writeToBytes"));
        }
        if (lineSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineSeparator", "com/intellij/openapi/components/impl/stores/StorageUtil", "writeToBytes"));
        }
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(512);
        JDOMUtil.writeParent((Parent)element, (OutputStream)out, (String)lineSeparator);
        BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream = out;
        if (bufferExposingByteArrayOutputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "writeToBytes"));
        }
        return bufferExposingByteArrayOutputStream;
    }

    @NotNull
    public static VirtualFile getOrCreateVirtualFile(final @Nullable Object requestor, final @NotNull File file) throws IOException {
        VirtualFile parentVirtualFile;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/components/impl/stores/StorageUtil", "getOrCreateVirtualFile"));
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            if (virtualFile2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "getOrCreateVirtualFile"));
            }
            return virtualFile2;
        }
        File absoluteFile = file.getAbsoluteFile();
        FileUtil.createParentDirs((File)absoluteFile);
        File parentFile = absoluteFile.getParentFile();
        VirtualFile virtualFile3 = parentVirtualFile = StringUtil.isEmpty((String)parentFile.getPath()) ? null : LocalFileSystem.getInstance().refreshAndFindFileByIoFile(parentFile);
        if (parentVirtualFile == null) {
            throw new IOException(ProjectBundle.message((String)"project.configuration.save.file.not.found", (Object[])new Object[]{parentFile}));
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            VirtualFile virtualFile4 = parentVirtualFile.createChildData(requestor, file.getName());
            if (virtualFile4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "getOrCreateVirtualFile"));
            }
            return virtualFile4;
        }
        VirtualFile virtualFile5 = (VirtualFile)ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){

            public VirtualFile compute() throws IOException {
                return parentVirtualFile.createChildData(requestor, file.getName());
            }
        });
        if (virtualFile5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "getOrCreateVirtualFile"));
        }
        return virtualFile5;
    }

    @NotNull
    public static Pair<byte[], String> loadFile(@Nullable VirtualFile file) throws IOException {
        if (file == null || !file.exists()) {
            Pair<byte[], String> pair = NON_EXISTENT_FILE_DATA;
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "loadFile"));
            }
            return pair;
        }
        byte[] bytes = file.contentsToByteArray();
        String lineSeparator = file.getDetectedLineSeparator();
        if (lineSeparator == null) {
            lineSeparator = StorageUtil.detectLineSeparators(CharsetToolkit.UTF8_CHARSET.decode(ByteBuffer.wrap(bytes)), null).getSeparatorString();
        }
        Pair pair = Pair.create((Object)bytes, (Object)lineSeparator);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "loadFile"));
        }
        return pair;
    }

    @NotNull
    public static LineSeparator detectLineSeparators(@NotNull CharSequence chars, @Nullable LineSeparator defaultSeparator) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/components/impl/stores/StorageUtil", "detectLineSeparators"));
        }
        int n = chars.length();
        for (int i = 0; i < n; ++i) {
            char c = chars.charAt(i);
            if (c == '\r') {
                LineSeparator lineSeparator = LineSeparator.CRLF;
                if (lineSeparator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "detectLineSeparators"));
                }
                return lineSeparator;
            }
            if (c != '\n') continue;
            LineSeparator lineSeparator = LineSeparator.LF;
            if (lineSeparator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "detectLineSeparators"));
            }
            return lineSeparator;
        }
        LineSeparator lineSeparator = defaultSeparator == null ? LineSeparator.getSystemLineSeparator() : defaultSeparator;
        if (lineSeparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "detectLineSeparators"));
        }
        return lineSeparator;
    }

    public static void delete(@NotNull StreamProvider provider, @NotNull String fileSpec, @NotNull RoamingType type) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/components/impl/stores/StorageUtil", "delete"));
        }
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/StorageUtil", "delete"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/components/impl/stores/StorageUtil", "delete"));
        }
        if (provider.isApplicable(fileSpec, type)) {
            provider.delete(fileSpec, type);
        }
    }

    public static void sendContent(@NotNull StreamProvider provider, @NotNull String fileSpec, @NotNull Element element, @NotNull RoamingType type) throws IOException {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/components/impl/stores/StorageUtil", "sendContent"));
        }
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/StorageUtil", "sendContent"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/StorageUtil", "sendContent"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/components/impl/stores/StorageUtil", "sendContent"));
        }
        BufferExposingByteArrayOutputStream content = StorageUtil.writeToBytes((Parent)element, "\n");
        provider.saveContent(fileSpec, content.getInternalBuffer(), content.size(), type);
    }

    public static boolean isProjectOrModuleFile(@NotNull String fileSpec) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/StorageUtil", "isProjectOrModuleFile"));
        }
        return "$PROJECT_FILE$".equals(fileSpec) || fileSpec.startsWith("$PROJECT_CONFIG_DIR$") || fileSpec.equals("$MODULE_FILE$");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static VirtualFile getFile(@NotNull String fileName, @NotNull VirtualFile parent, @NotNull Object requestor) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/components/impl/stores/StorageUtil", "getFile"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/components/impl/stores/StorageUtil", "getFile"));
        }
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/components/impl/stores/StorageUtil", "getFile"));
        }
        VirtualFile file = parent.findChild(fileName);
        if (file != null) {
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "getFile"));
            }
            return virtualFile;
        }
        AccessToken token = WriteAction.start();
        VirtualFile virtualFile = parent.createChildData(requestor, fileName);
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageUtil", "getFile"));
        }
        return virtualFile2;
        finally {
            token.finish();
        }
    }
}

