/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.LineLayout;
import java.awt.Graphics2D;
import java.util.Iterator;
import java.util.NoSuchElementException;

class VisualLineFragmentsIterator
implements Iterator<Fragment> {
    private final EditorView myView;
    private final Document myDocument;
    private final FoldRegion[] myRegions;
    private final Fragment myFragment = new Fragment();
    private int mySegmentStartOffset;
    private int mySegmentEndOffset;
    private int myCurrentFoldRegionIndex;
    private Iterator<LineLayout.VisualFragment> myFragmentIterator;
    private float myCurrentX;
    private int myCurrentVisualColumn;
    private LineLayout.VisualFragment myDelegate;
    private FoldRegion myFoldRegion;
    private int myCurrentStartLogicalLine;
    private int myCurrentEndLogicalLine;

    static Iterable<Fragment> create(final EditorView view, final int offset) {
        return new Iterable<Fragment>(){

            @Override
            public Iterator<Fragment> iterator() {
                return new VisualLineFragmentsIterator(view, offset);
            }
        };
    }

    private VisualLineFragmentsIterator(EditorView view, int offset) {
        this.myView = view;
        this.myDocument = view.getEditor().getDocument();
        FoldingModelImpl foldingModel = view.getEditor().getFoldingModel();
        FoldRegion[] regions = foldingModel.fetchTopLevel();
        this.myRegions = regions == null ? FoldRegion.EMPTY_ARRAY : regions;
        this.mySegmentStartOffset = EditorUtil.getNotFoldedLineStartOffset(view.getEditor(), offset);
        this.myCurrentFoldRegionIndex = foldingModel.getLastCollapsedRegionBefore(this.mySegmentStartOffset) + 1;
        this.myCurrentEndLogicalLine = this.myDocument.getLineNumber(this.mySegmentStartOffset);
        this.myCurrentX = this.myCurrentEndLogicalLine == 0 ? this.myView.getPrefixTextWidthInPixels() : 0.0f;
        this.setFragmentIterator();
    }

    private void setFragmentIterator() {
        this.mySegmentEndOffset = this.getCurrentFoldRegionStartOffset();
        if (this.mySegmentEndOffset > this.mySegmentStartOffset) {
            int line = this.myDocument.getLineNumber(this.mySegmentStartOffset);
            this.mySegmentEndOffset = Math.min(this.mySegmentEndOffset, this.myDocument.getLineEndOffset(line));
            int lineStartOffset = this.myDocument.getLineStartOffset(line);
            this.myFragmentIterator = this.myView.getLineLayout(line).getFragmentsInVisualOrder(this.myCurrentX, this.myCurrentVisualColumn, this.mySegmentStartOffset - lineStartOffset, this.mySegmentEndOffset - lineStartOffset).iterator();
        }
    }

    private int getCurrentFoldRegionStartOffset() {
        return this.myCurrentFoldRegionIndex < this.myRegions.length ? this.myRegions[this.myCurrentFoldRegionIndex].getStartOffset() : Integer.MAX_VALUE;
    }

    private float getFoldRegionWidthInPixels(FoldRegion foldRegion) {
        return this.myView.getFoldRegionLayout(foldRegion).getWidth();
    }

    private static int getFoldRegionWidthInColumns(FoldRegion foldRegion) {
        return foldRegion.getPlaceholderText().length();
    }

    private int[] getVisualColumnForXInsideFoldRegion(FoldRegion foldRegion, float x) {
        LineLayout layout = this.myView.getFoldRegionLayout(foldRegion);
        for (LineLayout.VisualFragment fragment : layout.getFragmentsInVisualOrder(0.0f)) {
            if (!(x <= fragment.getEndX())) continue;
            return fragment.xToVisualColumn(x);
        }
        return new int[]{VisualLineFragmentsIterator.getFoldRegionWidthInColumns(foldRegion), 1};
    }

    private float getXForVisualColumnInsideFoldRegion(FoldRegion foldRegion, int column) {
        LineLayout layout = this.myView.getFoldRegionLayout(foldRegion);
        for (LineLayout.VisualFragment fragment : layout.getFragmentsInVisualOrder(0.0f)) {
            if (column > fragment.getEndVisualColumn()) continue;
            return fragment.visualColumnToX(column);
        }
        return this.getFoldRegionWidthInPixels(foldRegion);
    }

    private float getXForOffsetInsideFoldRegion(FoldRegion foldRegion, int offset) {
        return offset < foldRegion.getEndOffset() ? 0.0f : this.getFoldRegionWidthInPixels(foldRegion);
    }

    @Override
    public boolean hasNext() {
        return this.mySegmentStartOffset == this.getCurrentFoldRegionStartOffset() || this.myFragmentIterator.hasNext();
    }

    @Override
    public Fragment next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.mySegmentStartOffset == this.getCurrentFoldRegionStartOffset()) {
            this.myDelegate = null;
            this.myFoldRegion = this.myRegions[this.myCurrentFoldRegionIndex];
            assert (this.myFoldRegion.isValid());
            this.mySegmentStartOffset = this.myFoldRegion.getEndOffset();
            this.myCurrentX += this.getFoldRegionWidthInPixels(this.myFoldRegion);
            this.myCurrentVisualColumn += VisualLineFragmentsIterator.getFoldRegionWidthInColumns(this.myFoldRegion);
            this.myCurrentStartLogicalLine = this.myCurrentEndLogicalLine;
            this.myCurrentEndLogicalLine = this.myDocument.getLineNumber(this.mySegmentStartOffset);
            ++this.myCurrentFoldRegionIndex;
            this.setFragmentIterator();
        } else {
            this.myDelegate = this.myFragmentIterator.next();
            this.myFoldRegion = null;
            this.myCurrentX = this.myDelegate.getEndX();
            this.myCurrentVisualColumn = this.myDelegate.getEndVisualColumn();
            this.myCurrentStartLogicalLine = this.myCurrentEndLogicalLine;
            if (!this.myFragmentIterator.hasNext()) {
                this.mySegmentStartOffset = this.mySegmentEndOffset;
            }
        }
        return this.myFragment;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    class Fragment {
        Fragment() {
        }

        boolean isCollapsedFoldRegion() {
            return VisualLineFragmentsIterator.this.myDelegate == null;
        }

        int getMinLogicalColumn() {
            return VisualLineFragmentsIterator.this.myDelegate == null ? ((VisualLineFragmentsIterator)VisualLineFragmentsIterator.this).myView.offsetToLogicalPosition((int)((VisualLineFragmentsIterator)VisualLineFragmentsIterator.this).myFoldRegion.getStartOffset()).column : VisualLineFragmentsIterator.this.myDelegate.getMinLogicalColumn();
        }

        int getMaxLogicalColumn() {
            return VisualLineFragmentsIterator.this.myDelegate == null ? ((VisualLineFragmentsIterator)VisualLineFragmentsIterator.this).myView.offsetToLogicalPosition((int)((VisualLineFragmentsIterator)VisualLineFragmentsIterator.this).myFoldRegion.getEndOffset()).column : VisualLineFragmentsIterator.this.myDelegate.getMaxLogicalColumn();
        }

        int getStartLogicalColumn() {
            return VisualLineFragmentsIterator.this.myDelegate == null ? ((VisualLineFragmentsIterator)VisualLineFragmentsIterator.this).myView.offsetToLogicalPosition((int)((VisualLineFragmentsIterator)VisualLineFragmentsIterator.this).myFoldRegion.getStartOffset()).column : VisualLineFragmentsIterator.this.myDelegate.getStartLogicalColumn();
        }

        int getEndLogicalColumn() {
            return VisualLineFragmentsIterator.this.myDelegate == null ? ((VisualLineFragmentsIterator)VisualLineFragmentsIterator.this).myView.offsetToLogicalPosition((int)((VisualLineFragmentsIterator)VisualLineFragmentsIterator.this).myFoldRegion.getEndOffset()).column : VisualLineFragmentsIterator.this.myDelegate.getEndLogicalColumn();
        }

        int getStartVisualColumn() {
            return VisualLineFragmentsIterator.this.myDelegate == null ? VisualLineFragmentsIterator.this.myCurrentVisualColumn - VisualLineFragmentsIterator.getFoldRegionWidthInColumns(VisualLineFragmentsIterator.this.myFoldRegion) : VisualLineFragmentsIterator.this.myDelegate.getStartVisualColumn();
        }

        int getEndVisualColumn() {
            return VisualLineFragmentsIterator.this.myDelegate == null ? VisualLineFragmentsIterator.this.myCurrentVisualColumn : VisualLineFragmentsIterator.this.myDelegate.getEndVisualColumn();
        }

        int getStartLogicalLine() {
            return VisualLineFragmentsIterator.this.myCurrentStartLogicalLine;
        }

        int getEndLogicalLine() {
            return VisualLineFragmentsIterator.this.myCurrentEndLogicalLine;
        }

        float getEndX() {
            return VisualLineFragmentsIterator.this.myCurrentX;
        }

        int logicalToVisualColumn(int column) {
            return VisualLineFragmentsIterator.this.myDelegate == null ? VisualLineFragmentsIterator.this.myCurrentVisualColumn - VisualLineFragmentsIterator.getFoldRegionWidthInColumns(VisualLineFragmentsIterator.this.myFoldRegion) : VisualLineFragmentsIterator.this.myDelegate.logicalToVisualColumn(column);
        }

        int visualToLogicalColumn(int column) {
            return VisualLineFragmentsIterator.this.myDelegate == null ? (column == VisualLineFragmentsIterator.this.myCurrentVisualColumn ? this.getEndLogicalColumn() : this.getStartLogicalColumn()) : VisualLineFragmentsIterator.this.myDelegate.visualToLogicalColumn(column);
        }

        int[] xToVisualColumn(float x) {
            if (VisualLineFragmentsIterator.this.myDelegate == null) {
                int[] column = VisualLineFragmentsIterator.this.getVisualColumnForXInsideFoldRegion(VisualLineFragmentsIterator.this.myFoldRegion, x - (VisualLineFragmentsIterator.this.myCurrentX - VisualLineFragmentsIterator.this.getFoldRegionWidthInPixels(VisualLineFragmentsIterator.this.myFoldRegion)));
                column[0] = column[0] + this.getStartVisualColumn();
                return column;
            }
            return VisualLineFragmentsIterator.this.myDelegate.xToVisualColumn(x);
        }

        float visualColumnToX(int column) {
            return VisualLineFragmentsIterator.this.myDelegate == null ? VisualLineFragmentsIterator.this.myCurrentX - VisualLineFragmentsIterator.this.getFoldRegionWidthInPixels(VisualLineFragmentsIterator.this.myFoldRegion) + VisualLineFragmentsIterator.this.getXForVisualColumnInsideFoldRegion(VisualLineFragmentsIterator.this.myFoldRegion, column - VisualLineFragmentsIterator.this.myCurrentVisualColumn + VisualLineFragmentsIterator.getFoldRegionWidthInColumns(VisualLineFragmentsIterator.this.myFoldRegion)) : VisualLineFragmentsIterator.this.myDelegate.visualColumnToX(column);
        }

        int getStartOffset() {
            return VisualLineFragmentsIterator.this.myDelegate == null ? VisualLineFragmentsIterator.this.myFoldRegion.getStartOffset() : VisualLineFragmentsIterator.this.myDelegate.getStartOffset() + VisualLineFragmentsIterator.this.myDocument.getLineStartOffset(VisualLineFragmentsIterator.this.myCurrentStartLogicalLine);
        }

        int getEndOffset() {
            return VisualLineFragmentsIterator.this.myDelegate == null ? VisualLineFragmentsIterator.this.myFoldRegion.getEndOffset() : VisualLineFragmentsIterator.this.myDelegate.getEndOffset() + VisualLineFragmentsIterator.this.myDocument.getLineStartOffset(VisualLineFragmentsIterator.this.myCurrentStartLogicalLine);
        }

        int getMinOffset() {
            return VisualLineFragmentsIterator.this.myDelegate == null ? VisualLineFragmentsIterator.this.myFoldRegion.getStartOffset() : VisualLineFragmentsIterator.this.myDelegate.getMinOffset() + VisualLineFragmentsIterator.this.myDocument.getLineStartOffset(VisualLineFragmentsIterator.this.myCurrentStartLogicalLine);
        }

        int getMaxOffset() {
            return VisualLineFragmentsIterator.this.myDelegate == null ? VisualLineFragmentsIterator.this.myFoldRegion.getEndOffset() : VisualLineFragmentsIterator.this.myDelegate.getMaxOffset() + VisualLineFragmentsIterator.this.myDocument.getLineStartOffset(VisualLineFragmentsIterator.this.myCurrentStartLogicalLine);
        }

        float offsetToX(int offset) {
            return VisualLineFragmentsIterator.this.myDelegate == null ? VisualLineFragmentsIterator.this.myCurrentX - VisualLineFragmentsIterator.this.getFoldRegionWidthInPixels(VisualLineFragmentsIterator.this.myFoldRegion) + VisualLineFragmentsIterator.this.getXForOffsetInsideFoldRegion(VisualLineFragmentsIterator.this.myFoldRegion, offset) : VisualLineFragmentsIterator.this.myDelegate.offsetToX(offset - VisualLineFragmentsIterator.this.myDocument.getLineStartOffset(VisualLineFragmentsIterator.this.myCurrentStartLogicalLine));
        }

        float offsetToX(float startX, int startOffset, int offset) {
            assert (VisualLineFragmentsIterator.this.myDelegate != null);
            int lineStartOffset = VisualLineFragmentsIterator.this.myDocument.getLineStartOffset(VisualLineFragmentsIterator.this.myCurrentStartLogicalLine);
            return VisualLineFragmentsIterator.this.myDelegate.offsetToX(startX, startOffset - lineStartOffset, offset - lineStartOffset);
        }

        boolean isRtl() {
            return VisualLineFragmentsIterator.this.myDelegate != null && VisualLineFragmentsIterator.this.myDelegate.isRtl();
        }

        FoldRegion getCurrentFoldRegion() {
            return VisualLineFragmentsIterator.this.myFoldRegion;
        }

        void draw(Graphics2D g, float x, float y, int startRelativeColumn, int endRelativeColumn) {
            if (VisualLineFragmentsIterator.this.myDelegate == null) {
                for (LineLayout.VisualFragment fragment : VisualLineFragmentsIterator.this.myView.getFoldRegionLayout(VisualLineFragmentsIterator.this.myFoldRegion).getFragmentsInVisualOrder(x)) {
                    int fragmentStart = fragment.getStartVisualColumn();
                    int fragmentEnd = fragment.getEndVisualColumn();
                    if (fragmentStart >= endRelativeColumn || fragmentEnd <= startRelativeColumn) continue;
                    fragment.draw(g, fragment.getStartX(), y, Math.max(0, startRelativeColumn - fragmentStart), Math.min(fragmentEnd, endRelativeColumn) - fragmentStart);
                }
            } else {
                VisualLineFragmentsIterator.this.myDelegate.draw(g, x, y, startRelativeColumn, endRelativeColumn);
            }
        }
    }
}

