/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.service.project.PlatformFacade;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.libraries.Library;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureHelper {
    @NotNull
    private final PlatformFacade myFacade;

    public ProjectStructureHelper(@NotNull PlatformFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/openapi/externalSystem/service/project/ProjectStructureHelper", "<init>"));
        }
        this.myFacade = facade;
    }

    @Nullable
    public Module findIdeModule(@NotNull ModuleData module, @NotNull Project ideProject) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/ProjectStructureHelper", "findIdeModule"));
        }
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProject", "com/intellij/openapi/externalSystem/service/project/ProjectStructureHelper", "findIdeModule"));
        }
        return this.myFacade.findIdeModule(module, ideProject);
    }

    @Nullable
    public Module findIdeModule(@NotNull String ideModuleName, @NotNull Project ideProject) {
        if (ideModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModuleName", "com/intellij/openapi/externalSystem/service/project/ProjectStructureHelper", "findIdeModule"));
        }
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProject", "com/intellij/openapi/externalSystem/service/project/ProjectStructureHelper", "findIdeModule"));
        }
        return this.myFacade.findIdeModule(ideModuleName, ideProject);
    }

    @Nullable
    public Library findIdeLibrary(@NotNull LibraryData libraryData, @NotNull Project ideProject) {
        if (libraryData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryData", "com/intellij/openapi/externalSystem/service/project/ProjectStructureHelper", "findIdeLibrary"));
        }
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProject", "com/intellij/openapi/externalSystem/service/project/ProjectStructureHelper", "findIdeLibrary"));
        }
        return this.myFacade.findIdeLibrary(libraryData, ideProject);
    }

    public static boolean isOrphanProjectLibrary(final @NotNull Library library, @NotNull Iterable<Module> ideModules) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/externalSystem/service/project/ProjectStructureHelper", "isOrphanProjectLibrary"));
        }
        if (ideModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModules", "com/intellij/openapi/externalSystem/service/project/ProjectStructureHelper", "isOrphanProjectLibrary"));
        }
        RootPolicy<Boolean> visitor = new RootPolicy<Boolean>(){

            public Boolean visitLibraryOrderEntry(LibraryOrderEntry ideDependency, Boolean value) {
                return !ideDependency.isModuleLevel() && library == ideDependency.getLibrary();
            }
        };
        for (Module module : ideModules) {
            for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                if (!((Boolean)entry.accept((RootPolicy)visitor, (Object)false)).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public ModuleOrderEntry findIdeModuleDependency(@NotNull ModuleDependencyData dependency, @NotNull ModifiableRootModel model) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/intellij/openapi/externalSystem/service/project/ProjectStructureHelper", "findIdeModuleDependency"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/externalSystem/service/project/ProjectStructureHelper", "findIdeModuleDependency"));
        }
        return this.myFacade.findIdeModuleDependency(dependency, model);
    }

    @Nullable
    public OrderEntry findIdeModuleOrderEntry(LibraryDependencyData data2, Project project) {
        return this.myFacade.findIdeModuleOrderEntry(data2, project);
    }
}

