/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.PlatformFacade;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataServiceEx;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectDataManager {
    private static final Logger LOG = Logger.getInstance((String)("#" + ProjectDataManager.class.getName()));
    private static final Key<Boolean> DATA_READY = Key.create((String)"externalSystem.data.ready");
    @NotNull
    private final NotNullLazyValue<Map<com.intellij.openapi.externalSystem.model.Key<?>, List<ProjectDataService<?, ?>>>> myServices;
    private final PlatformFacade myPlatformFacade;

    public static ProjectDataManager getInstance() {
        return (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
    }

    public ProjectDataManager(@NotNull PlatformFacade platformFacade) {
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "<init>"));
        }
        this.myServices = new NotNullLazyValue<Map<com.intellij.openapi.externalSystem.model.Key<?>, List<ProjectDataService<?, ?>>>>(){

            @NotNull
            protected Map<com.intellij.openapi.externalSystem.model.Key<?>, List<ProjectDataService<?, ?>>> compute() {
                HashMap result = ContainerUtilRt.newHashMap();
                for (ProjectDataService service2 : (ProjectDataService[])ProjectDataService.EP_NAME.getExtensions()) {
                    List services = (List)result.get(service2.getTargetDataKey());
                    if (services == null) {
                        services = ContainerUtilRt.newArrayList();
                        result.put(service2.getTargetDataKey(), services);
                    }
                    services.add(service2);
                }
                for (List services : result.values()) {
                    ExternalSystemApiUtil.orderAwareSort((List)services);
                }
                HashMap hashMap = result;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager$1", "compute"));
                }
                return hashMap;
            }
        };
        this.myPlatformFacade = platformFacade;
    }

    @Nullable
    public ProjectDataService<?, ?> getDataService(com.intellij.openapi.externalSystem.model.Key<?> key) {
        List dataServices = (List)((Map)this.myServices.getValue()).get(key);
        assert (dataServices == null || dataServices.isEmpty() || dataServices.size() == 1);
        return (ProjectDataService)ContainerUtil.getFirstItem((List)dataServices);
    }

    public void importData(@NotNull Collection<DataNode<?>> nodes, @NotNull Project project, @NotNull PlatformFacade platformFacade, boolean synchronous) {
        ProjectSystemId projectSystemId;
        ProjectData projectData;
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (project.isDisposed()) {
            return;
        }
        MultiMap grouped = ExternalSystemApiUtil.recursiveGroup(nodes);
        for (com.intellij.openapi.externalSystem.model.Key key : ((Map)this.myServices.getValue()).keySet()) {
            if (grouped.containsKey((Object)key)) continue;
            grouped.put((Object)key, Collections.emptyList());
        }
        Collection projects = grouped.get((Object)ProjectKeys.PROJECT);
        assert (projects.size() == 1 || projects.isEmpty());
        DataNode projectNode = (DataNode)ContainerUtil.getFirstItem((Collection)projects);
        if (projectNode != null) {
            projectData = (ProjectData)projectNode.getData();
            projectSystemId = ((ProjectData)projectNode.getData()).getOwner();
            ExternalProjectsDataStorage.getInstance(project).saveInclusionSettings((DataNode<ProjectData>)projectNode);
        } else {
            projectData = null;
            DataNode aModuleNode = (DataNode)ContainerUtil.getFirstItem((Collection)grouped.get((Object)ProjectKeys.MODULE));
            ProjectSystemId projectSystemId2 = projectSystemId = aModuleNode != null ? ((ModuleData)aModuleNode.getData()).getOwner() : null;
        }
        if (projectSystemId != null) {
            ExternalSystemUtil.scheduleExternalViewStructureUpdate(project, projectSystemId);
        }
        for (Map.Entry entry : grouped.entrySet()) {
            this.doImportData((com.intellij.openapi.externalSystem.model.Key)entry.getKey(), (Collection)entry.getValue(), projectData, project, platformFacade, synchronous);
        }
    }

    @Deprecated
    public <T> void importData(@NotNull com.intellij.openapi.externalSystem.model.Key<T> key, @NotNull Collection<DataNode<T>> nodes, @NotNull Project project, boolean synchronous) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        this.importData(nodes, project, synchronous);
    }

    public <T> void importData(@NotNull Collection<DataNode<T>> nodes, @NotNull Project project, boolean synchronous) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        List dummy = ContainerUtil.newSmartList();
        for (DataNode<T> node : nodes) {
            dummy.add(node);
        }
        this.importData(dummy, project, this.myPlatformFacade, synchronous);
    }

    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project, @NotNull PlatformFacade platformFacade, boolean synchronous) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        List dummy = ContainerUtil.newSmartList();
        dummy.add(node);
        this.importData(dummy, project, platformFacade, synchronous);
    }

    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project, boolean synchronous) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        this.importData(node, project, this.myPlatformFacade, synchronous);
    }

    private <T> void doImportData(@NotNull com.intellij.openapi.externalSystem.model.Key<T> key, @NotNull Collection<DataNode<?>> nodes, @Nullable ProjectData projectData, @NotNull Project project, @NotNull PlatformFacade platformFacade, boolean synchronous) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "doImportData"));
        }
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "doImportData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "doImportData"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "doImportData"));
        }
        if (project.isDisposed()) {
            return;
        }
        List toImport = ContainerUtil.newSmartList();
        List toIgnore = ContainerUtil.newSmartList();
        for (DataNode<?> node : nodes) {
            if (!key.equals((Object)node.getKey())) continue;
            if (node.isIgnored()) {
                toIgnore.add(node);
                continue;
            }
            toImport.add(node);
        }
        this.ensureTheDataIsReadyToUse(toImport);
        List services = (List)((Map)this.myServices.getValue()).get(key);
        if (services == null) {
            LOG.warn(String.format("Can't import data nodes '%s'. Reason: no service is registered for key %s. Available services for %s", toImport, key, ((Map)this.myServices.getValue()).keySet()));
        } else {
            for (ProjectDataService service2 : services) {
                if (service2 instanceof ProjectDataServiceEx) {
                    ((ProjectDataServiceEx)service2).importData((Collection)toImport, projectData, project, platformFacade, synchronous);
                    continue;
                }
                service2.importData((Collection)toImport, project, synchronous);
            }
        }
        this.ensureTheDataIsReadyToUse(toIgnore);
        if (services != null && projectData != null) {
            for (ProjectDataService service2 : services) {
                if (!(service2 instanceof ProjectDataServiceEx)) continue;
                ProjectDataServiceEx dataServiceEx = (ProjectDataServiceEx)service2;
                Computable orphanIdeDataComputable = dataServiceEx.computeOrphanData((Collection)toImport, projectData, project, platformFacade);
                dataServiceEx.removeData(orphanIdeDataComputable, (Collection)toIgnore, projectData, project, platformFacade, synchronous);
            }
        }
    }

    public void ensureTheDataIsReadyToUse(@Nullable DataNode dataNode) {
        if (dataNode == null) {
            return;
        }
        if (Boolean.TRUE.equals(dataNode.getUserData(DATA_READY))) {
            return;
        }
        ExternalSystemApiUtil.visit((DataNode)dataNode, (Consumer)new Consumer<DataNode<?>>(){

            public void consume(DataNode dataNode) {
                ProjectDataManager.this.prepareDataToUse(dataNode);
                dataNode.putUserData(DATA_READY, (Object)Boolean.TRUE);
            }
        });
    }

    @Deprecated
    public <E, I> void removeData(@NotNull com.intellij.openapi.externalSystem.model.Key<E> key, @NotNull Collection<I> toRemove, @NotNull Project project, boolean synchronous) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (toRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        List services = (List)((Map)this.myServices.getValue()).get(key);
        for (ProjectDataService service2 : services) {
            service2.removeData(toRemove, project, synchronous);
        }
    }

    public <E, I> void removeData(@NotNull com.intellij.openapi.externalSystem.model.Key<E> key, @NotNull Collection<I> toRemove, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project, @NotNull PlatformFacade platformFacade, boolean synchronous) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (toRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (toIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toIgnore", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        List services = (List)((Map)this.myServices.getValue()).get(key);
        for (ProjectDataService service2 : services) {
            if (service2 instanceof ProjectDataServiceEx) {
                ((ProjectDataServiceEx)service2).removeData((Computable)new Computable.PredefinedValueComputable(toRemove), toIgnore, projectData, project, platformFacade, synchronous);
                continue;
            }
            service2.removeData(toRemove, project, synchronous);
        }
    }

    public <E, I> void removeData(@NotNull com.intellij.openapi.externalSystem.model.Key<E> key, @NotNull Collection<I> toRemove, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project, boolean synchronous) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (toRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (toIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toIgnore", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        this.removeData(key, toRemove, toIgnore, projectData, project, this.myPlatformFacade, synchronous);
    }

    public void updateExternalProjectData(@NotNull Project project, @NotNull ExternalProjectInfo externalProjectInfo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "updateExternalProjectData"));
        }
        if (externalProjectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectInfo", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "updateExternalProjectData"));
        }
        if (!project.isDisposed()) {
            ExternalProjectsManager.getInstance(project).updateExternalProjectData(externalProjectInfo);
        }
    }

    @Nullable
    public ExternalProjectInfo getExternalProjectData(@NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "getExternalProjectData"));
        }
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "getExternalProjectData"));
        }
        if (externalProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectPath", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "getExternalProjectData"));
        }
        return !project.isDisposed() ? ExternalProjectsDataStorage.getInstance(project).get(projectSystemId, externalProjectPath) : null;
    }

    @NotNull
    public Collection<ExternalProjectInfo> getExternalProjectsData(@NotNull Project project, @NotNull ProjectSystemId projectSystemId) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "getExternalProjectsData"));
        }
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "getExternalProjectsData"));
        }
        if (!project.isDisposed()) {
            Collection<ExternalProjectInfo> collection = ExternalProjectsDataStorage.getInstance(project).list(projectSystemId);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "getExternalProjectsData"));
            }
            return collection;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "getExternalProjectsData"));
        }
        return list;
    }

    private void ensureTheDataIsReadyToUse(@NotNull Collection<DataNode<?>> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "ensureTheDataIsReadyToUse"));
        }
        for (DataNode<?> node : nodes) {
            this.ensureTheDataIsReadyToUse(node);
        }
    }

    private void prepareDataToUse(@NotNull DataNode dataNode) {
        if (dataNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataNode", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "prepareDataToUse"));
        }
        Map servicesByKey = (Map)this.myServices.getValue();
        List services = (List)servicesByKey.get(dataNode.getKey());
        if (services != null) {
            try {
                dataNode.prepareData((ClassLoader[])ContainerUtil.map2Array((Collection)services, ClassLoader.class, (Function)new Function<ProjectDataService<?, ?>, ClassLoader>(){

                    public ClassLoader fun(ProjectDataService<?, ?> service2) {
                        return service2.getClass().getClassLoader();
                    }
                }));
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
                dataNode.clear(true);
            }
        }
    }
}

