/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.preview.PreviewManager;
import com.intellij.openapi.preview.PreviewPanelProvider;
import com.intellij.openapi.preview.PreviewProviderId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.docking.DockManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePreviewPanelProvider
extends PreviewPanelProvider<VirtualFile, Pair<FileEditor[], FileEditorProvider[]>> {
    public static final PreviewProviderId<VirtualFile, Pair<FileEditor[], FileEditorProvider[]>> ID = PreviewProviderId.create("Files");
    private final FileEditorManagerImpl myManager;
    private final Project myProject;
    private final EditorWindow myWindow;
    private final EditorsSplitters myEditorsSplitters;

    public FilePreviewPanelProvider(@NotNull Project project, @NotNull FileEditorManagerImpl manager, @NotNull DockManager dockManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/FilePreviewPanelProvider", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/openapi/fileEditor/impl/FilePreviewPanelProvider", "<init>"));
        }
        if (dockManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockManager", "com/intellij/openapi/fileEditor/impl/FilePreviewPanelProvider", "<init>"));
        }
        super(ID);
        this.myProject = project;
        this.myManager = manager;
        this.myEditorsSplitters = new MyEditorsSplitters(manager, dockManager, false);
        Disposer.register((Disposable)this, (Disposable)this.myEditorsSplitters);
        this.myEditorsSplitters.createCurrentWindow();
        this.myWindow = this.myEditorsSplitters.getCurrentWindow();
        this.myWindow.setTabsPlacement(0);
    }

    public void dispose() {
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        EditorsSplitters editorsSplitters = this.myEditorsSplitters;
        if (editorsSplitters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FilePreviewPanelProvider", "getComponent"));
        }
        return editorsSplitters;
    }

    @Override
    protected Pair<FileEditor[], FileEditorProvider[]> initComponent(VirtualFile file, boolean requestFocus) {
        Pair<FileEditor[], FileEditorProvider[]> result = this.myManager.openFileWithProviders(file, requestFocus, this.myWindow);
        IdeFocusManager.findInstance().doWhenFocusSettlesDown(new Runnable(){

            @Override
            public void run() {
                FilePreviewPanelProvider.this.myWindow.requestFocus(true);
            }
        });
        return result;
    }

    @Override
    @NotNull
    protected String getTitle(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FilePreviewPanelProvider", "getTitle"));
        }
        String string = EditorTabbedContainer.calcTabTitle(this.myProject, file);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FilePreviewPanelProvider", "getTitle"));
        }
        return string;
    }

    @Override
    @Nullable
    protected Icon getIcon(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FilePreviewPanelProvider", "getIcon"));
        }
        return file.getFileType().getIcon();
    }

    @Override
    public float getMenuOrder() {
        return 0.0f;
    }

    @Override
    public void showInStandardPlace(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FilePreviewPanelProvider", "showInStandardPlace"));
        }
        EditorWindow window = this.myManager.getCurrentWindow();
        if (window == null) {
            this.myManager.getMainSplitters().createCurrentWindow();
            window = this.myManager.getCurrentWindow();
        }
        this.myManager.openFileWithProviders(file, true, window);
    }

    @Override
    public boolean isModified(VirtualFile content, boolean beforeReuse) {
        for (EditorWithProviderComposite composite : this.myEditorsSplitters.getEditorsComposites()) {
            if (!composite.isModified() || !Comparing.equal((Object)composite.getFile(), (Object)content)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void release(@NotNull VirtualFile content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/fileEditor/impl/FilePreviewPanelProvider", "release"));
        }
        this.myEditorsSplitters.closeFile(content, false);
    }

    @Override
    public boolean contentsAreEqual(@NotNull VirtualFile content1, @NotNull VirtualFile content2) {
        if (content1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content1", "com/intellij/openapi/fileEditor/impl/FilePreviewPanelProvider", "contentsAreEqual"));
        }
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content2", "com/intellij/openapi/fileEditor/impl/FilePreviewPanelProvider", "contentsAreEqual"));
        }
        return Comparing.equal((Object)content1, (Object)content2);
    }

    private class MyEditorsSplitters
    extends EditorsSplitters {
        private MyEditorsSplitters(FileEditorManagerImpl manager, DockManager dockManager, boolean createOwnDockableContainer) {
            super(manager, dockManager, createOwnDockableContainer);
        }

        @Override
        protected void afterFileClosed(VirtualFile file) {
            PreviewManager.SERVICE.close(FilePreviewPanelProvider.this.myProject, FilePreviewPanelProvider.this.getId(), file);
        }

        @Override
        protected EditorWindow createEditorWindow() {
            return new EditorWindow(this){

                @Override
                protected void onBeforeSetEditor(VirtualFile file) {
                    for (EditorWithProviderComposite composite : MyEditorsSplitters.this.getEditorsComposites()) {
                        if (!composite.isModified()) continue;
                        PreviewManager.SERVICE.moveToStandardPlaceImpl(FilePreviewPanelProvider.this.myProject, FilePreviewPanelProvider.this.getId(), composite.getFile());
                        return;
                    }
                }
            };
        }

        @Override
        public void setTabsPlacement(int tabPlacement) {
            super.setTabsPlacement(0);
        }

        @Override
        public boolean isPreview() {
            return true;
        }
    }
}

