/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentsPackage;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.impl.ModuleServiceManagerImpl;
import com.intellij.openapi.components.impl.PlatformComponentManagerImpl;
import com.intellij.openapi.components.impl.stores.FileBasedStorage;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.AreaPicoContainer;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.module.OptionManager;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.module.impl.ModuleScopeProvider;
import com.intellij.openapi.module.impl.scopes.ModuleScopeProviderImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;

public class ModuleImpl
extends PlatformComponentManagerImpl
implements ModuleEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.module.impl.ModuleImpl");
    @NotNull
    private final Project myProject;
    private boolean isModuleAdded;
    public static final Object MODULE_RENAMING_REQUESTOR = new Object();
    private String myName;
    private final ModuleScopeProvider myModuleScopeProvider;

    public ModuleImpl(@NotNull String filePath, @NotNull Project project) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleImpl", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/module/impl/ModuleImpl", "<init>"));
        }
        super((ComponentManager)project, "Module " + ModuleImpl.moduleNameByFileName(PathUtil.getFileName((String)filePath)));
        this.getPicoContainer().registerComponentInstance(Module.class, (Object)this);
        this.myProject = project;
        this.myModuleScopeProvider = new ModuleScopeProviderImpl(this);
        this.myName = ModuleImpl.moduleNameByFileName(PathUtil.getFileName((String)filePath));
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new MyVirtualFileListener(), (Disposable)this);
    }

    private void setModuleFilePath(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleImpl", "setModuleFilePath"));
        }
        String normalizedPath = FileUtilRt.toSystemIndependentName((String)filePath);
        LocalFileSystem.getInstance().refreshAndFindFileByPath(normalizedPath);
        IComponentStore store = ComponentsPackage.getStateStore(this);
        store.getStateStorageManager().clearStateStorage("$MODULE_FILE$");
        store.setPath(normalizedPath);
    }

    @Override
    protected void bootstrapPicoContainer(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/module/impl/ModuleImpl", "bootstrapPicoContainer"));
        }
        Extensions.instantiateArea((String)"IDEA_MODULE", (AreaInstance)this, (AreaInstance)((AreaInstance)this.getParentComponentManager()));
        super.bootstrapPicoContainer(name);
    }

    @NotNull
    private static FileBasedStorage getMainStorage(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/impl/ModuleImpl", "getMainStorage"));
        }
        FileBasedStorage fileBasedStorage = (FileBasedStorage)ComponentsPackage.getStateStore((ComponentManager)module).getStateStorageManager().getStateStorage("$MODULE_FILE$", RoamingType.PER_USER);
        if (fileBasedStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getMainStorage"));
        }
        return fileBasedStorage;
    }

    @Override
    public void init(final @NotNull String path, final @Nullable Runnable beforeComponentCreation) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/module/impl/ModuleImpl", "init"));
        }
        this.init(ProgressManager.getInstance().getProgressIndicator(), new Runnable(){

            @Override
            public void run() {
                ModuleImpl.this.getPicoContainer().getComponentInstance(ModuleServiceManagerImpl.class);
                ComponentsPackage.getStateStore(ModuleImpl.this).setPath(path);
                if (beforeComponentCreation != null) {
                    beforeComponentCreation.run();
                }
            }
        });
    }

    @Override
    protected void setProgressDuringInit(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/module/impl/ModuleImpl", "setProgressDuringInit"));
        }
    }

    @Override
    protected boolean isComponentSuitable(@Nullable Map<String, String> options) {
        if (!super.isComponentSuitable(options)) {
            return false;
        }
        if (options == null || options.isEmpty()) {
            return true;
        }
        for (String optionName : options.keySet()) {
            if ("workspace".equals(optionName)) continue;
            String message = "Don't specify " + optionName + " in the component registration, transform component to service and implement your logic in your getInstance() method";
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error(message);
                continue;
            }
            LOG.warn(message);
        }
        return true;
    }

    @Nullable
    public VirtualFile getModuleFile() {
        return ModuleImpl.getMainStorage(this).getVirtualFile();
    }

    @Override
    public void rename(String newName) {
        this.myName = newName;
        VirtualFile file = ModuleImpl.getMainStorage(this).getVirtualFile();
        try {
            if (file != null) {
                file.rename(MODULE_RENAMING_REQUESTOR, newName + ".iml");
            } else {
                File oldFile = new File(this.getModuleFilePath());
                File newFile = new File(oldFile.getParentFile(), newName + ".iml");
                this.setModuleFilePath(newFile.getCanonicalPath());
            }
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
    }

    @NotNull
    public String getModuleFilePath() {
        String string = ModuleImpl.getMainStorage(this).getFilePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getModuleFilePath"));
        }
        return string;
    }

    @Override
    public synchronized void dispose() {
        this.isModuleAdded = false;
        this.disposeComponents();
        Extensions.disposeArea((AreaInstance)this);
        super.dispose();
    }

    @Override
    @NotNull
    public ComponentConfig[] getMyComponentConfigsFromDescriptor(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugin", "com/intellij/openapi/module/impl/ModuleImpl", "getMyComponentConfigsFromDescriptor"));
        }
        ComponentConfig[] componentConfigArray = plugin.getModuleComponents();
        if (componentConfigArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getMyComponentConfigsFromDescriptor"));
        }
        return componentConfigArray;
    }

    @Override
    public void projectOpened() {
        for (ModuleComponent component : this.getComponentInstancesOfType(ModuleComponent.class)) {
            try {
                component.projectOpened();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public void projectClosed() {
        List<ModuleComponent> components = this.getComponentInstancesOfType(ModuleComponent.class);
        for (int i = components.size() - 1; i >= 0; --i) {
            try {
                components.get(i).projectClosed();
                continue;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getProject"));
        }
        return project;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getName"));
        }
        return string;
    }

    public boolean isLoaded() {
        return this.isModuleAdded;
    }

    @Override
    public void moduleAdded() {
        this.isModuleAdded = true;
        for (ModuleComponent component : this.getComponentInstancesOfType(ModuleComponent.class)) {
            component.moduleAdded();
        }
    }

    public void setOption(@NotNull String key, @NotNull String value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/module/impl/ModuleImpl", "setOption"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/module/impl/ModuleImpl", "setOption"));
        }
        OptionManager manager = this.getOptionManager();
        if (manager != null) {
            manager.setOption(key, value);
        }
    }

    @Nullable
    private OptionManager getOptionManager() {
        try {
            return (OptionManager)ModuleImpl.getMainStorage(this).getStorageData();
        }
        catch (StateStorageException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public void clearOption(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/module/impl/ModuleImpl", "clearOption"));
        }
        OptionManager manager = this.getOptionManager();
        if (manager != null) {
            manager.clearOption(key);
        }
    }

    public String getOptionValue(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/module/impl/ModuleImpl", "getOptionValue"));
        }
        OptionManager manager = this.getOptionManager();
        return manager == null ? null : manager.getOptionValue(key);
    }

    @NotNull
    public GlobalSearchScope getModuleScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getModuleScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleScope(includeTests);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getModuleScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleWithLibrariesScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithLibrariesScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getModuleWithLibrariesScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependenciesScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithDependenciesScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getModuleWithDependenciesScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleContentScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleContentScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getModuleContentScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleContentWithDependenciesScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleContentWithDependenciesScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getModuleContentWithDependenciesScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependenciesAndLibrariesScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithDependenciesAndLibrariesScope(includeTests);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getModuleWithDependenciesAndLibrariesScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependentsScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithDependentsScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getModuleWithDependentsScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleTestsWithDependentsScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleTestsWithDependentsScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getModuleTestsWithDependentsScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleRuntimeScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleRuntimeScope(includeTests);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getModuleRuntimeScope"));
        }
        return globalSearchScope;
    }

    @Override
    public void clearScopesCache() {
        this.myModuleScopeProvider.clearCache();
    }

    public String toString() {
        if (this.myName == null) {
            return "Module (not initialized)";
        }
        return "Module: '" + this.getName() + "'";
    }

    private static String moduleNameByFileName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/module/impl/ModuleImpl", "moduleNameByFileName"));
        }
        return StringUtil.trimEnd((String)fileName, (String)".iml");
    }

    @NotNull
    public <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "com/intellij/openapi/module/impl/ModuleImpl", "getExtensions"));
        }
        Object[] objectArray = Extensions.getArea((AreaInstance)this).getExtensionPoint(extensionPointName).getExtensions();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getExtensions"));
        }
        return objectArray;
    }

    @Override
    protected boolean logSlowComponents() {
        return super.logSlowComponents() || ApplicationInfoImpl.getShadowInstance().isEAP();
    }

    @Override
    @NotNull
    protected MutablePicoContainer createPicoContainer() {
        AreaPicoContainer areaPicoContainer = Extensions.getArea((AreaInstance)this).getPicoContainer();
        if (areaPicoContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "createPicoContainer"));
        }
        return areaPicoContainer;
    }

    private class MyVirtualFileListener
    extends VirtualFileAdapter {
        private MyVirtualFileListener() {
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            VirtualFile moduleFile;
            String moduleFilePath;
            String parentPath;
            String ancestorPath;
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/module/impl/ModuleImpl$MyVirtualFileListener", "propertyChanged"));
            }
            if (!ModuleImpl.this.isModuleAdded || MODULE_RENAMING_REQUESTOR.equals(event.getRequestor()) || !"name".equals(event.getPropertyName())) {
                return;
            }
            VirtualFile parent = event.getParent();
            if (parent != null && VfsUtilCore.isAncestor((File)new File(ancestorPath = (parentPath = parent.getPath()) + "/" + event.getOldValue()), (File)new File(moduleFilePath = ModuleImpl.this.getModuleFilePath()), (boolean)true)) {
                this.setModuleFilePath(moduleFilePath, parentPath + "/" + event.getNewValue() + "/" + FileUtil.getRelativePath((String)ancestorPath, (String)moduleFilePath, (char)'/'));
            }
            if ((moduleFile = ModuleImpl.this.getModuleFile()) != null && moduleFile.equals(event.getFile())) {
                String oldName = ModuleImpl.this.myName;
                ModuleImpl.this.myName = ModuleImpl.moduleNameByFileName(moduleFile.getName());
                ModuleManagerImpl.getInstanceImpl(ModuleImpl.this.getProject()).fireModuleRenamedByVfsEvent(ModuleImpl.this, oldName);
            }
        }

        private void setModuleFilePath(String moduleFilePath, String newFilePath) {
            ClasspathStorage.modulePathChanged(ModuleImpl.this, newFilePath);
            ModifiableModuleModel modifiableModel = ModuleManagerImpl.getInstanceImpl(ModuleImpl.this.getProject()).getModifiableModel();
            modifiableModel.setModuleFilePath((Module)ModuleImpl.this, moduleFilePath, newFilePath);
            modifiableModel.commit();
            ModuleImpl.this.setModuleFilePath(newFilePath);
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            String moduleFilePath;
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/module/impl/ModuleImpl$MyVirtualFileListener", "fileMoved"));
            }
            String dirName = event.getFileName();
            String ancestorPath = event.getOldParent().getPath() + "/" + dirName;
            if (VfsUtilCore.isAncestor((File)new File(ancestorPath), (File)new File(moduleFilePath = ModuleImpl.this.getModuleFilePath()), (boolean)true)) {
                this.setModuleFilePath(moduleFilePath, event.getNewParent().getPath() + "/" + dirName + "/" + FileUtil.getRelativePath((String)ancestorPath, (String)moduleFilePath, (char)'/'));
            }
        }
    }
}

