/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.impl.DialogWrapperPeerImpl;
import com.intellij.openapi.ui.impl.FocusTrackbackProvider;
import com.intellij.openapi.ui.impl.GlassPaneDialogWrapperPeer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.FocusTrackback;
import com.intellij.ui.PopupBorder;
import com.intellij.ui.TitlePanel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProgressDialog
implements Disposable {
    private final ProgressWindow myProgressWindow;
    private long myLastTimeDrawn = -1L;
    private volatile boolean myShouldShowBackground;
    private final Alarm myUpdateAlarm;
    boolean myWasShown;
    final Runnable myRepaintRunnable;
    private final Runnable myUpdateRequest;
    JPanel myPanel;
    private JLabel myTextLabel;
    private JBLabel myText2Label;
    private JButton myCancelButton;
    private JButton myBackgroundButton;
    private JProgressBar myProgressBar;
    private boolean myRepaintedFlag;
    private TitlePanel myTitlePanel;
    private JPanel myInnerPanel;
    DialogWrapper myPopup;
    private final Window myParentWindow;
    private Point myLastClicked;
    private static final int UPDATE_INTERVAL = 50;

    private String getTitle2Text(String fullText, int labelWidth) {
        if (fullText == null || fullText.isEmpty()) {
            return " ";
        }
        while (this.myText2Label.getFontMetrics(this.myText2Label.getFont()).stringWidth(fullText) > labelWidth) {
            int sep = fullText.indexOf(File.separatorChar, 4);
            if (sep < 0) {
                return fullText;
            }
            fullText = "..." + fullText.substring(sep);
        }
        return fullText;
    }

    public ProgressDialog(ProgressWindow progressWindow, boolean shouldShowBackground, Project project, String cancelText) {
        this.$$$setupUI$$$();
        this.myUpdateAlarm = new Alarm((Disposable)this);
        this.myRepaintRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String text = ProgressDialog.this.myProgressWindow.getText();
                double fraction = ProgressDialog.this.myProgressWindow.getFraction();
                String text2 = ProgressDialog.this.myProgressWindow.getText2();
                ProgressDialog.this.myTextLabel.setText(text != null && !text.isEmpty() ? text : " ");
                if (ProgressDialog.this.myProgressBar.isShowing()) {
                    int perc = (int)(fraction * 100.0);
                    ProgressDialog.this.myProgressBar.setIndeterminate(perc == 0 || ProgressDialog.this.myProgressWindow.isIndeterminate());
                    ProgressDialog.this.myProgressBar.setValue(perc);
                }
                ProgressDialog.this.myText2Label.setText(ProgressDialog.this.getTitle2Text(text2, ProgressDialog.this.myText2Label.getWidth()));
                ProgressDialog.this.myTitlePanel.setText(ProgressDialog.this.myProgressWindow.getTitle() != null && !ProgressDialog.this.myProgressWindow.getTitle().isEmpty() ? ProgressDialog.this.myProgressWindow.getTitle() : " ");
                ProgressDialog.this.myLastTimeDrawn = System.currentTimeMillis();
                ProgressDialog progressDialog = ProgressDialog.this;
                synchronized (progressDialog) {
                    ProgressDialog.this.myRepaintedFlag = true;
                }
            }
        };
        this.myUpdateRequest = new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.update();
            }
        };
        this.myRepaintedFlag = true;
        this.myProgressWindow = progressWindow;
        Window parentWindow = WindowManager.getInstance().suggestParentWindow(project);
        if (parentWindow == null) {
            parentWindow = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        }
        this.myParentWindow = parentWindow;
        this.initDialog(shouldShowBackground, cancelText);
    }

    public ProgressDialog(ProgressWindow progressWindow, boolean shouldShowBackground, Component parent, String cancelText) {
        this.$$$setupUI$$$();
        this.myUpdateAlarm = new Alarm((Disposable)this);
        this.myRepaintRunnable = new /* invalid duplicate definition of identical inner class */;
        this.myUpdateRequest = new /* invalid duplicate definition of identical inner class */;
        this.myRepaintedFlag = true;
        this.myProgressWindow = progressWindow;
        this.myParentWindow = parent instanceof Window ? (Window)parent : (Window)SwingUtilities.getAncestorOfClass(Window.class, parent);
        this.initDialog(shouldShowBackground, cancelText);
    }

    private void initDialog(boolean shouldShowBackground, String cancelText) {
        if (SystemInfo.isMac) {
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myText2Label);
        }
        this.myInnerPanel.setPreferredSize(new Dimension(SystemInfo.isMac ? 350 : 450, -1));
        this.myCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/progress/util/ProgressDialog$3", "actionPerformed"));
                }
                ProgressDialog.this.doCancelAction();
            }
        });
        this.myCancelButton.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/progress/util/ProgressDialog$4", "actionPerformed"));
                }
                if (ProgressDialog.this.myCancelButton.isEnabled()) {
                    ProgressDialog.this.doCancelAction();
                }
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.myShouldShowBackground = shouldShowBackground;
        if (cancelText != null) {
            this.myProgressWindow.setCancelButtonText(cancelText);
        }
        this.myProgressBar.setMaximum(100);
        this.createCenterPanel();
        this.myTitlePanel.setActive(true);
        this.myTitlePanel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/progress/util/ProgressDialog$5", "mousePressed"));
                }
                Point titleOffset = RelativePoint.getNorthWestOf((JComponent)ProgressDialog.this.myTitlePanel).getScreenPoint();
                ProgressDialog.this.myLastClicked = new RelativePoint(e).getScreenPoint();
                ((ProgressDialog)ProgressDialog.this).myLastClicked.x -= titleOffset.x;
                ((ProgressDialog)ProgressDialog.this).myLastClicked.y -= titleOffset.y;
            }
        });
        this.myTitlePanel.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseDragged(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/progress/util/ProgressDialog$6", "mouseDragged"));
                }
                if (ProgressDialog.this.myLastClicked == null) {
                    return;
                }
                Point draggedTo = new RelativePoint(e).getScreenPoint();
                draggedTo.x -= ((ProgressDialog)ProgressDialog.this).myLastClicked.x;
                draggedTo.y -= ((ProgressDialog)ProgressDialog.this).myLastClicked.y;
                if (ProgressDialog.this.myPopup != null) {
                    ProgressDialog.this.myPopup.setLocation(draggedTo);
                }
            }
        });
    }

    public void dispose() {
        ActionListener[] listeners;
        UIUtil.disposeProgress((JProgressBar)this.myProgressBar);
        UIUtil.dispose((Component)this.myTitlePanel);
        for (ActionListener listener : listeners = this.myCancelButton.getActionListeners()) {
            this.myCancelButton.removeActionListener(listener);
        }
    }

    JPanel getPanel() {
        return this.myPanel;
    }

    void setShouldShowBackground(final boolean shouldShowBackground) {
        this.myShouldShowBackground = shouldShowBackground;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.myBackgroundButton.setVisible(shouldShowBackground);
                ProgressDialog.this.myPanel.revalidate();
            }
        });
    }

    void changeCancelButtonText(String text) {
        this.myCancelButton.setText(text);
    }

    private void doCancelAction() {
        if (this.myProgressWindow.myShouldShowCancel) {
            this.myProgressWindow.cancel();
        }
    }

    void cancel() {
        this.enableCancelButtonIfNeeded(false);
    }

    void enableCancelButtonIfNeeded(final boolean enable) {
        if (this.myProgressWindow.myShouldShowCancel) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressDialog.this.myCancelButton.setEnabled(enable);
                }
            }, ModalityState.any());
        }
    }

    private void createCenterPanel() {
        if (this.myProgressWindow.myCancelText != null) {
            this.myCancelButton.setText(this.myProgressWindow.myCancelText);
        }
        this.myCancelButton.setVisible(this.myProgressWindow.myShouldShowCancel);
        this.myBackgroundButton.setVisible(this.myShouldShowBackground);
        this.myBackgroundButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/progress/util/ProgressDialog$9", "actionPerformed"));
                }
                if (ProgressDialog.this.myShouldShowBackground) {
                    ProgressDialog.this.myProgressWindow.background();
                }
            }
        });
    }

    synchronized void update() {
        if (this.myRepaintedFlag) {
            if (System.currentTimeMillis() > this.myLastTimeDrawn + 50L) {
                this.myRepaintedFlag = false;
                SwingUtilities.invokeLater(this.myRepaintRunnable);
            } else if (!this.myUpdateAlarm.isDisposed() && this.myUpdateAlarm.getActiveRequestCount() == 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!ProgressDialog.this.myUpdateAlarm.isDisposed() && ProgressDialog.this.myUpdateAlarm.getActiveRequestCount() == 0) {
                            ProgressDialog.this.myUpdateAlarm.addRequest(ProgressDialog.this.myUpdateRequest, 500, ProgressDialog.this.myProgressWindow.getModalityState());
                        }
                    }
                });
            }
        }
    }

    synchronized void background() {
        if (this.myShouldShowBackground) {
            this.myBackgroundButton.setEnabled(false);
        }
        this.hide();
    }

    void hide() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ProgressDialog.this.myPopup != null) {
                    ProgressDialog.this.myPopup.close(1);
                    ProgressDialog.this.myPopup = null;
                }
            }
        });
    }

    void show() {
        this.myWasShown = true;
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        if (this.myParentWindow == null) {
            return;
        }
        if (this.myPopup != null) {
            this.myPopup.close(1);
        }
        this.myPopup = this.myParentWindow.isShowing() ? new MyDialogWrapper(this.myParentWindow, this.myProgressWindow.myShouldShowCancel) : new MyDialogWrapper(this.myProgressWindow.myProject, this.myProgressWindow.myShouldShowCancel);
        this.myPopup.setUndecorated(true);
        if (SystemInfo.isAppleJvm) {
            this.myPopup.setTitle(this.myProgressWindow.getTitle());
        }
        if (this.myPopup.getPeer() instanceof DialogWrapperPeerImpl) {
            ((DialogWrapperPeerImpl)this.myPopup.getPeer()).setAutoRequestFocus(false);
        }
        this.myPopup.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ProgressDialog.this.myPopup != null) {
                    FocusTrackback focusTrackback;
                    if (ProgressDialog.this.myPopup.getPeer() instanceof FocusTrackbackProvider && (focusTrackback = ((FocusTrackbackProvider)ProgressDialog.this.myPopup.getPeer()).getFocusTrackback()) != null) {
                        focusTrackback.consume();
                    }
                    ProgressDialog.this.myProgressWindow.getFocusManager().requestFocus((Component)ProgressDialog.this.myCancelButton, true).doWhenDone(ProgressDialog.this.myRepaintRunnable);
                }
            }
        });
        this.myPopup.show();
    }

    boolean wasShown() {
        return this.myProgressWindow.isShowing();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TitlePanel titlePanel;
        JButton jButton;
        JButton jButton2;
        JProgressBar jProgressBar;
        JBLabel jBLabel;
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(6, 10, 10, 10), -1, -1, false, false));
        jPanel3.setOpaque(false);
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myInnerPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 2, null, null, null));
        this.myTextLabel = jLabel = new JLabel();
        jLabel.setText(" ");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 7, 0, new Dimension(0, -1), null, null));
        this.myText2Label = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.REGULAR);
        jBLabel.setText("");
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 9, 1, 7, 0, new Dimension(0, -1), null, null));
        this.myProgressBar = jProgressBar = new JProgressBar();
        jProgressBar.putClientProperty("html.disable", Boolean.FALSE);
        jPanel.add((Component)jProgressBar, new GridConstraints(1, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(" ");
        jPanel.add((Component)jLabel2, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(" ");
        jPanel.add((Component)jLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 1, 1, 2, null, null, null));
        this.myCancelButton = jButton2 = new JButton();
        jButton2.setFocusPainted(true);
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/CommonBundle").getString("button.cancel"));
        ((Component)jButton2).setEnabled(true);
        jPanel4.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myBackgroundButton = jButton = new JButton();
        jButton.setFocusPainted(true);
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/CommonBundle").getString("button.background"));
        jPanel4.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myTitlePanel = titlePanel = new TitlePanel();
        jPanel2.add((Component)titlePanel, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyDialogWrapper
    extends DialogWrapper {
        private final boolean myIsCancellable;

        public MyDialogWrapper(Project project, boolean cancellable) {
            super(project, false);
            this.init();
            this.myIsCancellable = cancellable;
        }

        public MyDialogWrapper(Component parent, boolean cancellable) {
            super(parent, false);
            this.init();
            this.myIsCancellable = cancellable;
        }

        public void doCancelAction() {
            if (this.myIsCancellable) {
                super.doCancelAction();
            }
        }

        @NotNull
        protected DialogWrapperPeer createPeer(@NotNull Component parent, boolean canBeParent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/progress/util/ProgressDialog$MyDialogWrapper", "createPeer"));
            }
            if (System.getProperty("vintage.progress") == null) {
                GlassPaneDialogWrapperPeer glassPaneDialogWrapperPeer;
                block6: {
                    try {
                        glassPaneDialogWrapperPeer = new GlassPaneDialogWrapperPeer((DialogWrapper)this, parent, canBeParent);
                        if (glassPaneDialogWrapperPeer != null) break block6;
                    }
                    catch (GlassPaneDialogWrapperPeer.GlasspanePeerUnavailableException e) {
                        DialogWrapperPeer dialogWrapperPeer = super.createPeer(parent, canBeParent);
                        if (dialogWrapperPeer == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressDialog$MyDialogWrapper", "createPeer"));
                        }
                        return dialogWrapperPeer;
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressDialog$MyDialogWrapper", "createPeer"));
                }
                return glassPaneDialogWrapperPeer;
            }
            DialogWrapperPeer dialogWrapperPeer = super.createPeer(parent, canBeParent);
            if (dialogWrapperPeer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressDialog$MyDialogWrapper", "createPeer"));
            }
            return dialogWrapperPeer;
        }

        @NotNull
        protected DialogWrapperPeer createPeer(boolean canBeParent, boolean applicationModalIfPossible) {
            DialogWrapperPeer dialogWrapperPeer = this.createPeer(null, canBeParent, applicationModalIfPossible);
            if (dialogWrapperPeer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressDialog$MyDialogWrapper", "createPeer"));
            }
            return dialogWrapperPeer;
        }

        @NotNull
        protected DialogWrapperPeer createPeer(Window owner, boolean canBeParent, boolean applicationModalIfPossible) {
            if (System.getProperty("vintage.progress") == null) {
                GlassPaneDialogWrapperPeer glassPaneDialogWrapperPeer;
                block5: {
                    try {
                        glassPaneDialogWrapperPeer = new GlassPaneDialogWrapperPeer(this, canBeParent);
                        if (glassPaneDialogWrapperPeer != null) break block5;
                    }
                    catch (GlassPaneDialogWrapperPeer.GlasspanePeerUnavailableException e) {
                        DialogWrapperPeer dialogWrapperPeer = super.createPeer(WindowManager.getInstance().suggestParentWindow(((ProgressDialog)ProgressDialog.this).myProgressWindow.myProject), canBeParent, applicationModalIfPossible);
                        if (dialogWrapperPeer == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressDialog$MyDialogWrapper", "createPeer"));
                        }
                        return dialogWrapperPeer;
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressDialog$MyDialogWrapper", "createPeer"));
                }
                return glassPaneDialogWrapperPeer;
            }
            DialogWrapperPeer dialogWrapperPeer = super.createPeer(WindowManager.getInstance().suggestParentWindow(((ProgressDialog)ProgressDialog.this).myProgressWindow.myProject), canBeParent, applicationModalIfPossible);
            if (dialogWrapperPeer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressDialog$MyDialogWrapper", "createPeer"));
            }
            return dialogWrapperPeer;
        }

        @NotNull
        protected DialogWrapperPeer createPeer(Project project, boolean canBeParent) {
            if (System.getProperty("vintage.progress") == null) {
                GlassPaneDialogWrapperPeer glassPaneDialogWrapperPeer;
                block5: {
                    try {
                        glassPaneDialogWrapperPeer = new GlassPaneDialogWrapperPeer((DialogWrapper)this, project, canBeParent);
                        if (glassPaneDialogWrapperPeer != null) break block5;
                    }
                    catch (GlassPaneDialogWrapperPeer.GlasspanePeerUnavailableException e) {
                        DialogWrapperPeer dialogWrapperPeer = super.createPeer(project, canBeParent);
                        if (dialogWrapperPeer == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressDialog$MyDialogWrapper", "createPeer"));
                        }
                        return dialogWrapperPeer;
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressDialog$MyDialogWrapper", "createPeer"));
                }
                return glassPaneDialogWrapperPeer;
            }
            DialogWrapperPeer dialogWrapperPeer = super.createPeer(project, canBeParent);
            if (dialogWrapperPeer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressDialog$MyDialogWrapper", "createPeer"));
            }
            return dialogWrapperPeer;
        }

        protected void init() {
            super.init();
            this.setUndecorated(true);
            ProgressDialog.this.myPanel.setBorder((Border)PopupBorder.Factory.create((boolean)true, (boolean)true));
        }

        protected boolean isProgressDialog() {
            return true;
        }

        protected JComponent createCenterPanel() {
            return ProgressDialog.this.myPanel;
        }

        @Nullable
        protected JComponent createSouthPanel() {
            return null;
        }

        @Nullable
        protected Border createContentPaneBorder() {
            return null;
        }
    }
}

