/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ProjectExtension;
import com.intellij.openapi.roots.impl.JavaLanguageLevelPusher;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.pom.java.LanguageLevel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageLevelProjectExtensionImpl
extends LanguageLevelProjectExtension {
    private static final String ASSERT_KEYWORD_ATTR = "assert-keyword";
    private static final String JDK_15_ATTR = "jdk-15";
    private static final String LANGUAGE_LEVEL = "languageLevel";
    private static final String DEFAULT_ATTRIBUTE = "default";
    private final Project myProject;
    private LanguageLevel myLanguageLevel = LanguageLevel.JDK_1_6;
    private LanguageLevel myCurrentLevel;

    public LanguageLevelProjectExtensionImpl(Project project) {
        this.myProject = project;
        this.setDefault(project.isDefault() ? Boolean.valueOf(true) : null);
    }

    public static LanguageLevelProjectExtensionImpl getInstanceImpl(Project project) {
        return (LanguageLevelProjectExtensionImpl)LanguageLevelProjectExtensionImpl.getInstance((Project)project);
    }

    private void readExternal(Element element) {
        String level = element.getAttributeValue(LANGUAGE_LEVEL);
        this.myLanguageLevel = level == null ? LanguageLevelProjectExtensionImpl.migrateFromIdea7(element) : LanguageLevel.valueOf((String)level);
        String aDefault = element.getAttributeValue(DEFAULT_ATTRIBUTE);
        this.setDefault(aDefault == null ? null : Boolean.valueOf(Boolean.parseBoolean(aDefault)));
    }

    private static LanguageLevel migrateFromIdea7(Element element) {
        boolean assertKeyword = Boolean.valueOf(element.getAttributeValue(ASSERT_KEYWORD_ATTR));
        boolean jdk15 = Boolean.valueOf(element.getAttributeValue(JDK_15_ATTR));
        if (jdk15) {
            return LanguageLevel.JDK_1_5;
        }
        if (assertKeyword) {
            return LanguageLevel.JDK_1_4;
        }
        return LanguageLevel.JDK_1_3;
    }

    private void writeExternal(Element element) {
        element.setAttribute(LANGUAGE_LEVEL, this.myLanguageLevel.name());
        Boolean aBoolean = this.getDefault();
        if (aBoolean != null) {
            element.setAttribute(DEFAULT_ATTRIBUTE, Boolean.toString(aBoolean));
        }
        this.writeAttributesForIdea7(element);
    }

    private void writeAttributesForIdea7(Element element) {
        boolean is14 = LanguageLevel.JDK_1_4.equals((Object)this.myLanguageLevel);
        boolean is15 = this.myLanguageLevel.compareTo((Enum)LanguageLevel.JDK_1_5) >= 0;
        element.setAttribute(ASSERT_KEYWORD_ATTR, Boolean.toString(is14 || is15));
        element.setAttribute(JDK_15_ATTR, Boolean.toString(is15));
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.myLanguageLevel;
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/LanguageLevelProjectExtensionImpl", "getLanguageLevel"));
        }
        return languageLevel;
    }

    public void setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", LANGUAGE_LEVEL, "com/intellij/openapi/roots/impl/LanguageLevelProjectExtensionImpl", "setLanguageLevel"));
        }
        if (this.myLanguageLevel != languageLevel) {
            this.myLanguageLevel = languageLevel;
            this.languageLevelsChanged();
        }
    }

    public void languageLevelsChanged() {
        if (!this.myProject.isDefault()) {
            JavaLanguageLevelPusher.pushLanguageLevel(this.myProject);
        }
    }

    private void projectSdkChanged(@Nullable Sdk sdk) {
        JavaSdkVersion version;
        if (this.isDefault() && sdk != null && (version = JavaSdk.getInstance().getVersion(sdk)) != null) {
            this.setLanguageLevel(version.getMaxLanguageLevel());
        }
    }

    public void setCurrentLevel(LanguageLevel level) {
        this.myCurrentLevel = level;
    }

    public LanguageLevel getCurrentLevel() {
        return this.myCurrentLevel;
    }

    public static class MyProjectExtension
    extends ProjectExtension {
        private final LanguageLevelProjectExtensionImpl myInstance;

        public MyProjectExtension(Project project) {
            this.myInstance = (LanguageLevelProjectExtensionImpl)LanguageLevelProjectExtension.getInstance((Project)project);
        }

        public void readExternal(Element element) throws InvalidDataException {
            this.myInstance.readExternal(element);
        }

        public void writeExternal(Element element) throws WriteExternalException {
            this.myInstance.writeExternal(element);
        }

        @Override
        public void projectSdkChanged(@Nullable Sdk sdk) {
            this.myInstance.projectSdkChanged(sdk);
        }
    }
}

