/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.util;

import com.intellij.ide.RecentProjectsManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;

public class ProjectPlaybackCall {
    public static AsyncResult<String> openProjectClone(PlaybackContext context, String path) {
        try {
            File parentDir = FileUtil.createTempDirectory((String)"funcTest", (String)"");
            File sourceDir = context.getPathMacro().resolveFile(path, context.getBaseDir());
            context.message("Cloning project: " + sourceDir.getAbsolutePath(), context.getCurrentLine());
            FileUtil.copyDir((File)sourceDir, (File)parentDir);
            File projectDir = new File(parentDir, sourceDir.getName());
            return ProjectPlaybackCall.openProject(context, projectDir.getAbsolutePath());
        }
        catch (IOException e) {
            return new AsyncResult.Rejected((Object)"Cannot create temp directory for clone");
        }
    }

    public static AsyncResult<String> openLastProject(PlaybackContext context) {
        return ProjectPlaybackCall.openProject(context, RecentProjectsManager.getInstance().getLastProjectPath());
    }

    public static AsyncResult<String> openProject(final PlaybackContext context, final String path) {
        final AsyncResult result = new AsyncResult();
        final ProjectManager pm = ProjectManager.getInstance();
        final Ref listener = new Ref();
        listener.set((Object)new ProjectManagerAdapter(){

            public void projectOpened(final Project project) {
                StartupManager.getInstance((Project)project).registerPostStartupActivity(new Runnable(){

                    @Override
                    public void run() {
                        pm.removeProjectManagerListener((ProjectManagerListener)listener.get());
                        DumbService.getInstance((Project)project).runWhenSmart(new Runnable(){

                            @Override
                            public void run() {
                                result.setDone((Object)("Opened successfully: " + project.getPresentableUrl()));
                            }
                        });
                    }
                });
            }
        });
        pm.addProjectManagerListener((ProjectManagerListener)listener.get());
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    pm.loadAndOpenProject(path);
                }
                catch (Exception e) {
                    context.error(e.getMessage(), context.getCurrentLine());
                    result.setRejected();
                }
            }
        });
        return result;
    }
}

