/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedShowHistoryAction
extends AbstractVcsAction {
    @Override
    protected void update(VcsContext context, Presentation presentation) {
        presentation.setEnabled(this.isEnabled(context));
        Project project = context.getProject();
        presentation.setVisible(project != null && ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss());
    }

    protected VcsHistoryProvider getProvider(AbstractVcs activeVcs) {
        return activeVcs.getVcsHistoryProvider();
    }

    protected boolean isEnabled(VcsContext context) {
        VirtualFile someVFile;
        FilePath selectedFile = TabbedShowHistoryAction.getSelectedFileOrNull(context);
        if (selectedFile == null) {
            return false;
        }
        Project project = context.getProject();
        if (project == null) {
            return false;
        }
        VirtualFile virtualFile = someVFile = selectedFile.getVirtualFile() != null ? selectedFile.getVirtualFile() : selectedFile.getVirtualFileParent();
        if (someVFile == null) {
            return false;
        }
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(someVFile);
        if (vcs == null) {
            return false;
        }
        VcsHistoryProvider vcsHistoryProvider = this.getProvider(vcs);
        if (vcsHistoryProvider == null) {
            return false;
        }
        if (selectedFile.isDirectory() && !vcsHistoryProvider.supportsHistoryForDirectories()) {
            return false;
        }
        if (!TabbedShowHistoryAction.canFileHaveHistory(project, someVFile)) {
            return false;
        }
        return vcsHistoryProvider.canShowHistoryFor(someVFile);
    }

    private static boolean canFileHaveHistory(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "canFileHaveHistory"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "canFileHaveHistory"));
        }
        FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(file);
        return fileStatus != FileStatus.ADDED && fileStatus != FileStatus.UNKNOWN && fileStatus != FileStatus.IGNORED;
    }

    @Nullable
    protected static FilePath getSelectedFileOrNull(VcsContext context) {
        File[] fileArray;
        FilePath result = null;
        VirtualFile[] virtualFileArray = context.getSelectedFiles();
        if (virtualFileArray.length != 0) {
            if (virtualFileArray.length > 1) {
                return null;
            }
            if (virtualFileArray.length > 0) {
                result = VcsUtil.getFilePath((VirtualFile)virtualFileArray[0]);
            }
        }
        if ((fileArray = context.getSelectedIOFiles()) != null && fileArray.length > 0) {
            for (File file : fileArray) {
                VirtualFile parent;
                File parentIoFile = file.getParentFile();
                if (parentIoFile == null || (parent = LocalFileSystem.getInstance().findFileByIoFile(parentIoFile)) == null) continue;
                FilePath child = VcsUtil.getFilePath((VirtualFile)parent, (String)file.getName());
                if (result != null) {
                    return null;
                }
                result = child;
            }
        }
        return result;
    }

    @Override
    protected void actionPerformed(@NotNull VcsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction", "actionPerformed"));
        }
        FilePath path = TabbedShowHistoryAction.getSelectedFileOrNull(context);
        if (path == null) {
            return;
        }
        Project project = context.getProject();
        VirtualFile someVFile = path.getVirtualFile() != null ? path.getVirtualFile() : path.getVirtualFileParent();
        AbstractVcs activeVcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(someVFile);
        assert (activeVcs != null);
        VcsHistoryProvider vcsHistoryProvider = this.getProvider(activeVcs);
        AbstractVcsHelper.getInstance((Project)project).showFileHistory(vcsHistoryProvider, activeVcs.getAnnotationProvider(), path, null, activeVcs);
    }

    protected boolean forceSyncUpdate(AnActionEvent e) {
        return true;
    }
}

