/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScheduleForAdditionAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "update"));
        }
        boolean enabled = this.thereAreUnversionedFiles(e);
        e.getPresentation().setEnabled(enabled);
        String place = e.getPlace();
        if ("ActionPlace.VcsQuickListPopupAction".equals(place) || "ChangesViewPopup".equals(place)) {
            e.getPresentation().setVisible(enabled);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "actionPerformed"));
        }
        List<VirtualFile> unversionedFiles = this.getUnversionedFiles(e);
        if (unversionedFiles.isEmpty()) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl((Project)e.getData(CommonDataKeys.PROJECT));
        changeListManager.addUnversionedFiles(changeListManager.getDefaultChangeList(), unversionedFiles, new Condition<FileStatus>(){

            public boolean value(FileStatus status) {
                return ScheduleForAdditionAction.this.isStatusForAddition(status);
            }
        });
    }

    private boolean thereAreUnversionedFiles(AnActionEvent e) {
        List<VirtualFile> unversionedFiles = ScheduleForAdditionAction.getFromChangesView(e);
        if (unversionedFiles != null && !unversionedFiles.isEmpty()) {
            return true;
        }
        VirtualFile[] files = ScheduleForAdditionAction.getFromSelection(e);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (files == null || project == null) {
            return false;
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project);
        for (VirtualFile file : files) {
            if (!this.isFileUnversioned(file, vcsManager, fileStatusManager)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private List<VirtualFile> getUnversionedFiles(AnActionEvent e) {
        List<VirtualFile> unversionedFiles = ScheduleForAdditionAction.getFromChangesView(e);
        if (unversionedFiles != null && !unversionedFiles.isEmpty()) {
            List<VirtualFile> list = unversionedFiles;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "getUnversionedFiles"));
            }
            return list;
        }
        VirtualFile[] files = ScheduleForAdditionAction.getFromSelection(e);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (files == null || project == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "getUnversionedFiles"));
            }
            return list;
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project);
        unversionedFiles = new ArrayList<VirtualFile>();
        for (VirtualFile file : files) {
            if (!this.isFileUnversioned(file, vcsManager, fileStatusManager)) continue;
            unversionedFiles.add(file);
        }
        List<VirtualFile> list = unversionedFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "getUnversionedFiles"));
        }
        return list;
    }

    private boolean isFileUnversioned(@NotNull VirtualFile file, @NotNull ProjectLevelVcsManager vcsManager, @NotNull FileStatusManager fileStatusManager) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "isFileUnversioned"));
        }
        if (vcsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsManager", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "isFileUnversioned"));
        }
        if (fileStatusManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileStatusManager", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "isFileUnversioned"));
        }
        AbstractVcs vcs = vcsManager.getVcsFor(file);
        return vcs != null && !vcs.areDirectoriesVersionedItems() && file.isDirectory() || this.isStatusForAddition(fileStatusManager.getStatus(file));
    }

    protected boolean isStatusForAddition(FileStatus status) {
        return status == FileStatus.UNKNOWN;
    }

    @Nullable
    private static List<VirtualFile> getFromChangesView(AnActionEvent e) {
        return (List)e.getData(ChangesListView.UNVERSIONED_FILES_DATA_KEY);
    }

    @Nullable
    private static VirtualFile[] getFromSelection(AnActionEvent e) {
        return (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext());
    }
}

