/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.FlushingDaemon;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentHashMapValueStorage;
import gnu.trove.THashSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarHandler
extends ZipHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.jar.JarHandler");
    private static final String JARS_FOLDER = "jars";
    private static final int FS_TIME_RESOLUTION = 2000;
    private final JarFileSystemImpl myFileSystem;
    private volatile File myFileWithMirrorResolved;
    private static final NotNullLazyValue<NotificationGroup> ERROR_COPY_NOTIFICATION = new NotNullLazyValue<NotificationGroup>(){

        @NotNull
        protected NotificationGroup compute() {
            NotificationGroup notificationGroup = NotificationGroup.balloonGroup((String)VfsBundle.message((String)"jar.copy.error.title", (Object[])new Object[0]));
            if (notificationGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandler$1", "compute"));
            }
            return notificationGroup;
        }
    };

    public JarHandler(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jar/JarHandler", "<init>"));
        }
        super(path);
        this.myFileSystem = (JarFileSystemImpl)JarFileSystem.getInstance();
    }

    @Override
    @NotNull
    protected File getFileToUse() {
        File fileWithMirrorResolved = this.myFileWithMirrorResolved;
        if (fileWithMirrorResolved == null) {
            File file = this.getFile();
            if (FileUtil.compareFiles((File)file, (File)(fileWithMirrorResolved = this.getMirrorFile(file))) == 0) {
                fileWithMirrorResolved = file;
            }
            this.myFileWithMirrorResolved = fileWithMirrorResolved;
        }
        File file = fileWithMirrorResolved;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandler", "getFileToUse"));
        }
        return file;
    }

    private File getMirrorFile(@NotNull File originalFile) {
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "com/intellij/openapi/vfs/impl/jar/JarHandler", "getMirrorFile"));
        }
        if (!this.myFileSystem.isMakeCopyOfJar(originalFile)) {
            return originalFile;
        }
        FileAttributes originalAttributes = FileSystemUtil.getAttributes((File)originalFile);
        if (originalAttributes == null) {
            return originalFile;
        }
        String folderPath = JarHandler.getJarsDir();
        if (!new File(folderPath).exists() && !new File(folderPath).mkdirs()) {
            return originalFile;
        }
        if (FSRecords.weHaveContentHashes) {
            return this.getMirrorWithContentHash(originalFile, originalAttributes);
        }
        String mirrorName = originalFile.getName() + "." + Integer.toHexString(originalFile.getPath().hashCode());
        File mirrorFile = new File(folderPath, mirrorName);
        FileAttributes mirrorAttributes = FileSystemUtil.getAttributes((File)mirrorFile);
        return JarHandler.mirrorDiffers(originalAttributes, mirrorAttributes, false) ? this.copyToMirror(originalFile, mirrorFile) : mirrorFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getMirrorWithContentHash(File originalFile, FileAttributes originalAttributes) {
        File mirrorFile = null;
        String jarDir = JarHandler.getJarsDir();
        try {
            String path = originalFile.getPath();
            CacheLibraryInfo info = (CacheLibraryInfo)CacheLibraryInfo.ourCachedLibraryInfo.get((Object)path);
            if (info != null && originalAttributes.length == info.myFileLength && Math.abs(originalAttributes.lastModified - info.myModificationTime) <= 2000L && !JarHandler.mirrorDiffers(originalAttributes, FileSystemUtil.getAttributes((File)(mirrorFile = new File(jarDir, info.mySnapshotPath))), true)) {
                return mirrorFile;
            }
            MessageDigest sha1 = null;
            File tempJarFile = null;
            try {
                tempJarFile = FileUtil.createTempFile((File)new File(jarDir), (String)originalFile.getName(), (String)"", (boolean)true, (boolean)false);
                DataOutputStream os = new DataOutputStream(new FileOutputStream(tempJarFile));
                try {
                    FileInputStream is = new FileInputStream(originalFile);
                    try {
                        int read;
                        sha1 = MessageDigest.getInstance("SHA1");
                        sha1.update(String.valueOf(originalAttributes.length).getBytes(Charset.defaultCharset()));
                        sha1.update((byte)0);
                        byte[] buffer = new byte[Math.min(0x100000, (int)originalAttributes.length)];
                        long totalBytes = 0L;
                        do {
                            if ((read = is.read(buffer)) < 0) {
                                break;
                            }
                            sha1.update(buffer, 0, read);
                            os.write(buffer, 0, read);
                        } while ((totalBytes += (long)read) != originalAttributes.length);
                    }
                    finally {
                        is.close();
                    }
                }
                finally {
                    os.close();
                }
            }
            catch (IOException ex) {
                File target = mirrorFile != null ? mirrorFile : (tempJarFile != null ? tempJarFile : new File(jarDir));
                this.reportIOErrorWithJars(originalFile, target, ex);
                return originalFile;
            }
            catch (NoSuchAlgorithmException ex) {
                LOG.error((Throwable)ex);
                return originalFile;
            }
            String mirrorName = JarHandler.getSnapshotName(originalFile.getName(), sha1.digest());
            mirrorFile = new File(jarDir, mirrorName);
            if (JarHandler.mirrorDiffers(originalAttributes, FileSystemUtil.getAttributes((File)mirrorFile), true)) {
                try {
                    FileUtil.delete((File)mirrorFile);
                    FileUtil.rename((File)tempJarFile, (File)mirrorFile);
                    FileUtil.setLastModified((File)mirrorFile, (long)originalAttributes.lastModified);
                }
                catch (IOException ex) {
                    this.reportIOErrorWithJars(originalFile, mirrorFile, ex);
                    return originalFile;
                }
            } else {
                FileUtil.delete((File)tempJarFile);
            }
            info = new CacheLibraryInfo(mirrorFile.getName(), originalAttributes.lastModified, originalAttributes.length);
            CacheLibraryInfo.ourCachedLibraryInfo.put((Object)path, (Object)info);
            return mirrorFile;
        }
        catch (IOException ex) {
            this.reportIOErrorWithJars(originalFile, mirrorFile != null ? mirrorFile : new File(jarDir, originalFile.getName()), ex);
            return originalFile;
        }
    }

    private static boolean mirrorDiffers(FileAttributes original, @Nullable FileAttributes mirror, boolean permitOlderMirror) {
        if (mirror == null || mirror.length != original.length) {
            return true;
        }
        long timeDiff = mirror.lastModified - original.lastModified;
        if (!permitOlderMirror) {
            timeDiff = Math.abs(timeDiff);
        }
        return timeDiff > 2000L;
    }

    private static String getSnapshotName(String name, byte[] digest) {
        StringBuilder builder = new StringBuilder(name.length() + 1 + 2 * digest.length);
        builder.append(name).append('.');
        for (byte b : digest) {
            builder.append(Character.forDigit((b & 0xF0) >> 4, 16));
            builder.append(Character.forDigit(b & 0xF, 16));
        }
        return builder.toString();
    }

    @NotNull
    private static String getJarsDir() {
        String dir = System.getProperty("jars_dir");
        String string = dir == null ? PathManager.getSystemPath() + File.separatorChar + JARS_FOLDER : dir;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandler", "getJarsDir"));
        }
        return string;
    }

    @NotNull
    private File copyToMirror(@NotNull File original, @NotNull File mirror) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/openapi/vfs/impl/jar/JarHandler", "copyToMirror"));
        }
        if (mirror == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mirror", "com/intellij/openapi/vfs/impl/jar/JarHandler", "copyToMirror"));
        }
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress != null) {
            progress.pushState();
            progress.setText(VfsBundle.message((String)"jar.copy.progress", (Object[])new Object[]{original.getPath()}));
            progress.setFraction(0.0);
        }
        try {
            FileUtil.copy((File)original, (File)mirror);
        }
        catch (IOException e) {
            this.reportIOErrorWithJars(original, mirror, e);
            File file = original;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandler", "copyToMirror"));
            }
            return file;
        }
        if (progress != null) {
            progress.popState();
        }
        File file = mirror;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandler", "copyToMirror"));
        }
        return file;
    }

    private void reportIOErrorWithJars(File original, File target, IOException e) {
        LOG.warn((Throwable)e);
        String path = original.getPath();
        this.myFileSystem.setNoCopyJarForPath(path);
        String message = VfsBundle.message((String)"jar.copy.error.message", (Object[])new Object[]{path, target.getPath(), e.getMessage()});
        ((NotificationGroup)ERROR_COPY_NOTIFICATION.getValue()).createNotification(message, NotificationType.ERROR).notify(null);
    }

    private static class CacheLibraryInfo {
        private final String mySnapshotPath;
        private final long myModificationTime;
        private final long myFileLength;
        private static final PersistentHashMap<String, CacheLibraryInfo> ourCachedLibraryInfo;
        private static final int VERSION;

        @NotNull
        private static File getVersionFile(File file) {
            File file2 = new File(file.getParentFile(), file.getName() + ".version");
            if (file2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandler$CacheLibraryInfo", "getVersionFile"));
            }
            return file2;
        }

        private static void removeStaleJarFilesIfNeeded(File snapshotInfoFile, PersistentHashMap<String, CacheLibraryInfo> info) throws IOException {
            File versionFile = CacheLibraryInfo.getVersionFile(snapshotInfoFile);
            long lastModified = versionFile.lastModified();
            if (System.currentTimeMillis() - lastModified < 2592000000L) {
                return;
            }
            THashSet availableLibrarySnapshots = new THashSet(Arrays.asList(snapshotInfoFile.getParentFile().list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    int lastDotPosition = name.lastIndexOf(46);
                    if (lastDotPosition == -1) {
                        return false;
                    }
                    String extension = name.substring(lastDotPosition + 1);
                    return extension.length() == 40 && this.consistsOfHexLetters(extension);
                }

                private boolean consistsOfHexLetters(String extension) {
                    for (int i = 0; i < extension.length(); ++i) {
                        if (Character.digit(extension.charAt(i), 16) != -1) continue;
                        return false;
                    }
                    return true;
                }
            })));
            ArrayList invalidLibraryFilePaths = ContainerUtil.newArrayList();
            ArrayList allLibraryFilePaths = ContainerUtil.newArrayList();
            MultiMap jarSnapshotFileToLibraryFilePaths = new MultiMap();
            THashSet validLibraryFilePathToJarSnapshotFilePaths = ContainerUtil.newTroveSet();
            info.processKeys((Processor)new CommonProcessors.CollectProcessor((Collection)allLibraryFilePaths));
            for (String filePath : allLibraryFilePaths) {
                CacheLibraryInfo libraryInfo = (CacheLibraryInfo)info.get((Object)filePath);
                if (libraryInfo == null) continue;
                jarSnapshotFileToLibraryFilePaths.putValue((Object)libraryInfo.mySnapshotPath, (Object)filePath);
                if (new File(filePath).exists()) {
                    validLibraryFilePathToJarSnapshotFilePaths.add(filePath);
                    continue;
                }
                invalidLibraryFilePaths.add(filePath);
            }
            for (String invalidLibraryFilePath : invalidLibraryFilePaths) {
                LOG.info("removing stale library reference:" + invalidLibraryFilePath);
                info.remove((Object)invalidLibraryFilePath);
            }
            block2: for (Map.Entry e : jarSnapshotFileToLibraryFilePaths.entrySet()) {
                for (String libraryFilePath : (Collection)e.getValue()) {
                    if (!validLibraryFilePathToJarSnapshotFilePaths.contains(libraryFilePath)) continue;
                    availableLibrarySnapshots.remove(e.getKey());
                    continue block2;
                }
            }
            for (String availableLibrarySnapshot : availableLibrarySnapshots) {
                File librarySnapshotFileToDelete = new File(snapshotInfoFile.getParentFile(), availableLibrarySnapshot);
                LOG.info("removing stale library snapshot:" + librarySnapshotFileToDelete);
                FileUtil.delete((File)librarySnapshotFileToDelete);
            }
            CacheLibraryInfo.saveVersion(versionFile);
        }

        private static void saveVersion(File versionFile) {
            try {
                DataOutputStream versionOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(versionFile)));
                try {
                    DataInputOutputUtil.writeINT((DataOutput)versionOutputStream, (int)VERSION);
                }
                finally {
                    versionOutputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static void flushCachedLibraryInfos() {
            if (ourCachedLibraryInfo.isDirty()) {
                ourCachedLibraryInfo.force();
            }
        }

        /*
         * WARNING - void declaration
         */
        private CacheLibraryInfo(@NotNull String path, long time, long l) {
            void length;
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/jar/JarHandler$CacheLibraryInfo", "<init>"));
            }
            this.mySnapshotPath = path;
            this.myModificationTime = time;
            this.myFileLength = length;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheLibraryInfo info = (CacheLibraryInfo)o;
            if (this.myFileLength != info.myFileLength) {
                return false;
            }
            if (this.myModificationTime != info.myModificationTime) {
                return false;
            }
            return this.mySnapshotPath.equals(info.mySnapshotPath);
        }

        public int hashCode() {
            int result = this.mySnapshotPath.hashCode();
            result = 31 * result + (int)(this.myModificationTime ^ this.myModificationTime >>> 32);
            result = 31 * result + (int)(this.myFileLength ^ this.myFileLength >>> 32);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            VERSION = 1 + (PersistentHashMapValueStorage.COMPRESSION_ENABLED ? 15 : 0);
            File snapshotInfoFile = new File(new File(JarHandler.getJarsDir()), "snapshots_info");
            int currentVersion = -1;
            File versionFile = CacheLibraryInfo.getVersionFile(snapshotInfoFile);
            if (versionFile.exists()) {
                try {
                    DataInputStream versionStream = new DataInputStream(new BufferedInputStream(new FileInputStream(versionFile)));
                    try {
                        currentVersion = DataInputOutputUtil.readINT((DataInput)versionStream);
                    }
                    finally {
                        versionStream.close();
                    }
                }
                catch (IOException versionStream) {
                    // empty catch block
                }
            }
            if (currentVersion != VERSION) {
                PersistentHashMap.deleteFilesStartingWith((File)snapshotInfoFile);
                CacheLibraryInfo.saveVersion(versionFile);
            }
            PersistentHashMap info = null;
            for (int i = 0; i < 2; ++i) {
                try {
                    info = new PersistentHashMap(snapshotInfoFile, (KeyDescriptor)new EnumeratorStringDescriptor(), (DataExternalizer)new DataExternalizer<CacheLibraryInfo>(){

                        public void save(@NotNull DataOutput out, CacheLibraryInfo value) throws IOException {
                            if (out == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/openapi/vfs/impl/jar/JarHandler$CacheLibraryInfo$1", "save"));
                            }
                            IOUtil.writeUTF((DataOutput)out, (String)value.mySnapshotPath);
                            out.writeLong(value.myModificationTime);
                            out.writeLong(value.myFileLength);
                        }

                        public CacheLibraryInfo read(@NotNull DataInput in) throws IOException {
                            if (in == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/openapi/vfs/impl/jar/JarHandler$CacheLibraryInfo$1", "read"));
                            }
                            return new CacheLibraryInfo(IOUtil.readUTF((DataInput)in), in.readLong(), in.readLong());
                        }
                    });
                    if (i != 0) break;
                    CacheLibraryInfo.removeStaleJarFilesIfNeeded(snapshotInfoFile, (PersistentHashMap<String, CacheLibraryInfo>)info);
                    break;
                }
                catch (IOException ex) {
                    PersistentHashMap.deleteFilesStartingWith((File)snapshotInfoFile);
                    CacheLibraryInfo.saveVersion(versionFile);
                    continue;
                }
            }
            assert (info != null);
            ourCachedLibraryInfo = info;
            FlushingDaemon.everyFiveSeconds(new Runnable(){

                @Override
                public void run() {
                    CacheLibraryInfo.flushCachedLibraryInfos();
                }
            });
            ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

                @Override
                public void run() {
                    CacheLibraryInfo.flushCachedLibraryInfos();
                }
            });
        }
    }
}

