/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.CommonBundle;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.compiler.make.ManifestBuilder;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ManifestFileConfiguration;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.util.PathUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManifestFileUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorContextImpl");
    public static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    public static final String MANIFEST_FILE_NAME = PathUtil.getFileName((String)"META-INF/MANIFEST.MF");
    public static final String MANIFEST_DIR_NAME = PathUtil.getParentPath((String)"META-INF/MANIFEST.MF");

    private ManifestFileUtil() {
    }

    @Nullable
    public static VirtualFile findManifestFile(@NotNull CompositePackagingElement<?> root, PackagingElementResolvingContext context, ArtifactType artifactType) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/packaging/impl/elements/ManifestFileUtil", "findManifestFile"));
        }
        return ArtifactUtil.findSourceFileByOutputPath(root, MANIFEST_PATH, context, artifactType);
    }

    @Nullable
    public static VirtualFile suggestManifestFileDirectory(@NotNull CompositePackagingElement<?> root, PackagingElementResolvingContext context, ArtifactType artifactType) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/packaging/impl/elements/ManifestFileUtil", "suggestManifestFileDirectory"));
        }
        VirtualFile metaInfDir = ArtifactUtil.findSourceFileByOutputPath(root, MANIFEST_DIR_NAME, context, artifactType);
        if (metaInfDir != null) {
            return metaInfDir;
        }
        final Ref sourceDir = Ref.create(null);
        final Ref sourceFile = Ref.create(null);
        ArtifactUtil.processElementsWithSubstitutions(root.getChildren(), context, artifactType, PackagingElementPath.EMPTY, new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                VirtualFile file;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packaging/impl/elements/ManifestFileUtil$1", "process"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/packaging/impl/elements/ManifestFileUtil$1", "process"));
                }
                if (element instanceof FileCopyPackagingElement) {
                    VirtualFile file2 = ((FileCopyPackagingElement)element).findFile();
                    if (file2 != null) {
                        sourceFile.set((Object)file2);
                    }
                } else if (element instanceof DirectoryCopyPackagingElement && (file = ((DirectoryCopyPackagingElement)element).findFile()) != null) {
                    sourceDir.set((Object)file);
                    return false;
                }
                return true;
            }
        });
        if (!sourceDir.isNull()) {
            return (VirtualFile)sourceDir.get();
        }
        Project project = context.getProject();
        return ManifestFileUtil.suggestBaseDir(project, (VirtualFile)sourceFile.get());
    }

    @Nullable
    public static VirtualFile suggestManifestFileDirectory(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/elements/ManifestFileUtil", "suggestManifestFileDirectory"));
        }
        OrderEnumerator enumerator = module != null ? OrderEnumerator.orderEntries((Module)module) : OrderEnumerator.orderEntries((Project)project);
        VirtualFile[] files = enumerator.withoutDepModules().withoutLibraries().withoutSdk().productionOnly().sources().getRoots();
        if (files.length > 0) {
            return files[0];
        }
        return ManifestFileUtil.suggestBaseDir(project, null);
    }

    @Nullable
    private static VirtualFile suggestBaseDir(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/elements/ManifestFileUtil", "suggestBaseDir"));
        }
        VirtualFile[] contentRoots = ProjectRootManager.getInstance((Project)project).getContentRoots();
        if (file == null && contentRoots.length > 0) {
            return contentRoots[0];
        }
        if (file != null) {
            for (VirtualFile contentRoot : contentRoots) {
                if (!VfsUtil.isAncestor((VirtualFile)contentRoot, (VirtualFile)file, (boolean)false)) continue;
                return contentRoot;
            }
        }
        return project.getBaseDir();
    }

    public static Manifest readManifest(@NotNull VirtualFile manifestFile) {
        if (manifestFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifestFile", "com/intellij/packaging/impl/elements/ManifestFileUtil", "readManifest"));
        }
        try {
            Manifest manifest;
            InputStream inputStream = manifestFile.getInputStream();
            try {
                manifest = new Manifest(inputStream);
            }
            finally {
                inputStream.close();
            }
            return manifest;
        }
        catch (IOException ignored) {
            return new Manifest();
        }
    }

    public static void updateManifest(final @NotNull VirtualFile file, @Nullable String mainClass, @Nullable List<String> classpath, boolean replaceValues) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/packaging/impl/elements/ManifestFileUtil", "updateManifest"));
        }
        final Manifest manifest = ManifestFileUtil.readManifest(file);
        Attributes mainAttributes = manifest.getMainAttributes();
        if (mainClass != null) {
            mainAttributes.put(Attributes.Name.MAIN_CLASS, mainClass);
        } else if (replaceValues) {
            mainAttributes.remove(Attributes.Name.MAIN_CLASS);
        }
        if (classpath != null && !classpath.isEmpty()) {
            List<String> updatedClasspath;
            if (replaceValues) {
                updatedClasspath = classpath;
            } else {
                updatedClasspath = new ArrayList<String>();
                String oldClasspath = (String)mainAttributes.get(Attributes.Name.CLASS_PATH);
                if (!StringUtil.isEmpty((String)oldClasspath)) {
                    updatedClasspath.addAll(StringUtil.split((String)oldClasspath, (String)" "));
                }
                for (String path : classpath) {
                    if (updatedClasspath.contains(path)) continue;
                    updatedClasspath.add(path);
                }
            }
            mainAttributes.put(Attributes.Name.CLASS_PATH, StringUtil.join(updatedClasspath, (String)" "));
        } else if (replaceValues) {
            mainAttributes.remove(Attributes.Name.CLASS_PATH);
        }
        ManifestBuilder.setVersionAttribute((Attributes)mainAttributes);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    OutputStream outputStream = file.getOutputStream(ManifestFileUtil.class);
                    try {
                        manifest.write(outputStream);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        });
    }

    @NotNull
    public static ManifestFileConfiguration createManifestFileConfiguration(@NotNull VirtualFile manifestFile) {
        if (manifestFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifestFile", "com/intellij/packaging/impl/elements/ManifestFileUtil", "createManifestFileConfiguration"));
        }
        String path = manifestFile.getPath();
        Manifest manifest = ManifestFileUtil.readManifest(manifestFile);
        String mainClass = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
        String classpathText = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        ArrayList classpath = new ArrayList();
        if (classpathText != null) {
            classpath.addAll(StringUtil.split((String)classpathText, (String)" "));
        }
        ManifestFileConfiguration manifestFileConfiguration = new ManifestFileConfiguration(path, classpath, mainClass, manifestFile.isWritable());
        if (manifestFileConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/ManifestFileUtil", "createManifestFileConfiguration"));
        }
        return manifestFileConfiguration;
    }

    public static List<String> getClasspathForElements(List<? extends PackagingElement<?>> elements, PackagingElementResolvingContext context, ArtifactType artifactType) {
        final ArrayList<String> classpath = new ArrayList<String>();
        PackagingElementProcessor processor = new PackagingElementProcessor<PackagingElement<?>>(){

            @Override
            public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packaging/impl/elements/ManifestFileUtil$3", "process"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/packaging/impl/elements/ManifestFileUtil$3", "process"));
                }
                if (element instanceof FileCopyPackagingElement) {
                    String fileName = ((FileCopyPackagingElement)element).getOutputFileName();
                    classpath.add(DeploymentUtil.appendToPath((String)path.getPathString(), (String)fileName));
                } else if (element instanceof DirectoryCopyPackagingElement) {
                    classpath.add(path.getPathString());
                } else if (element instanceof ArchivePackagingElement) {
                    String archiveName = ((ArchivePackagingElement)element).getName();
                    classpath.add(DeploymentUtil.appendToPath((String)path.getPathString(), (String)archiveName));
                }
                return true;
            }
        };
        for (PackagingElement<?> element : elements) {
            ArtifactUtil.processPackagingElements(element, null, processor, context, true, artifactType);
        }
        return classpath;
    }

    @Nullable
    public static VirtualFile showDialogAndCreateManifest(ArtifactEditorContext context, CompositePackagingElement<?> element) {
        FileChooserDescriptor descriptor = ManifestFileUtil.createDescriptorForManifestDirectory();
        VirtualFile directory = ManifestFileUtil.suggestManifestFileDirectory(element, (PackagingElementResolvingContext)context, context.getArtifactType());
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)context.getProject(), (VirtualFile)directory);
        if (file == null) {
            return null;
        }
        return ManifestFileUtil.createManifestFile(file, context.getProject());
    }

    @Nullable
    public static VirtualFile createManifestFile(final @NotNull VirtualFile directory, @NotNull Project project) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/packaging/impl/elements/ManifestFileUtil", "createManifestFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/elements/ManifestFileUtil", "createManifestFile"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final Ref exc = Ref.create(null);
        VirtualFile file = (VirtualFile)new WriteAction<VirtualFile>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void run(@NotNull Result<VirtualFile> result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/packaging/impl/elements/ManifestFileUtil$4", "run"));
                }
                VirtualFile dir = directory;
                try {
                    if (!dir.getName().equals(MANIFEST_DIR_NAME)) {
                        dir = VfsUtil.createDirectoryIfMissing((VirtualFile)dir, (String)MANIFEST_DIR_NAME);
                    }
                    VirtualFile file = dir.createChildData((Object)this, MANIFEST_FILE_NAME);
                    OutputStream output = file.getOutputStream((Object)this);
                    try {
                        Manifest manifest = new Manifest();
                        ManifestBuilder.setVersionAttribute((Attributes)manifest.getMainAttributes());
                        manifest.write(output);
                    }
                    finally {
                        output.close();
                    }
                    result.setResult((Object)file);
                }
                catch (IOException e) {
                    exc.set((Object)e);
                }
            }
        }.execute().getResultObject();
        IOException exception = (IOException)exc.get();
        if (exception != null) {
            LOG.info((Throwable)exception);
            Messages.showErrorDialog((Project)project, (String)exception.getMessage(), (String)CommonBundle.getErrorTitle());
            return null;
        }
        return file;
    }

    public static FileChooserDescriptor createDescriptorForManifestDirectory() {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setTitle("Select Directory for META-INF/MANIFEST.MF file");
        return descriptor;
    }

    public static void addManifestFileToLayout(final @NotNull String path, final @NotNull ArtifactEditorContext context, final @NotNull CompositePackagingElement<?> element) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/packaging/impl/elements/ManifestFileUtil", "addManifestFileToLayout"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/elements/ManifestFileUtil", "addManifestFileToLayout"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/packaging/impl/elements/ManifestFileUtil", "addManifestFileToLayout"));
        }
        context.editLayout(context.getArtifact(), new Runnable(){

            @Override
            public void run() {
                VirtualFile file = ManifestFileUtil.findManifestFile(element, (PackagingElementResolvingContext)context, context.getArtifactType());
                if (file == null || !FileUtil.pathsEqual((String)file.getPath(), (String)path)) {
                    PackagingElementFactory.getInstance().addFileCopy(element, MANIFEST_DIR_NAME, path, MANIFEST_FILE_NAME);
                }
            }
        });
    }

    @Nullable
    public static PsiClass selectMainClass(Project project, @Nullable String initialClassName) {
        TreeClassChooserFactory chooserFactory = TreeClassChooserFactory.getInstance((Project)project);
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)project);
        PsiClass aClass = initialClassName != null ? JavaPsiFacade.getInstance((Project)project).findClass(initialClassName, searchScope) : null;
        TreeClassChooser chooser = chooserFactory.createWithInnerClassesScopeChooser("Select Main Class", searchScope, (ClassFilter)new MainClassFilter(), aClass);
        chooser.showDialog();
        return chooser.getSelected();
    }

    public static void setupMainClassField(final Project project, final TextFieldWithBrowseButton field) {
        field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PsiClass selected = ManifestFileUtil.selectMainClass(project, field.getText());
                if (selected != null) {
                    field.setText(selected.getQualifiedName());
                }
            }
        });
    }

    private static class MainClassFilter
    implements ClassFilter {
        private MainClassFilter() {
        }

        public boolean isAccepted(final PsiClass aClass) {
            return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return PsiMethodUtil.MAIN_CLASS.value((Object)aClass) && PsiMethodUtil.hasMainMethod((PsiClass)aClass);
                }
            });
        }
    }
}

