/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.getters;

import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.filters.ContextGetter;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;

public class ThisGetter
implements ContextGetter {
    @Override
    public Object[] get(PsiElement context, CompletionContext completionContext) {
        return ThisGetter.getThisExpressionVariants(context).toArray();
    }

    public static List<PsiExpression> getThisExpressionVariants(PsiElement context) {
        boolean first = true;
        ArrayList<PsiExpression> expressions = new ArrayList<PsiExpression>();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
        PsiElement prev = context;
        for (context = context.getContext(); context != null; context = context.getContext()) {
            if (context instanceof PsiClass && !(prev instanceof PsiExpressionList)) {
                String expressionText;
                if (first) {
                    first = false;
                    expressionText = "this";
                } else {
                    expressionText = ((PsiClass)context).getName() + "." + "this";
                }
                try {
                    expressions.add(factory.createExpressionFromText(expressionText, context));
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
            }
            if (context instanceof PsiModifierListOwner && ((PsiModifierListOwner)context).hasModifierProperty("static")) break;
            prev = context;
        }
        return expressions;
    }
}

