/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.JavaTemplateUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.arrangement.MemberOrderService;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.source.codeStyle.ImportHelper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPsiImplementationHelperImpl
extends JavaPsiImplementationHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.JavaPsiImplementationHelperImpl");
    private final Project myProject;

    public JavaPsiImplementationHelperImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public PsiClass getOriginalClass(PsiClass psiClass) {
        PsiCompiledElement cls = (PsiCompiledElement)psiClass.getUserData(ClsElementImpl.COMPILED_ELEMENT);
        if (cls != null && cls.isValid()) {
            return (PsiClass)cls;
        }
        if (DumbService.isDumb((Project)this.myProject)) {
            return psiClass;
        }
        VirtualFile vFile = psiClass.getContainingFile().getVirtualFile();
        ProjectFileIndex idx = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        if (vFile == null || !idx.isInLibrarySource(vFile)) {
            return psiClass;
        }
        String fqn = psiClass.getQualifiedName();
        if (fqn == null) {
            return psiClass;
        }
        HashSet orderEntries = ContainerUtil.newHashSet((Iterable)idx.getOrderEntriesForFile(vFile));
        GlobalSearchScope librariesScope = LibraryScopeCache.getInstance(this.myProject).getLibrariesOnlyScope();
        for (PsiClass original : JavaPsiFacade.getInstance((Project)this.myProject).findClasses(fqn, librariesScope)) {
            VirtualFile candidateFile;
            PsiFile psiFile = original.getContainingFile();
            if (psiFile == null || (candidateFile = psiFile.getVirtualFile()) == null) continue;
            List entries = idx.getOrderEntriesForFile(candidateFile);
            for (int i = 0; i < entries.size(); ++i) {
                if (!orderEntries.contains(entries.get(i))) continue;
                return original;
            }
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiElement getClsFileNavigationElement(PsiJavaFile clsFile) {
        PsiClass[] classes = clsFile.getClasses();
        if (classes.length == 0) {
            PsiJavaFile psiJavaFile = clsFile;
            if (psiJavaFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl", "getClsFileNavigationElement"));
            }
            return psiJavaFile;
        }
        String sourceFileName = ((ClsClassImpl)classes[0]).getSourceFileName();
        String packageName = clsFile.getPackageName();
        String relativePath = packageName.isEmpty() ? sourceFileName : packageName.replace('.', '/') + '/' + sourceFileName;
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)clsFile.getProject());
        for (OrderEntry orderEntry : index.getOrderEntriesForFile(clsFile.getContainingFile().getVirtualFile())) {
            if (!(orderEntry instanceof LibraryOrSdkOrderEntry)) continue;
            for (VirtualFile root : orderEntry.getFiles(OrderRootType.SOURCES)) {
                PsiFile psiSource;
                VirtualFile source = root.findFileByRelativePath(relativePath);
                if (source == null || !source.isValid() || !((psiSource = clsFile.getManager().findFile(source)) instanceof PsiClassOwner)) continue;
                PsiFile psiFile = psiSource;
                if (psiFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl", "getClsFileNavigationElement"));
                }
                return psiFile;
            }
        }
        PsiJavaFile psiJavaFile = clsFile;
        if (psiJavaFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl", "getClsFileNavigationElement"));
        }
        return psiJavaFile;
    }

    @Override
    @NotNull
    public LanguageLevel getEffectiveLanguageLevel(@Nullable VirtualFile virtualFile) {
        LanguageLevel level;
        if (virtualFile == null) {
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel((Project)this.myProject);
            if (languageLevel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl", "getEffectiveLanguageLevel"));
            }
            return languageLevel;
        }
        VirtualFile folder = virtualFile.getParent();
        if (folder != null && (level = (LanguageLevel)folder.getUserData(LanguageLevel.KEY)) != null) {
            LanguageLevel languageLevel = level;
            if (languageLevel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl", "getEffectiveLanguageLevel"));
            }
            return languageLevel;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        Module module = index.getModuleForFile(virtualFile);
        if (module != null && index.isInSourceContent(virtualFile)) {
            LanguageLevel languageLevel = EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
            if (languageLevel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl", "getEffectiveLanguageLevel"));
            }
            return languageLevel;
        }
        LanguageLevel classesLanguageLevel = this.getClassesLanguageLevel(virtualFile);
        LanguageLevel languageLevel = classesLanguageLevel != null ? classesLanguageLevel : PsiUtil.getLanguageLevel((Project)this.myProject);
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl", "getEffectiveLanguageLevel"));
        }
        return languageLevel;
    }

    @Nullable
    private LanguageLevel getClassesLanguageLevel(VirtualFile virtualFile) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        VirtualFile sourceRoot = index.getSourceRootForFile(virtualFile);
        VirtualFile folder = virtualFile.getParent();
        if (sourceRoot != null && folder != null) {
            VirtualFile[] files;
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)folder, (VirtualFile)sourceRoot, (char)'/');
            if (relativePath == null) {
                throw new AssertionError((Object)("Null relative path: folder=" + folder + "; root=" + sourceRoot));
            }
            List orderEntries = index.getOrderEntriesForFile(virtualFile);
            if (orderEntries.isEmpty()) {
                LOG.error("Inconsistent: " + DirectoryIndex.getInstance(this.myProject).getInfoForFile(folder).toString());
            }
            String className = virtualFile.getNameWithoutExtension();
            for (VirtualFile rootFile : files = ((OrderEntry)orderEntries.get(0)).getFiles(OrderRootType.CLASSES)) {
                PsiJavaFile javaFile;
                VirtualFile classFile = rootFile.findFileByRelativePath(relativePath);
                if (classFile == null || (javaFile = this.getPsiFileInRoot(classFile, className)) == null) continue;
                return javaFile.getLanguageLevel();
            }
            return LanguageLevelProjectExtension.getInstance((Project)this.myProject).getLanguageLevel();
        }
        return null;
    }

    @Nullable
    private PsiJavaFile getPsiFileInRoot(VirtualFile dirFile, @Nullable String className) {
        VirtualFile[] children;
        PsiFile psiFile;
        VirtualFile classFile;
        if (className != null && (classFile = dirFile.findChild(StringUtil.getQualifiedName((String)className, (String)StdFileTypes.CLASS.getDefaultExtension()))) != null && (psiFile = PsiManager.getInstance((Project)this.myProject).findFile(classFile)) instanceof PsiJavaFile) {
            return (PsiJavaFile)psiFile;
        }
        for (VirtualFile child : children = dirFile.getChildren()) {
            PsiFile psiFile2;
            if (!StdFileTypes.CLASS.equals(child.getFileType()) || !((psiFile2 = PsiManager.getInstance((Project)this.myProject).findFile(child)) instanceof PsiJavaFile)) continue;
            return (PsiJavaFile)psiFile2;
        }
        return null;
    }

    @Override
    public ASTNode getDefaultImportAnchor(PsiImportList list, PsiImportStatementBase statement) {
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)list.getProject());
        ImportHelper importHelper = new ImportHelper(settings);
        return importHelper.getDefaultAnchor(list, statement);
    }

    @Override
    @Nullable
    public PsiElement getDefaultMemberAnchor(@NotNull PsiClass aClass, @NotNull PsiMember member) {
        PsiElement lBrace;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl", "getDefaultMemberAnchor"));
        }
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl", "getDefaultMemberAnchor"));
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)aClass.getProject());
        MemberOrderService service2 = (MemberOrderService)ServiceManager.getService(MemberOrderService.class);
        PsiElement anchor = service2.getAnchor((PsiElement)member, settings.getCommonSettings((Language)JavaLanguage.INSTANCE), (PsiElement)aClass);
        PsiElement newAnchor = JavaPsiImplementationHelperImpl.skipWhitespaces(aClass, anchor);
        if (newAnchor != null) {
            return newAnchor;
        }
        if (anchor != null && anchor != aClass) {
            anchor = anchor.getNextSibling();
            while (anchor instanceof PsiJavaToken && (anchor.getText().equals(",") || anchor.getText().equals(";"))) {
                boolean afterComma = anchor.getText().equals(",");
                anchor = anchor.getNextSibling();
                if (!afterComma || (newAnchor = JavaPsiImplementationHelperImpl.skipWhitespaces(aClass, anchor)) == null) continue;
                return newAnchor;
            }
            if (anchor != null) {
                return anchor;
            }
        }
        if ((lBrace = aClass.getLBrace()) != null) {
            PsiElement result = lBrace.getNextSibling();
            while (result instanceof PsiWhiteSpace) {
                result = result.getNextSibling();
            }
            return result;
        }
        return aClass.getRBrace();
    }

    private static PsiElement skipWhitespaces(PsiClass aClass, PsiElement anchor) {
        if (anchor != null && PsiTreeUtil.skipSiblingsForward((PsiElement)anchor, (Class[])new Class[]{PsiWhiteSpace.class}) == aClass.getRBrace()) {
            return aClass.getRBrace();
        }
        return null;
    }

    @Override
    public void setupCatchBlock(@NotNull String exceptionName, @NotNull PsiType exceptionType, PsiElement context, @NotNull PsiCatchSection catchSection) {
        PsiCodeBlock codeBlockFromText;
        PsiDirectory directory;
        if (exceptionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionName", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl", "setupCatchBlock"));
        }
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionType", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl", "setupCatchBlock"));
        }
        if (catchSection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "catchSection", "com/intellij/psi/impl/JavaPsiImplementationHelperImpl", "setupCatchBlock"));
        }
        FileTemplate catchBodyTemplate = FileTemplateManager.getInstance(catchSection.getProject()).getCodeTemplate("Catch Statement Body.java");
        LOG.assertTrue(catchBodyTemplate != null);
        Properties props = FileTemplateManager.getInstance(this.myProject).getDefaultProperties();
        props.setProperty("EXCEPTION", exceptionName);
        props.setProperty("EXCEPTION_TYPE", exceptionType.getCanonicalText());
        if (context != null && context.isPhysical() && (directory = context.getContainingFile().getContainingDirectory()) != null) {
            JavaTemplateUtil.setPackageNameAttribute(props, directory);
        }
        try {
            codeBlockFromText = PsiElementFactory.SERVICE.getInstance((Project)this.myProject).createCodeBlockFromText("{\n" + catchBodyTemplate.getText(props) + "\n}", null);
        }
        catch (ProcessCanceledException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new IncorrectOperationException("Incorrect file template", (Throwable)e);
        }
        catchSection.getCatchBlock().replace((PsiElement)codeBlockFromText);
    }
}

