/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceparameterobject;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.introduceparameterobject.IntroduceParameterObjectUsageViewDescriptor;
import com.intellij.refactoring.introduceparameterobject.ParameterObjectBuilder;
import com.intellij.refactoring.introduceparameterobject.usageInfo.AppendAccessorsUsageInfo;
import com.intellij.refactoring.introduceparameterobject.usageInfo.BeanClassVisibilityUsageInfo;
import com.intellij.refactoring.introduceparameterobject.usageInfo.MergeMethodArguments;
import com.intellij.refactoring.introduceparameterobject.usageInfo.ReplaceParameterAssignmentWithCall;
import com.intellij.refactoring.introduceparameterobject.usageInfo.ReplaceParameterIncrementDecrement;
import com.intellij.refactoring.introduceparameterobject.usageInfo.ReplaceParameterReferenceWithCall;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.refactoring.util.FixableUsagesRefactoringProcessor;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntroduceParameterObjectProcessor
extends FixableUsagesRefactoringProcessor {
    private static final Logger logger = Logger.getInstance((String)"com.siyeh.rpp.introduceparameterobject.IntroduceParameterObjectProcessor");
    private final MoveDestination myMoveDestination;
    private final PsiMethod method;
    private final String className;
    private final String packageName;
    private final boolean keepMethodAsDelegate;
    private final boolean myUseExistingClass;
    private final boolean myCreateInnerClass;
    private final String myNewVisibility;
    private final boolean myGenerateAccessors;
    private final List<ParameterChunk> parameters;
    private final int[] paramsToMerge;
    private final List<PsiTypeParameter> typeParams;
    private final Set<PsiParameter> paramsNeedingSetters = new HashSet<PsiParameter>();
    private final Set<PsiParameter> paramsNeedingGetters = new HashSet<PsiParameter>();
    private final PsiClass existingClass;
    private PsiMethod myExistingClassCompatibleConstructor;

    public IntroduceParameterObjectProcessor(String className, String packageName, MoveDestination moveDestination, PsiMethod method, VariableData[] parameters, boolean keepMethodAsDelegate, boolean useExistingClass, boolean createInnerClass, String newVisibility, boolean generateAccessors) {
        super(method.getProject());
        this.myMoveDestination = moveDestination;
        this.method = method;
        this.className = className;
        this.packageName = packageName;
        this.keepMethodAsDelegate = keepMethodAsDelegate;
        this.myUseExistingClass = useExistingClass;
        this.myCreateInnerClass = createInnerClass;
        this.myNewVisibility = newVisibility;
        this.myGenerateAccessors = generateAccessors;
        this.parameters = new ArrayList<ParameterChunk>();
        for (VariableData parameter : parameters) {
            this.parameters.add(new ParameterChunk(parameter));
        }
        PsiParameterList parameterList = method.getParameterList();
        PsiParameter[] methodParams = parameterList.getParameters();
        this.paramsToMerge = new int[parameters.length];
        block1: for (int p = 0; p < parameters.length; ++p) {
            VariableData parameter;
            parameter = parameters[p];
            for (int i = 0; i < methodParams.length; ++i) {
                PsiParameter methodParam = methodParams[i];
                if (!parameter.variable.equals(methodParam)) continue;
                this.paramsToMerge[p] = i;
                continue block1;
            }
        }
        final HashSet typeParamSet = new HashSet();
        PsiTypeVisitor<Object> typeParametersVisitor = new PsiTypeVisitor<Object>(){

            public Object visitClassType(PsiClassType classType) {
                PsiClass referent = classType.resolve();
                if (referent instanceof PsiTypeParameter) {
                    typeParamSet.add((PsiTypeParameter)referent);
                }
                return super.visitClassType(classType);
            }
        };
        for (VariableData parameter : parameters) {
            parameter.type.accept((PsiTypeVisitor)typeParametersVisitor);
        }
        this.typeParams = new ArrayList<PsiTypeParameter>(typeParamSet);
        String qualifiedName = StringUtil.getQualifiedName((String)packageName, (String)className);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        this.existingClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(qualifiedName, scope);
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/intellij/refactoring/introduceparameterobject/IntroduceParameterObjectProcessor", "createUsageViewDescriptor"));
        }
        IntroduceParameterObjectUsageViewDescriptor introduceParameterObjectUsageViewDescriptor = new IntroduceParameterObjectUsageViewDescriptor(this.method);
        if (introduceParameterObjectUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduceparameterobject/IntroduceParameterObjectProcessor", "createUsageViewDescriptor"));
        }
        return introduceParameterObjectUsageViewDescriptor;
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/refactoring/introduceparameterobject/IntroduceParameterObjectProcessor", "preprocessUsages"));
        }
        MultiMap conflicts = new MultiMap();
        if (this.myUseExistingClass) {
            if (this.existingClass == null) {
                conflicts.putValue(null, (Object)(RefactorJBundle.message("cannot.perform.the.refactoring", new Object[0]) + "Could not find the selected class"));
            }
            if (this.myExistingClassCompatibleConstructor == null) {
                conflicts.putValue((Object)this.existingClass, (Object)(RefactorJBundle.message("cannot.perform.the.refactoring", new Object[0]) + "Selected class has no compatible constructors"));
            }
        } else {
            if (this.existingClass != null) {
                conflicts.putValue((Object)this.existingClass, (Object)(RefactorJBundle.message("cannot.perform.the.refactoring", new Object[0]) + RefactorJBundle.message("there.already.exists.a.class.with.the.chosen.name", new Object[0])));
            }
            if (this.myMoveDestination != null && !this.myMoveDestination.isTargetAccessible(this.myProject, this.method.getContainingFile().getVirtualFile())) {
                conflicts.putValue((Object)this.method, (Object)"Created class won't be accessible");
            }
        }
        for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
            String conflictMessage;
            if (!(usageInfo instanceof FixableUsageInfo) || (conflictMessage = ((FixableUsageInfo)usageInfo).getConflictMessage()) == null) continue;
            conflicts.putValue((Object)usageInfo.getElement(), (Object)conflictMessage);
        }
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts, (UsageInfo[])refUsages.get());
    }

    @Override
    public void findUsages(@NotNull List<FixableUsageInfo> usages) {
        PsiMethod[] overridingMethods;
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/introduceparameterobject/IntroduceParameterObjectProcessor", "findUsages"));
        }
        if (this.myUseExistingClass && this.existingClass != null) {
            this.myExistingClassCompatibleConstructor = IntroduceParameterObjectProcessor.existingClassIsCompatible(this.existingClass, this.parameters);
        }
        this.findUsagesForMethod(this.method, usages, true);
        if (!(!this.myUseExistingClass || this.existingClass == null || this.paramsNeedingGetters.isEmpty() && this.paramsNeedingSetters.isEmpty())) {
            usages.add(new AppendAccessorsUsageInfo((PsiElement)this.existingClass, this.myGenerateAccessors, this.paramsNeedingGetters, this.paramsNeedingSetters, this.parameters));
        }
        for (PsiMethod siblingMethod : overridingMethods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)this.method, (boolean)true).toArray((Object[])PsiMethod.EMPTY_ARRAY)) {
            this.findUsagesForMethod(siblingMethod, usages, false);
        }
        if (this.myNewVisibility != null) {
            usages.add(new BeanClassVisibilityUsageInfo(this.existingClass, usages.toArray(new UsageInfo[usages.size()]), this.myNewVisibility, this.myExistingClassCompatibleConstructor));
        }
    }

    private void findUsagesForMethod(PsiMethod overridingMethod, List<FixableUsageInfo> usages, boolean changeSignature) {
        PsiCodeBlock body = overridingMethod.getBody();
        String baseParameterName = StringUtil.decapitalize((String)this.className);
        String fixedParamName = body != null ? JavaCodeStyleManager.getInstance((Project)this.myProject).suggestUniqueVariableName(baseParameterName, (PsiElement)body.getLBrace(), true) : JavaCodeStyleManager.getInstance((Project)this.myProject).propertyNameToVariableName(baseParameterName, VariableKind.PARAMETER);
        usages.add(new MergeMethodArguments(overridingMethod, this.className, this.packageName, fixedParamName, this.paramsToMerge, this.typeParams, this.keepMethodAsDelegate, this.myCreateInnerClass ? this.method.getContainingClass() : null, changeSignature));
        ParamUsageVisitor visitor = new ParamUsageVisitor(overridingMethod, this.paramsToMerge);
        overridingMethod.accept((PsiElementVisitor)visitor);
        Set<PsiReferenceExpression> values = visitor.getParameterUsages();
        for (PsiReferenceExpression paramUsage : values) {
            String setter;
            PsiType paramType;
            PsiParameter parameter = (PsiParameter)paramUsage.resolve();
            assert (parameter != null);
            PsiMethod containingMethod = (PsiMethod)parameter.getDeclarationScope();
            int index = containingMethod.getParameterList().getParameterIndex(parameter);
            PsiParameter replacedParameter = this.method.getParameterList().getParameters()[index];
            ParameterChunk parameterChunk = ParameterChunk.getChunkByParameter(parameter, this.parameters);
            String getter = parameterChunk != null ? parameterChunk.getter : null;
            String paramName = parameterChunk != null ? ((ParameterChunk)parameterChunk).parameter.name : replacedParameter.getName();
            PsiType psiType = paramType = parameterChunk != null ? ((ParameterChunk)parameterChunk).parameter.type : replacedParameter.getType();
            if (getter == null) {
                getter = GenerateMembersUtil.suggestGetterName(paramName, paramType, this.myProject);
                this.paramsNeedingGetters.add(replacedParameter);
            }
            String string = setter = parameterChunk != null ? parameterChunk.setter : null;
            if (setter == null) {
                setter = GenerateMembersUtil.suggestSetterName(paramName, paramType, this.myProject);
            }
            if (RefactoringUtil.isPlusPlusOrMinusMinus(paramUsage.getParent())) {
                usages.add(new ReplaceParameterIncrementDecrement((PsiExpression)paramUsage, fixedParamName, setter, getter));
                if (parameterChunk != null && parameterChunk.setter != null) continue;
                this.paramsNeedingSetters.add(replacedParameter);
                continue;
            }
            if (RefactoringUtil.isAssignmentLHS((PsiElement)paramUsage)) {
                usages.add(new ReplaceParameterAssignmentWithCall(paramUsage, fixedParamName, setter, getter));
                if (parameterChunk != null && parameterChunk.setter != null) continue;
                this.paramsNeedingSetters.add(replacedParameter);
                continue;
            }
            usages.add(new ReplaceParameterReferenceWithCall(paramUsage, fixedParamName, getter));
        }
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/intellij/refactoring/introduceparameterobject/IntroduceParameterObjectProcessor", "performRefactoring"));
        }
        PsiClass psiClass = this.buildClass();
        if (psiClass != null) {
            this.fixJavadocForConstructor(psiClass);
            super.performRefactoring(usageInfos);
            if (!this.myUseExistingClass) {
                for (PsiReference reference : ReferencesSearch.search((PsiElement)this.method)) {
                    PsiElement place = reference.getElement();
                    VisibilityUtil.escalateVisibility((PsiMember)psiClass, (PsiElement)place);
                    for (PsiMethod constructor : psiClass.getConstructors()) {
                        VisibilityUtil.escalateVisibility((PsiMember)constructor, (PsiElement)place);
                    }
                }
            }
        }
    }

    private PsiClass buildClass() {
        if (this.existingClass != null) {
            return this.existingClass;
        }
        ParameterObjectBuilder beanClassBuilder = new ParameterObjectBuilder();
        beanClassBuilder.setVisibility(this.myCreateInnerClass ? "private" : "public");
        beanClassBuilder.setProject(this.myProject);
        beanClassBuilder.setTypeArguments(this.typeParams);
        beanClassBuilder.setClassName(this.className);
        beanClassBuilder.setPackageName(this.packageName);
        for (ParameterChunk parameterChunk : this.parameters) {
            VariableData parameter = parameterChunk.parameter;
            boolean setterRequired = this.paramsNeedingSetters.contains(parameter.variable);
            beanClassBuilder.addField((PsiParameter)parameter.variable, parameter.name, parameter.type, setterRequired);
        }
        String classString = beanClassBuilder.buildBeanClass();
        try {
            PsiDirectory directory;
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)this.method.getProject());
            PsiJavaFile newFile = (PsiJavaFile)factory.createFileFromText(this.className + ".java", (FileType)JavaFileType.INSTANCE, (CharSequence)classString);
            if (this.myCreateInnerClass) {
                PsiClass containingClass = this.method.getContainingClass();
                PsiClass[] classes = newFile.getClasses();
                assert (classes.length > 0) : classString;
                PsiClass innerClass = (PsiClass)containingClass.add((PsiElement)classes[0]);
                PsiUtil.setModifierProperty((PsiModifierListOwner)innerClass, (String)"static", (boolean)true);
                return (PsiClass)JavaCodeStyleManager.getInstance((Project)newFile.getProject()).shortenClassReferences((PsiElement)innerClass);
            }
            PsiFile containingFile = this.method.getContainingFile();
            PsiDirectory containingDirectory = containingFile.getContainingDirectory();
            if (this.myMoveDestination != null) {
                directory = this.myMoveDestination.getTargetDirectory(containingDirectory);
            } else {
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)containingFile);
                directory = PackageUtil.findOrCreateDirectoryForPackage(module, this.packageName, containingDirectory, true, true);
            }
            if (directory != null) {
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.method.getManager().getProject());
                PsiElement shortenedFile = JavaCodeStyleManager.getInstance((Project)newFile.getProject()).shortenClassReferences((PsiElement)newFile);
                PsiElement reformattedFile = codeStyleManager.reformat(shortenedFile);
                return ((PsiJavaFile)directory.add(reformattedFile)).getClasses()[0];
            }
        }
        catch (IncorrectOperationException e) {
            logger.info((Throwable)e);
        }
        return null;
    }

    private void fixJavadocForConstructor(PsiClass psiClass) {
        PsiDocComment docComment = this.method.getDocComment();
        if (docComment != null) {
            PsiDocTag[] paramTags;
            ArrayList<PsiDocTag> mergedTags = new ArrayList<PsiDocTag>();
            for (PsiDocTag paramTag : paramTags = docComment.findTagsByName("param")) {
                int parameterIndex;
                PsiElement resolve;
                PsiReference reference;
                PsiElement[] dataElements = paramTag.getDataElements();
                if (dataElements.length <= 0 || dataElements[0] instanceof PsiDocParamRef && (reference = dataElements[0].getReference()) != null && (resolve = reference.resolve()) instanceof PsiParameter && ArrayUtil.find((int[])this.paramsToMerge, (int)(parameterIndex = this.method.getParameterList().getParameterIndex((PsiParameter)resolve))) < 0) continue;
                mergedTags.add((PsiDocTag)paramTag.copy());
            }
            PsiMethod compatibleParamObjectConstructor = null;
            if (this.myExistingClassCompatibleConstructor != null && this.myExistingClassCompatibleConstructor.getDocComment() == null) {
                compatibleParamObjectConstructor = this.myExistingClassCompatibleConstructor;
            } else if (!this.myUseExistingClass) {
                compatibleParamObjectConstructor = psiClass.getConstructors()[0];
            }
            if (compatibleParamObjectConstructor != null) {
                PsiDocComment psiDocComment = JavaPsiFacade.getElementFactory((Project)this.myProject).createDocCommentFromText("/**\n*/");
                psiDocComment = (PsiDocComment)compatibleParamObjectConstructor.addBefore((PsiElement)psiDocComment, compatibleParamObjectConstructor.getFirstChild());
                for (PsiDocTag tag : mergedTags) {
                    psiDocComment.add((PsiElement)tag);
                }
            }
        }
    }

    @Override
    protected String getCommandName() {
        PsiClass containingClass = this.method.getContainingClass();
        return RefactorJBundle.message("introduced.parameter.class.command.name", this.className, containingClass.getName(), this.method.getName());
    }

    @Nullable
    private static PsiMethod existingClassIsCompatible(PsiClass aClass, List<ParameterChunk> params) {
        if (params.size() == 1) {
            ParameterChunk parameterChunk = params.get(0);
            PsiType paramType = ((ParameterChunk)parameterChunk).parameter.type;
            if (TypeConversionUtil.isPrimitiveWrapper((String)aClass.getQualifiedName())) {
                parameterChunk.setField(aClass.findFieldByName("value", false));
                parameterChunk.setGetter(paramType.getCanonicalText() + "Value");
                for (PsiMethod constructor : aClass.getConstructors()) {
                    if (!IntroduceParameterObjectProcessor.constructorIsCompatible(constructor, params)) continue;
                    return constructor;
                }
            }
        }
        PsiMethod[] constructors = aClass.getConstructors();
        PsiMethod compatibleConstructor = null;
        for (PsiMethod constructor : constructors) {
            if (!IntroduceParameterObjectProcessor.constructorIsCompatible(constructor, params)) continue;
            compatibleConstructor = constructor;
            break;
        }
        if (compatibleConstructor == null) {
            return null;
        }
        PsiParameterList parameterList = compatibleConstructor.getParameterList();
        PsiParameter[] constructorParams = parameterList.getParameters();
        for (int i = 0; i < constructorParams.length; ++i) {
            PsiMethod setterForField;
            PsiParameter param = constructorParams[i];
            ParameterChunk parameterChunk = params.get(i);
            PsiField field = IntroduceParameterObjectProcessor.findFieldAssigned(param, compatibleConstructor);
            if (field == null) {
                return null;
            }
            parameterChunk.setField(field);
            PsiMethod getterForField = PropertyUtil.findGetterForField((PsiField)field);
            if (getterForField != null) {
                parameterChunk.setGetter(getterForField.getName());
            }
            if ((setterForField = PropertyUtil.findSetterForField((PsiField)field)) == null) continue;
            parameterChunk.setSetter(setterForField.getName());
        }
        return compatibleConstructor;
    }

    private static boolean constructorIsCompatible(PsiMethod constructor, List<ParameterChunk> params) {
        PsiParameterList parameterList = constructor.getParameterList();
        PsiParameter[] constructorParams = parameterList.getParameters();
        if (constructorParams.length != params.size()) {
            return false;
        }
        for (int i = 0; i < constructorParams.length; ++i) {
            if (TypeConversionUtil.isAssignable((PsiType)constructorParams[i].getType(), (PsiType)((ParameterChunk)params.get((int)i)).parameter.type)) continue;
            return false;
        }
        return true;
    }

    private static PsiField findFieldAssigned(PsiParameter param, PsiMethod constructor) {
        ParamAssignmentFinder visitor = new ParamAssignmentFinder(param);
        constructor.accept((PsiElementVisitor)visitor);
        return visitor.getFieldAssigned();
    }

    private static class ParamAssignmentFinder
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiParameter param;
        private PsiField fieldAssigned = null;

        ParamAssignmentFinder(PsiParameter param) {
            this.param = param;
        }

        public void visitAssignmentExpression(PsiAssignmentExpression assignment) {
            super.visitAssignmentExpression(assignment);
            PsiExpression lhs = assignment.getLExpression();
            PsiExpression rhs = assignment.getRExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            if (!(rhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)rhs).resolve();
            if (referent == null || !referent.equals(this.param)) {
                return;
            }
            PsiElement assigned = ((PsiReference)lhs).resolve();
            if (assigned == null || !(assigned instanceof PsiField)) {
                return;
            }
            this.fieldAssigned = (PsiField)assigned;
        }

        public PsiField getFieldAssigned() {
            return this.fieldAssigned;
        }
    }

    public static class ParameterChunk {
        private final VariableData parameter;
        private PsiField field;
        private String getter;
        private String setter;

        public ParameterChunk(VariableData parameter) {
            this.parameter = parameter;
        }

        public void setField(PsiField field) {
            this.field = field;
        }

        public void setGetter(String getter) {
            this.getter = getter;
        }

        public void setSetter(String setter) {
            this.setter = setter;
        }

        @Nullable
        public PsiField getField() {
            return this.field;
        }

        @Nullable
        public static ParameterChunk getChunkByParameter(PsiParameter param, List<ParameterChunk> params) {
            for (ParameterChunk chunk : params) {
                if (!chunk.parameter.variable.equals(param)) continue;
                return chunk;
            }
            return null;
        }
    }

    private static class ParamUsageVisitor
    extends JavaRecursiveElementVisitor {
        private final Set<PsiParameter> paramsToMerge = new HashSet<PsiParameter>();
        private final Set<PsiReferenceExpression> parameterUsages = new HashSet<PsiReferenceExpression>(4);

        ParamUsageVisitor(PsiMethod method, int[] paramIndicesToMerge) {
            PsiParameterList paramList = method.getParameterList();
            PsiParameter[] parameters = paramList.getParameters();
            for (int i : paramIndicesToMerge) {
                this.paramsToMerge.add(parameters[i]);
            }
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            super.visitReferenceExpression(expression);
            PsiElement referent = expression.resolve();
            if (!(referent instanceof PsiParameter)) {
                return;
            }
            PsiParameter parameter = (PsiParameter)referent;
            if (this.paramsToMerge.contains(parameter)) {
                this.parameterUsages.add(expression);
            }
        }

        public Set<PsiReferenceExpression> getParameterUsages() {
            return this.parameterUsages;
        }
    }
}

