/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPullUp;

import com.intellij.analysis.AnalysisScope;
import com.intellij.lang.Language;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.listeners.JavaRefactoringListenerManager;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.impl.JavaRefactoringListenerManagerImpl;
import com.intellij.refactoring.memberPullUp.PullUpData;
import com.intellij.refactoring.memberPullUp.PullUpHelper;
import com.intellij.refactoring.memberPullUp.PullUpHelperFactory;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.duplicates.MethodDuplicatesHandler;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PullUpProcessor
extends BaseRefactoringProcessor
implements PullUpData {
    private static final Logger LOG = Logger.getInstance(PullUpProcessor.class);
    private final PsiClass mySourceClass;
    private final PsiClass myTargetSuperClass;
    private final MemberInfo[] myMembersToMove;
    private final DocCommentPolicy myJavaDocPolicy;
    private Set<PsiMember> myMembersAfterMove = null;
    private Set<PsiMember> myMovedMembers = null;
    private final Map<Language, PullUpHelper<MemberInfo>> myProcessors = ContainerUtil.newHashMap();

    public PullUpProcessor(PsiClass sourceClass, PsiClass targetSuperClass, MemberInfo[] membersToMove, DocCommentPolicy javaDocPolicy) {
        super(sourceClass.getProject());
        this.mySourceClass = sourceClass;
        this.myTargetSuperClass = targetSuperClass;
        this.myMembersToMove = membersToMove;
        this.myJavaDocPolicy = javaDocPolicy;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/memberPullUp/PullUpProcessor", "createUsageViewDescriptor"));
        }
        PullUpUsageViewDescriptor pullUpUsageViewDescriptor = new PullUpUsageViewDescriptor();
        if (pullUpUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/memberPullUp/PullUpProcessor", "createUsageViewDescriptor"));
        }
        return pullUpUsageViewDescriptor;
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (MemberInfo memberInfo : this.myMembersToMove) {
            PsiMember member = (PsiMember)memberInfo.getMember();
            if (!member.hasModifierProperty("static")) continue;
            for (PsiReference reference : ReferencesSearch.search((PsiElement)member)) {
                result.add(new UsageInfo(reference));
            }
        }
        UsageInfo[] usageInfoArray = result.isEmpty() ? UsageInfo.EMPTY_ARRAY : result.toArray(new UsageInfo[result.size()]);
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/memberPullUp/PullUpProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.pull.up";
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data2 = new RefactoringEventData();
        data2.addElement((PsiElement)this.mySourceClass);
        data2.addMembers((Object[])this.myMembersToMove, (Function)new Function<MemberInfo, PsiElement>(){

            public PsiElement fun(MemberInfo info) {
                return info.getMember();
            }
        });
        return data2;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/memberPullUp/PullUpProcessor", "getAfterData"));
        }
        RefactoringEventData data2 = new RefactoringEventData();
        data2.addElement((PsiElement)this.myTargetSuperClass);
        return data2;
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/memberPullUp/PullUpProcessor", "performRefactoring"));
        }
        this.moveMembersToBase();
        this.moveFieldInitializations();
        for (UsageInfo usage : usages) {
            PsiElement element = usage.getElement();
            if (element == null) continue;
            PullUpHelper<MemberInfo> processor = this.getProcessor(element);
            processor.updateUsage(element);
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                PullUpProcessor.this.processMethodsDuplicates();
            }
        }, ModalityState.NON_MODAL, this.myProject.getDisposed());
    }

    private void processMethodsDuplicates() {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (!PullUpProcessor.this.myTargetSuperClass.isValid()) {
                            return;
                        }
                        Query search = ClassInheritorsSearch.search((PsiClass)PullUpProcessor.this.myTargetSuperClass);
                        HashSet<VirtualFile> hierarchyFiles = new HashSet<VirtualFile>();
                        for (PsiClass aClass : search) {
                            VirtualFile virtualFile;
                            PsiFile containingFile = aClass.getContainingFile();
                            if (containingFile == null || (virtualFile = containingFile.getVirtualFile()) == null) continue;
                            hierarchyFiles.add(virtualFile);
                        }
                        HashSet<PsiMember> methodsToSearchDuplicates = new HashSet<PsiMember>();
                        for (PsiMember psiMember : PullUpProcessor.this.myMembersAfterMove) {
                            if (!(psiMember instanceof PsiMethod) || !psiMember.isValid() || ((PsiMethod)psiMember).getBody() == null) continue;
                            methodsToSearchDuplicates.add(psiMember);
                        }
                        MethodDuplicatesHandler.invokeOnScope(PullUpProcessor.this.myProject, methodsToSearchDuplicates, new AnalysisScope(PullUpProcessor.this.myProject, hierarchyFiles), true);
                    }
                });
            }
        }, MethodDuplicatesHandler.REFACTORING_NAME, true, this.myProject);
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"pullUp.command", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.mySourceClass)});
    }

    public void moveMembersToBase() throws IncorrectOperationException {
        this.myMovedMembers = ContainerUtil.newHashSet();
        this.myMembersAfterMove = ContainerUtil.newHashSet();
        for (MemberInfo info : this.myMembersToMove) {
            this.myMovedMembers.add((PsiMember)info.getMember());
        }
        PsiSubstitutor substitutor = this.upDownSuperClassSubstitutor();
        for (MemberInfo info : this.myMembersToMove) {
            PullUpHelper<MemberInfo> processor = this.getProcessor(info);
            if (!(info.getMember() instanceof PsiClass) || info.getOverrides() == null) {
                processor.setCorrectVisibility((MemberInfoBase)info);
                processor.encodeContextInfo((MemberInfoBase)info);
            }
            processor.move((MemberInfoBase)info, substitutor);
        }
        for (PsiMember member : this.myMembersAfterMove) {
            this.getProcessor((PsiElement)member).postProcessMember(member);
            JavaRefactoringListenerManager listenerManager = JavaRefactoringListenerManager.getInstance((Project)this.myProject);
            ((JavaRefactoringListenerManagerImpl)listenerManager).fireMemberMoved(this.mySourceClass, member);
        }
    }

    private PullUpHelper<MemberInfo> getProcessor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/memberPullUp/PullUpProcessor", "getProcessor"));
        }
        Language language = element.getLanguage();
        return this.getProcessor(language);
    }

    private PullUpHelper<MemberInfo> getProcessor(Language language) {
        PullUpHelper helper = this.myProcessors.get(language);
        if (helper == null) {
            helper = ((PullUpHelperFactory)PullUpHelper.INSTANCE.forLanguage(language)).createPullUpHelper((PullUpData)this);
            this.myProcessors.put(language, (PullUpHelper<MemberInfo>)helper);
        }
        return helper;
    }

    private PullUpHelper<MemberInfo> getProcessor(@NotNull MemberInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/refactoring/memberPullUp/PullUpProcessor", "getProcessor"));
        }
        PsiReferenceList refList = info.getSourceReferenceList();
        if (refList != null) {
            return this.getProcessor(refList.getLanguage());
        }
        return this.getProcessor(info.getMember());
    }

    private PsiSubstitutor upDownSuperClassSubstitutor() {
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)this.mySourceClass)) {
            substitutor = substitutor.put(parameter, null);
        }
        Map substitutionMap = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)this.myTargetSuperClass, (PsiClass)this.mySourceClass, (PsiSubstitutor)PsiSubstitutor.EMPTY).getSubstitutionMap();
        for (PsiTypeParameter parameter : substitutionMap.keySet()) {
            PsiType type = (PsiType)substitutionMap.get(parameter);
            PsiClass resolvedClass = PsiUtil.resolveClassInType((PsiType)type);
            if (!(resolvedClass instanceof PsiTypeParameter)) continue;
            substitutor = substitutor.put((PsiTypeParameter)resolvedClass, (PsiType)JavaPsiFacade.getElementFactory((Project)this.myProject).createType((PsiClass)parameter));
        }
        return substitutor;
    }

    public void moveFieldInitializations() throws IncorrectOperationException {
        LOG.assertTrue(this.myMembersAfterMove != null);
        LinkedHashSet<PsiField> movedFields = new LinkedHashSet<PsiField>();
        for (PsiMember member : this.myMembersAfterMove) {
            if (!(member instanceof PsiField)) continue;
            movedFields.add((PsiField)member);
        }
        if (movedFields.isEmpty()) {
            return;
        }
        this.getProcessor((PsiElement)this.myTargetSuperClass).moveFieldInitializations(movedFields);
    }

    public static boolean checkedInterfacesContain(Collection<? extends MemberInfoBase<? extends PsiMember>> memberInfos, PsiMethod psiMethod) {
        for (MemberInfoBase<? extends PsiMember> memberInfoBase : memberInfos) {
            if (!memberInfoBase.isChecked() || !(memberInfoBase.getMember() instanceof PsiClass) || !Boolean.FALSE.equals(memberInfoBase.getOverrides()) || ((PsiClass)memberInfoBase.getMember()).findMethodBySignature(psiMethod, true) == null) continue;
            return true;
        }
        return false;
    }

    public PsiClass getSourceClass() {
        return this.mySourceClass;
    }

    public PsiClass getTargetClass() {
        return this.myTargetSuperClass;
    }

    public DocCommentPolicy getDocCommentPolicy() {
        return this.myJavaDocPolicy;
    }

    public Set<PsiMember> getMembersToMove() {
        return this.myMovedMembers;
    }

    public Set<PsiMember> getMovedMembers() {
        return this.myMembersAfterMove;
    }

    public Project getProject() {
        return this.myProject;
    }

    private class PullUpUsageViewDescriptor
    implements UsageViewDescriptor {
        private PullUpUsageViewDescriptor() {
        }

        public String getProcessedElementsHeader() {
            return "Pull up members from";
        }

        @NotNull
        public PsiElement[] getElements() {
            PsiElement[] psiElementArray = new PsiElement[]{PullUpProcessor.this.mySourceClass};
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/memberPullUp/PullUpProcessor$PullUpUsageViewDescriptor", "getElements"));
            }
            return psiElementArray;
        }

        public String getCodeReferencesText(int usagesCount, int filesCount) {
            return "Class to pull up members to \"" + RefactoringUIUtil.getDescription((PsiElement)PullUpProcessor.this.myTargetSuperClass, true) + "\"";
        }

        public String getCommentReferencesText(int usagesCount, int filesCount) {
            return null;
        }
    }
}

