/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CanonicalTypes {
    private CanonicalTypes() {
    }

    public static Type createTypeWrapper(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/refactoring/util/CanonicalTypes", "createTypeWrapper"));
        }
        return (Type)type.accept((PsiTypeVisitor)Creator.INSTANCE);
    }

    private static class Creator
    extends PsiTypeVisitor<Type> {
        public static final Creator INSTANCE = new Creator();

        private Creator() {
        }

        public Type visitPrimitiveType(PsiPrimitiveType type) {
            return new Primitive(type);
        }

        public Type visitEllipsisType(PsiEllipsisType type) {
            return new Ellipsis((PsiType)type, (Type)type.getComponentType().accept((PsiTypeVisitor)this));
        }

        public Type visitArrayType(PsiArrayType type) {
            return new Array((PsiType)type, (Type)type.getComponentType().accept((PsiTypeVisitor)this));
        }

        public Type visitWildcardType(PsiWildcardType type) {
            PsiType bound = type.getBound();
            return new WildcardType((PsiType)type, type.isExtends(), bound == null ? null : (Type)bound.accept((PsiTypeVisitor)this));
        }

        public Type visitClassType(PsiClassType type) {
            PsiClassType.ClassResolveResult resolveResult = type.resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            if (aClass instanceof PsiAnonymousClass) {
                return this.visitClassType(((PsiAnonymousClass)aClass).getBaseClassType());
            }
            if (aClass == null) {
                return new UnresolvedType((PsiType)type);
            }
            HashMap substitutionMap = ContainerUtil.newHashMap();
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass)) {
                PsiType substitute = substitutor.substitute(typeParameter);
                substitutionMap.put(typeParameter.getName(), substitute != null ? (Type)substitute.accept((PsiTypeVisitor)this) : null);
            }
            String qualifiedName = (String)ObjectUtils.notNull((Object)aClass.getQualifiedName(), (Object)aClass.getName());
            return new ClassType((PsiType)type, qualifiedName, substitutionMap);
        }

        public Type visitDisjunctionType(PsiDisjunctionType type) {
            List types = ContainerUtil.map((Collection)type.getDisjunctions(), (Function)new Function<PsiType, Type>(){

                public Type fun(PsiType type) {
                    return (Type)type.accept((PsiTypeVisitor)Creator.this);
                }
            });
            return new DisjunctionType(types);
        }
    }

    private static class DisjunctionType
    extends Type {
        private final List<Type> myTypes;

        private DisjunctionType(List<Type> types) {
            this.myTypes = types;
        }

        @Override
        @NotNull
        public PsiType getType(final PsiElement context, final PsiManager manager) throws IncorrectOperationException {
            List types = ContainerUtil.map(this.myTypes, (Function)new Function<Type, PsiType>(){

                public PsiType fun(Type type) {
                    return type.getType(context, manager);
                }
            });
            PsiDisjunctionType psiDisjunctionType = new PsiDisjunctionType(types, manager);
            if (psiDisjunctionType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/util/CanonicalTypes$DisjunctionType", "getType"));
            }
            return psiDisjunctionType;
        }

        @Override
        public String getTypeText() {
            return StringUtil.join(this.myTypes, (Function)new Function<Type, String>(){

                public String fun(Type type) {
                    return type.getTypeText();
                }
            }, (String)"|");
        }

        @Override
        public void addImportsTo(JavaCodeFragment fragment) {
            for (Type type : this.myTypes) {
                type.addImportsTo(fragment);
            }
        }
    }

    private static class ClassType
    extends AnnotatedType {
        private final String myPresentableText;
        private final String myClassQName;
        private final Map<String, Type> mySubstitutor;

        private ClassType(PsiType original, String classQName, Map<String, Type> substitutor) {
            super(original.getAnnotations());
            this.myPresentableText = original.getPresentableText();
            this.myClassQName = classQName;
            this.mySubstitutor = substitutor;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
            PsiElementFactory factory = facade.getElementFactory();
            PsiClass aClass = facade.getResolveHelper().resolveReferencedClass(this.myClassQName, context);
            if (aClass == null) {
                PsiType psiType = factory.createTypeFromText(this.myClassQName, context);
                if (psiType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/util/CanonicalTypes$ClassType", "getType"));
                }
                return psiType;
            }
            HashMap substitutionMap = ContainerUtil.newHashMap();
            Iterator iterator = PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass).iterator();
            while (iterator.hasNext()) {
                PsiTypeParameter typeParameter;
                Type substitute = this.mySubstitutor.get((typeParameter = (PsiTypeParameter)iterator.next()).getName());
                substitutionMap.put(typeParameter, substitute != null ? substitute.getType(context, manager) : null);
            }
            PsiClassType psiClassType = factory.createType(aClass, factory.createSubstitutor((Map)substitutionMap), null, this.myAnnotations);
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/util/CanonicalTypes$ClassType", "getType"));
            }
            return psiClassType;
        }

        @Override
        public String getTypeText() {
            return this.myPresentableText;
        }

        @Override
        public void addImportsTo(JavaCodeFragment fragment) {
            fragment.addImportsFromString(this.myClassQName);
            for (Type type : this.mySubstitutor.values()) {
                if (type == null) continue;
                type.addImportsTo(fragment);
            }
        }
    }

    private static class UnresolvedType
    extends Type {
        private final String myPresentableText;
        private final String myCanonicalText;

        private UnresolvedType(PsiType original) {
            this.myPresentableText = original.getPresentableText();
            this.myCanonicalText = original.getCanonicalText(true);
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            PsiType psiType = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeFromText(this.myCanonicalText, context);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/util/CanonicalTypes$UnresolvedType", "getType"));
            }
            return psiType;
        }

        @Override
        public String getTypeText() {
            return this.myPresentableText;
        }

        @Override
        public boolean isValid() {
            return false;
        }
    }

    private static class WildcardType
    extends AnnotatedType {
        private final boolean myIsExtending;
        private final Type myBound;

        private WildcardType(PsiType original, boolean isExtending, Type bound) {
            super(original.getAnnotations());
            this.myIsExtending = isExtending;
            this.myBound = bound;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            PsiWildcardType type = this.myBound == null ? PsiWildcardType.createUnbounded((PsiManager)manager) : (this.myIsExtending ? PsiWildcardType.createExtends((PsiManager)manager, (PsiType)this.myBound.getType(context, manager)) : PsiWildcardType.createSuper((PsiManager)manager, (PsiType)this.myBound.getType(context, manager)));
            PsiWildcardType psiWildcardType = type.annotate(this.myAnnotations);
            if (psiWildcardType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/util/CanonicalTypes$WildcardType", "getType"));
            }
            return psiWildcardType;
        }

        @Override
        public String getTypeText() {
            if (this.myBound == null) {
                return "?";
            }
            return "? " + (this.myIsExtending ? "extends " : "super ") + this.myBound.getTypeText();
        }

        @Override
        public void addImportsTo(JavaCodeFragment fragment) {
            if (this.myBound != null) {
                this.myBound.addImportsTo(fragment);
            }
        }

        @Override
        public boolean isValid() {
            return this.myBound == null || this.myBound.isValid();
        }
    }

    private static class Ellipsis
    extends Array {
        private Ellipsis(PsiType original, Type componentType) {
            super(original, componentType);
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            PsiEllipsisType psiEllipsisType = new PsiEllipsisType(this.myComponentType.getType(context, manager), this.myAnnotations);
            if (psiEllipsisType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/util/CanonicalTypes$Ellipsis", "getType"));
            }
            return psiEllipsisType;
        }

        @Override
        public String getTypeText() {
            return this.myComponentType.getTypeText() + "...";
        }
    }

    private static class Array
    extends AnnotatedType {
        protected final Type myComponentType;

        private Array(PsiType original, Type componentType) {
            super(original.getAnnotations());
            this.myComponentType = componentType;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            PsiArrayType psiArrayType = this.myComponentType.getType(context, manager).createArrayType(this.myAnnotations);
            if (psiArrayType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/util/CanonicalTypes$Array", "getType"));
            }
            return psiArrayType;
        }

        @Override
        public String getTypeText() {
            return this.myComponentType.getTypeText() + "[]";
        }

        @Override
        public void addImportsTo(JavaCodeFragment fragment) {
            this.myComponentType.addImportsTo(fragment);
        }

        @Override
        public boolean isValid() {
            return this.myComponentType.isValid();
        }
    }

    private static class Primitive
    extends AnnotatedType {
        private final PsiPrimitiveType myType;

        private Primitive(PsiPrimitiveType type) {
            super(type.getAnnotations());
            this.myType = type;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) {
            PsiPrimitiveType psiPrimitiveType = this.myAnnotations.length == 0 ? this.myType : new PsiPrimitiveType(this.myType.getCanonicalText(false), this.myAnnotations);
            if (psiPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/util/CanonicalTypes$Primitive", "getType"));
            }
            return psiPrimitiveType;
        }

        @Override
        public String getTypeText() {
            return this.myType.getPresentableText();
        }
    }

    private static abstract class AnnotatedType
    extends Type {
        protected final PsiAnnotation[] myAnnotations;

        protected AnnotatedType(PsiAnnotation[] annotations) {
            this.myAnnotations = annotations;
        }
    }

    public static abstract class Type {
        @NotNull
        public abstract PsiType getType(PsiElement var1, PsiManager var2) throws IncorrectOperationException;

        @NonNls
        public abstract String getTypeText();

        public void addImportsTo(JavaCodeFragment fragment) {
        }

        public boolean isValid() {
            return true;
        }
    }
}

