/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.log;

import com.intellij.execution.filters.BrowserHyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class LoggingHandlerImpl
extends LoggingHandlerBase
implements LoggingHandler {
    private final ConsoleView myConsole;

    public LoggingHandlerImpl(String presentableName, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/remoteServer/impl/runtime/log/LoggingHandlerImpl", "<init>"));
        }
        super(presentableName);
        this.myConsole = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        Disposer.register((Disposable)this, (Disposable)this.myConsole);
    }

    @Override
    public JComponent getComponent() {
        return this.myConsole.getComponent();
    }

    @NotNull
    public ConsoleView getConsole() {
        ConsoleView consoleView = this.myConsole;
        if (consoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/log/LoggingHandlerImpl", "getConsole"));
        }
        return consoleView;
    }

    public void print(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/remoteServer/impl/runtime/log/LoggingHandlerImpl", "print"));
        }
        this.myConsole.print(s, ConsoleViewContentType.NORMAL_OUTPUT);
    }

    public void printHyperlink(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/remoteServer/impl/runtime/log/LoggingHandlerImpl", "printHyperlink"));
        }
        this.printHyperlink(url, (HyperlinkInfo)new BrowserHyperlinkInfo(url));
    }

    public void printHyperlink(@NotNull String text, HyperlinkInfo info) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/remoteServer/impl/runtime/log/LoggingHandlerImpl", "printHyperlink"));
        }
        this.myConsole.printHyperlink(text, info);
    }

    public void printlnSystemMessage(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/remoteServer/impl/runtime/log/LoggingHandlerImpl", "printlnSystemMessage"));
        }
        this.myConsole.print(s + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    public void attachToProcess(@NotNull ProcessHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/remoteServer/impl/runtime/log/LoggingHandlerImpl", "attachToProcess"));
        }
        this.myConsole.attachToProcess(handler);
    }

    public void clear() {
        this.myConsole.clear();
    }

    @Override
    public boolean isClosed() {
        return false;
    }
}

