/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexableFileSet;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightProjectDescriptor {
    public static final LightProjectDescriptor EMPTY_PROJECT_DESCRIPTOR = new LightProjectDescriptor();

    public void setUpProject(@NotNull Project project, @NotNull SetupHandler handler) throws Exception {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightProjectDescriptor", "setUpProject"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/testFramework/LightProjectDescriptor", "setUpProject"));
        }
        Module module = this.createMainModule(project);
        handler.moduleCreated(module);
        VirtualFile sourceRoot = this.createSourcesRoot(module);
        if (sourceRoot != null) {
            handler.sourceRootCreated(sourceRoot);
            this.createContentEntry(module, sourceRoot);
        }
    }

    @NotNull
    public Module createMainModule(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/LightProjectDescriptor", "createMainModule"));
        }
        Module module = (Module)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Module>(){

            public Module compute() {
                return ModuleManager.getInstance((Project)project).newModule("light_idea_test_case.iml", LightProjectDescriptor.this.getModuleType().getId());
            }
        });
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightProjectDescriptor", "createMainModule"));
        }
        return module;
    }

    @NotNull
    public ModuleType getModuleType() {
        EmptyModuleType emptyModuleType = EmptyModuleType.getInstance();
        if (emptyModuleType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightProjectDescriptor", "getModuleType"));
        }
        return emptyModuleType;
    }

    @Nullable
    public VirtualFile createSourcesRoot(final @NotNull Module module) {
        VirtualFile srcRoot;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/testFramework/LightProjectDescriptor", "createSourcesRoot"));
        }
        VirtualFile dummyRoot = VirtualFileManager.getInstance().findFileByUrl("temp:///");
        assert (dummyRoot != null);
        dummyRoot.refresh(false, false);
        try {
            srcRoot = dummyRoot.createChildDirectory((Object)this, "src");
            this.cleanSourceRoot(srcRoot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final IndexableFileSet indexableFileSet = new IndexableFileSet(){

            public boolean isInSet(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/LightProjectDescriptor$2", "isInSet"));
                }
                return file.getFileSystem() == srcRoot.getFileSystem() && module.getProject().isOpen();
            }

            public void iterateIndexableFilesIn(@NotNull VirtualFile file, final @NotNull ContentIterator iterator) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/LightProjectDescriptor$2", "iterateIndexableFilesIn"));
                }
                if (iterator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/testFramework/LightProjectDescriptor$2", "iterateIndexableFilesIn"));
                }
                VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                    public boolean visitFile(@NotNull VirtualFile file) {
                        if (file == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/LightProjectDescriptor$2$1", "visitFile"));
                        }
                        iterator.processFile(file);
                        return true;
                    }
                });
            }
        };
        FileBasedIndex.getInstance().registerIndexableSet(indexableFileSet, null);
        Disposer.register((Disposable)module.getProject(), (Disposable)new Disposable(){

            public void dispose() {
                FileBasedIndex.getInstance().removeIndexableSet(indexableFileSet);
            }
        });
        return srcRoot;
    }

    protected void createContentEntry(final @NotNull Module module, final @NotNull VirtualFile srcRoot) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/testFramework/LightProjectDescriptor", "createContentEntry"));
        }
        if (srcRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcRoot", "com/intellij/testFramework/LightProjectDescriptor", "createContentEntry"));
        }
        ModuleRootModificationUtil.updateModel((Module)module, (Consumer)new Consumer<ModifiableRootModel>(){

            public void consume(ModifiableRootModel model) {
                Sdk sdk = LightProjectDescriptor.this.getSdk();
                if (sdk != null) {
                    model.setSdk(sdk);
                }
                ContentEntry contentEntry = model.addContentEntry(srcRoot);
                contentEntry.addSourceFolder(srcRoot, false);
                LightProjectDescriptor.this.configureModule(module, model, contentEntry);
            }
        });
    }

    @Nullable
    public Sdk getSdk() {
        return null;
    }

    private void cleanSourceRoot(@NotNull VirtualFile contentRoot) throws IOException {
        if (contentRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoot", "com/intellij/testFramework/LightProjectDescriptor", "cleanSourceRoot"));
        }
        TempFileSystem tempFs = (TempFileSystem)contentRoot.getFileSystem();
        for (VirtualFile child : contentRoot.getChildren()) {
            if (!tempFs.exists(child)) {
                tempFs.createChildFile(this, contentRoot, child.getName());
            }
            child.delete((Object)this);
        }
    }

    protected void configureModule(@NotNull Module module, @NotNull ModifiableRootModel model, @NotNull ContentEntry contentEntry) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/testFramework/LightProjectDescriptor", "configureModule"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/testFramework/LightProjectDescriptor", "configureModule"));
        }
        if (contentEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntry", "com/intellij/testFramework/LightProjectDescriptor", "configureModule"));
        }
    }

    public static interface SetupHandler {
        public void moduleCreated(@NotNull Module var1);

        public void sourceRootCreated(@NotNull VirtualFile var1);
    }
}

