/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.ListItemEditor;
import com.intellij.util.ui.ListModelEditorBase;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListModelEditor<T>
extends ListModelEditorBase<T> {
    private final ToolbarDecorator toolbarDecorator;
    private JBList list;

    public ListModelEditor(@NotNull ListItemEditor<T> itemEditor) {
        if (itemEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemEditor", "com/intellij/util/ui/ListModelEditor", "<init>"));
        }
        super(itemEditor);
        this.list = new JBList((ListModel)((Object)this.model));
        this.list.setSelectionMode(0);
        this.list.setCellRenderer((ListCellRenderer)((Object)new MyListCellRenderer()));
        this.toolbarDecorator = ToolbarDecorator.createDecorator((JList)this.list, (EditableModel)this.model).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                Object lastItem;
                if (!ListModelEditor.this.model.isEmpty() && ((ListItemEditor)ListModelEditor.this.itemEditor).isEmpty(lastItem = ListModelEditor.this.model.getElementAt(ListModelEditor.this.model.getSize() - 1))) {
                    ListScrollingUtil.selectItem((JList)ListModelEditor.this.list, (int)ContainerUtil.indexOfIdentity((List)ListModelEditor.this.model.getItems(), (Object)lastItem));
                    return;
                }
                Object item = ListModelEditor.this.createElement();
                ListModelEditor.this.model.add(item);
                ListScrollingUtil.selectItem((JList)ListModelEditor.this.list, (int)ContainerUtil.indexOfIdentity((List)ListModelEditor.this.model.getItems(), item));
            }
        }).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return ListModelEditor.this.areSelectedItemsRemovable(ListModelEditor.this.list.getSelectionModel());
            }
        });
    }

    @NotNull
    public ListModelEditor<T> disableUpDownActions() {
        this.toolbarDecorator.disableUpDownActions();
        ListModelEditor listModelEditor = this;
        if (listModelEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ListModelEditor", "disableUpDownActions"));
        }
        return listModelEditor;
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.toolbarDecorator.createPanel();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ListModelEditor", "createComponent"));
        }
        return jPanel;
    }

    @NotNull
    public JBList getList() {
        JBList jBList = this.list;
        if (jBList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ListModelEditor", "getList"));
        }
        return jBList;
    }

    @Nullable
    public T getSelected() {
        return (T)this.list.getSelectedValue();
    }

    @Override
    public void reset(@NotNull List<T> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/util/ui/ListModelEditor", "reset"));
        }
        super.reset(items);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!ListModelEditor.this.model.isEmpty()) {
                    ListModelEditor.this.list.setSelectedIndex(0);
                }
            }
        });
    }

    @Override
    protected void removeEmptyItem(int i) {
        ListUtil.removeIndices((JList)this.getList(), (int[])new int[]{i});
    }

    private class MyListCellRenderer
    extends ColoredListCellRenderer {
        private MyListCellRenderer() {
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            this.setBackground(UIUtil.getListBackground((boolean)selected));
            if (value != null) {
                this.append(((ListItemEditor)ListModelEditor.this.itemEditor).getName(value));
            }
        }
    }
}

