/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.vcs.log.VcsLogBranchFilter;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class VcsLogBranchFilterImpl
implements VcsLogBranchFilter {
    @NotNull
    private final Collection<String> myBranchNames;
    @NotNull
    private final Collection<String> myExcludedBranchNames;

    public VcsLogBranchFilterImpl(@NotNull Collection<String> branchNames, @NotNull Collection<String> excludedBranchNames) {
        if (branchNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchNames", "com/intellij/vcs/log/data/VcsLogBranchFilterImpl", "<init>"));
        }
        if (excludedBranchNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedBranchNames", "com/intellij/vcs/log/data/VcsLogBranchFilterImpl", "<init>"));
        }
        this.myBranchNames = branchNames;
        this.myExcludedBranchNames = excludedBranchNames;
    }

    public String toString() {
        return !this.myBranchNames.isEmpty() ? "on: " + StringUtil.join(this.myBranchNames, (String)", ") : "not on: " + StringUtil.join(this.myExcludedBranchNames, (String)", ");
    }

    @NotNull
    public Collection<String> getBranchNames() {
        Collection<String> collection = this.myBranchNames;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogBranchFilterImpl", "getBranchNames"));
        }
        return collection;
    }

    @NotNull
    public Collection<String> getExcludedBranchNames() {
        Collection<String> collection = this.myExcludedBranchNames;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogBranchFilterImpl", "getExcludedBranchNames"));
        }
        return collection;
    }
}

