/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogHashMap;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CommitCountStage;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.EmptyVisibleGraph;
import com.intellij.vcs.log.data.VcsLogMultiRepoJoiner;
import com.intellij.vcs.log.data.VcsLogStructureFilterImpl;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.impl.VcsLogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VisiblePackBuilder {
    private static final Logger LOG = Logger.getInstance(VisiblePackBuilder.class);
    @NotNull
    private final VcsLogHashMap myHashMap;
    @NotNull
    private final Map<Integer, VcsCommitMetadata> myTopCommitsDetailsCache;
    @NotNull
    private final DataGetter<VcsFullCommitDetails> myCommitDetailsGetter;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;

    VisiblePackBuilder(@NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsLogHashMap hashMap, @NotNull Map<Integer, VcsCommitMetadata> topCommitsDetailsCache, @NotNull DataGetter<VcsFullCommitDetails> detailsGetter) {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/vcs/log/data/VisiblePackBuilder", "<init>"));
        }
        if (hashMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashMap", "com/intellij/vcs/log/data/VisiblePackBuilder", "<init>"));
        }
        if (topCommitsDetailsCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topCommitsDetailsCache", "com/intellij/vcs/log/data/VisiblePackBuilder", "<init>"));
        }
        if (detailsGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailsGetter", "com/intellij/vcs/log/data/VisiblePackBuilder", "<init>"));
        }
        this.myHashMap = hashMap;
        this.myTopCommitsDetailsCache = topCommitsDetailsCache;
        this.myCommitDetailsGetter = detailsGetter;
        this.myLogProviders = providers;
    }

    @NotNull
    Pair<VisiblePack, CommitCountStage> build(@NotNull DataPack dataPack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/data/VisiblePackBuilder", "build"));
        }
        if (sortType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortType", "com/intellij/vcs/log/data/VisiblePackBuilder", "build"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/vcs/log/data/VisiblePackBuilder", "build"));
        }
        if (commitCount == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitCount", "com/intellij/vcs/log/data/VisiblePackBuilder", "build"));
        }
        VcsLogHashFilter hashFilter = filters.getHashFilter();
        if (hashFilter != null && !hashFilter.getHashes().isEmpty()) {
            Pair pair = Pair.create((Object)this.applyHashFilter(dataPack, hashFilter.getHashes(), sortType), (Object)((Object)commitCount));
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VisiblePackBuilder", "build"));
            }
            return pair;
        }
        Set<Integer> matchingHeads = this.getMatchingHeads(dataPack.getRefs(), dataPack.getLogProviders().keySet(), filters);
        List detailsFilters = filters.getDetailsFilters();
        List<Object> matchingCommits = null;
        boolean canRequestMore = false;
        if (!detailsFilters.isEmpty()) {
            if (commitCount == CommitCountStage.INITIAL && (matchingCommits = this.filterInMemory(dataPack.getPermanentGraph(), detailsFilters, matchingHeads)).size() < commitCount.getCount()) {
                commitCount = commitCount.next();
                matchingCommits = null;
            }
            if (matchingCommits == null) {
                try {
                    matchingCommits = VisiblePackBuilder.getFilteredDetailsFromTheVcs(this.myLogProviders, filters, commitCount.getCount());
                }
                catch (VcsException e) {
                    matchingCommits = Collections.emptyList();
                    LOG.error((Throwable)e);
                }
            }
            canRequestMore = matchingCommits.size() >= commitCount.getCount();
        }
        VisibleGraph visibleGraph = VisiblePackBuilder.matchesNothing(matchingHeads) || VisiblePackBuilder.matchesNothing(matchingCommits) ? EmptyVisibleGraph.getInstance() : dataPack.getPermanentGraph().createVisibleGraph(sortType, matchingHeads, this.getMatchedCommitIndex(matchingCommits));
        Pair pair = Pair.create((Object)new VisiblePack(dataPack, visibleGraph, canRequestMore), (Object)((Object)commitCount));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VisiblePackBuilder", "build"));
        }
        return pair;
    }

    private static <T> boolean matchesNothing(@Nullable Collection<T> matchingSet) {
        return matchingSet != null && matchingSet.isEmpty();
    }

    private VisiblePack applyHashFilter(@NotNull DataPack dataPack, @NotNull Collection<String> hashes, @NotNull PermanentGraph.SortType sortType) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/data/VisiblePackBuilder", "applyHashFilter"));
        }
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "com/intellij/vcs/log/data/VisiblePackBuilder", "applyHashFilter"));
        }
        if (sortType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortType", "com/intellij/vcs/log/data/VisiblePackBuilder", "applyHashFilter"));
        }
        Set indices = ContainerUtil.map2SetNotNull(hashes, (Function)new Function<String, Integer>(){

            public Integer fun(String partOfHash) {
                Hash hash = VisiblePackBuilder.this.myHashMap.findHashByString(partOfHash);
                return hash != null ? Integer.valueOf(VisiblePackBuilder.this.myHashMap.getCommitIndex(hash)) : null;
            }
        });
        VisibleGraph visibleGraph = dataPack.getPermanentGraph().createVisibleGraph(sortType, null, indices);
        return new VisiblePack(dataPack, (VisibleGraph<Integer>)visibleGraph, false);
    }

    @Nullable
    private Set<Integer> getMatchingHeads(@NotNull VcsLogRefs refs, @NotNull Set<VirtualFile> roots, @NotNull VcsLogFilterCollection filters) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/data/VisiblePackBuilder", "getMatchingHeads"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/data/VisiblePackBuilder", "getMatchingHeads"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/vcs/log/data/VisiblePackBuilder", "getMatchingHeads"));
        }
        VcsLogBranchFilter branchFilter = filters.getBranchFilter();
        VcsLogRootFilter rootFilter = filters.getRootFilter();
        VcsLogStructureFilter structureFilter = filters.getStructureFilter();
        if (branchFilter == null && rootFilter == null && structureFilter == null) {
            return null;
        }
        Set<Integer> filteredByBranch = null;
        if (branchFilter != null) {
            filteredByBranch = this.getMatchingHeads(refs, branchFilter);
        }
        Set<Integer> filteredByFile = this.getMatchingHeads(refs, VcsLogUtil.getAllVisibleRoots(roots, rootFilter, structureFilter));
        if (filteredByBranch == null) {
            return filteredByFile;
        }
        if (filteredByFile == null) {
            return filteredByBranch;
        }
        return new HashSet(ContainerUtil.intersection(filteredByBranch, filteredByFile));
    }

    private Set<Integer> getMatchingHeads(@NotNull VcsLogRefs refs, @NotNull VcsLogBranchFilter filter) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/data/VisiblePackBuilder", "getMatchingHeads"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/data/VisiblePackBuilder", "getMatchingHeads"));
        }
        HashSet branchNames = new HashSet(filter.getBranchNames());
        HashSet excludedBranches = new HashSet(filter.getExcludedBranchNames());
        final boolean filterByAcceptance = !filter.getBranchNames().isEmpty();
        return new HashSet((Collection)ContainerUtil.mapNotNull((Collection)refs.getBranches(), (Function)new Function<VcsRef, Integer>((Collection)branchNames, (Collection)excludedBranches){
            final /* synthetic */ Collection val$branchNames;
            final /* synthetic */ Collection val$excludedBranches;
            {
                this.val$branchNames = collection;
                this.val$excludedBranches = collection2;
            }

            public Integer fun(@NotNull VcsRef ref) {
                if (ref == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/vcs/log/data/VisiblePackBuilder$2", "fun"));
                }
                boolean acceptRef = filterByAcceptance ? this.val$branchNames.contains(ref.getName()) : !this.val$excludedBranches.contains(ref.getName());
                return acceptRef ? Integer.valueOf(VisiblePackBuilder.this.myHashMap.getCommitIndex(ref.getCommitHash())) : null;
            }
        }));
    }

    private Set<Integer> getMatchingHeads(@NotNull VcsLogRefs refs, @NotNull Collection<VirtualFile> roots) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/data/VisiblePackBuilder", "getMatchingHeads"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/data/VisiblePackBuilder", "getMatchingHeads"));
        }
        HashSet result = new HashSet();
        for (VcsRef branch : refs.getBranches()) {
            if (!roots.contains(branch.getRoot())) continue;
            result.add(this.myHashMap.getCommitIndex(branch.getCommitHash()));
        }
        return result;
    }

    @NotNull
    private List<Hash> filterInMemory(@NotNull PermanentGraph<Integer> permanentGraph, @NotNull List<VcsLogDetailsFilter> detailsFilters, @Nullable Set<Integer> matchingHeads) {
        GraphCommit commit;
        VcsCommitMetadata data;
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/data/VisiblePackBuilder", "filterInMemory"));
        }
        if (detailsFilters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailsFilters", "com/intellij/vcs/log/data/VisiblePackBuilder", "filterInMemory"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        Iterator iterator = permanentGraph.getAllCommits().iterator();
        while (iterator.hasNext() && (data = this.getDetailsFromCache((Integer)(commit = (GraphCommit)iterator.next()).getId())) != null) {
            if (!this.matchesAllFilters(data, permanentGraph, detailsFilters, matchingHeads)) continue;
            result.add(data.getId());
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VisiblePackBuilder", "filterInMemory"));
        }
        return arrayList;
    }

    private boolean matchesAllFilters(final @NotNull VcsCommitMetadata commit, @NotNull PermanentGraph<Integer> permanentGraph, @NotNull List<VcsLogDetailsFilter> detailsFilters, @Nullable Set<Integer> matchingHeads) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/data/VisiblePackBuilder", "matchesAllFilters"));
        }
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/data/VisiblePackBuilder", "matchesAllFilters"));
        }
        if (detailsFilters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailsFilters", "com/intellij/vcs/log/data/VisiblePackBuilder", "matchesAllFilters"));
        }
        boolean matchesAllDetails = ContainerUtil.and(detailsFilters, (Condition)new Condition<VcsLogDetailsFilter>(){

            public boolean value(VcsLogDetailsFilter filter) {
                return filter.matches(commit);
            }
        });
        return matchesAllDetails && this.matchesAnyHead(permanentGraph, commit, matchingHeads);
    }

    private boolean matchesAnyHead(@NotNull PermanentGraph<Integer> permanentGraph, @NotNull VcsCommitMetadata commit, @Nullable Set<Integer> matchingHeads) {
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/data/VisiblePackBuilder", "matchesAnyHead"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/data/VisiblePackBuilder", "matchesAnyHead"));
        }
        if (matchingHeads == null) {
            return true;
        }
        int commitIndex = this.myHashMap.getCommitIndex((Hash)commit.getId());
        return ContainerUtil.intersects((Collection)permanentGraph.getContainingBranches((Object)commitIndex), matchingHeads);
    }

    @Nullable
    private VcsCommitMetadata getDetailsFromCache(final int commitIndex) {
        VcsCommitMetadata details = this.myTopCommitsDetailsCache.get(commitIndex);
        if (details != null) {
            return details;
        }
        return (VcsCommitMetadata)UIUtil.invokeAndWaitIfNeeded((Computable)new Computable<VcsCommitMetadata>(){

            public VcsCommitMetadata compute() {
                return (VcsCommitMetadata)VisiblePackBuilder.this.myCommitDetailsGetter.getCommitDataIfAvailable(commitIndex);
            }
        });
    }

    @NotNull
    private static List<Hash> getFilteredDetailsFromTheVcs(@NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsLogFilterCollection filterCollection, int maxCount) throws VcsException {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/vcs/log/data/VisiblePackBuilder", "getFilteredDetailsFromTheVcs"));
        }
        if (filterCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterCollection", "com/intellij/vcs/log/data/VisiblePackBuilder", "getFilteredDetailsFromTheVcs"));
        }
        Set<VirtualFile> visibleRoots = VcsLogUtil.getAllVisibleRoots(providers.keySet(), filterCollection.getRootFilter(), filterCollection.getStructureFilter());
        ArrayList logs = ContainerUtil.newArrayList();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
            VirtualFile root = entry.getKey();
            if (!visibleRoots.contains(root) || filterCollection.getUserFilter() != null && filterCollection.getUserFilter().getUserNames(root).isEmpty()) continue;
            VcsLogFilterCollection rootSpecificCollection = filterCollection;
            if (rootSpecificCollection.getStructureFilter() != null) {
                rootSpecificCollection = VisiblePackBuilder.replaceStructureFilter(filterCollection, ContainerUtil.newHashSet(VcsLogUtil.getFilteredFilesForRoot(root, filterCollection)));
            }
            List matchingCommits = entry.getValue().getCommitsMatchingFilter(root, rootSpecificCollection, maxCount);
            logs.add(matchingCommits);
        }
        List compoundLog = new VcsLogMultiRepoJoiner().join(logs);
        List list = ContainerUtil.map(compoundLog, (Function)new Function<TimedVcsCommit, Hash>(){

            public Hash fun(TimedVcsCommit commit) {
                return (Hash)commit.getId();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VisiblePackBuilder", "getFilteredDetailsFromTheVcs"));
        }
        return list;
    }

    @NotNull
    private static VcsLogFilterCollection replaceStructureFilter(@NotNull VcsLogFilterCollection filterCollection, @NotNull Set<VirtualFile> files) {
        if (filterCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterCollection", "com/intellij/vcs/log/data/VisiblePackBuilder", "replaceStructureFilter"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcs/log/data/VisiblePackBuilder", "replaceStructureFilter"));
        }
        VcsLogFilterCollectionImpl vcsLogFilterCollectionImpl = new VcsLogFilterCollectionImpl(filterCollection.getBranchFilter(), filterCollection.getUserFilter(), filterCollection.getHashFilter(), filterCollection.getDateFilter(), filterCollection.getTextFilter(), new VcsLogStructureFilterImpl(files), filterCollection.getRootFilter());
        if (vcsLogFilterCollectionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VisiblePackBuilder", "replaceStructureFilter"));
        }
        return vcsLogFilterCollectionImpl;
    }

    @Nullable
    private Set<Integer> getMatchedCommitIndex(@Nullable List<Hash> commits) {
        if (commits == null) {
            return null;
        }
        return ContainerUtil.map2Set(commits, (Function)new Function<Hash, Integer>(){

            public Integer fun(Hash hash) {
                return VisiblePackBuilder.this.myHashMap.getCommitIndex(hash);
            }
        });
    }
}

