/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.openapi.util.Condition;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.collapsing.BranchFilterController;
import com.intellij.vcs.log.graph.collapsing.CollapsedController;
import com.intellij.vcs.log.graph.impl.facade.BaseController;
import com.intellij.vcs.log.graph.impl.facade.BekBaseController;
import com.intellij.vcs.log.graph.impl.facade.CascadeController;
import com.intellij.vcs.log.graph.impl.facade.FilteredController;
import com.intellij.vcs.log.graph.impl.facade.ReachableNodes;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.graph.impl.facade.bek.BekIntMap;
import com.intellij.vcs.log.graph.impl.facade.bek.BekSorter;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutBuilder;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoIml;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphBuilder;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphImpl;
import com.intellij.vcs.log.graph.linearBek.LinearBekController;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermanentGraphImpl<CommitId>
implements PermanentGraph<CommitId>,
PermanentGraphInfo<CommitId> {
    @NotNull
    private final PermanentCommitsInfoIml<CommitId> myPermanentCommitsInfo;
    @NotNull
    private final PermanentLinearGraphImpl myPermanentLinearGraph;
    @NotNull
    private final GraphLayoutImpl myPermanentGraphLayout;
    @NotNull
    private final GraphColorManager<CommitId> myGraphColorManager;
    @NotNull
    private final Set<CommitId> myBranchesCommitId;
    @NotNull
    private final Set<Integer> myBranchNodeIds;
    @NotNull
    private final ReachableNodes myReachableNodes;
    @NotNull
    private final BekIntMap myBekIntMap;

    @NotNull
    public static <CommitId> PermanentGraphImpl<CommitId> newInstance(@NotNull List<? extends GraphCommit<CommitId>> graphCommits, final @NotNull GraphColorManager<CommitId> graphColorManager, @NotNull Set<CommitId> branchesCommitId) {
        if (graphCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphCommits", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "newInstance"));
        }
        if (graphColorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphColorManager", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "newInstance"));
        }
        if (branchesCommitId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchesCommitId", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "newInstance"));
        }
        PermanentLinearGraphBuilder permanentLinearGraphBuilder = PermanentLinearGraphBuilder.newInstance(graphCommits);
        final HashMap notLoadCommits = ContainerUtil.newHashMap();
        PermanentLinearGraphImpl linearGraph = permanentLinearGraphBuilder.build(new NotNullFunction<CommitId, Integer>(){

            @NotNull
            public Integer fun(CommitId dom) {
                int nodeId = -(notLoadCommits.size() + 2);
                notLoadCommits.put(nodeId, dom);
                Integer n = nodeId;
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl$1", "fun"));
                }
                return n;
            }
        });
        final PermanentCommitsInfoIml commitIdPermanentCommitsInfo = PermanentCommitsInfoIml.newInstance(graphCommits, notLoadCommits);
        GraphLayoutImpl permanentGraphLayout = GraphLayoutBuilder.build(linearGraph, new Comparator<Integer>(){

            @Override
            public int compare(@NotNull Integer nodeIndex1, @NotNull Integer nodeIndex2) {
                if (nodeIndex1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeIndex1", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl$2", "compare"));
                }
                if (nodeIndex2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeIndex2", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl$2", "compare"));
                }
                Object commitId1 = commitIdPermanentCommitsInfo.getCommitId(nodeIndex1);
                Object commitId2 = commitIdPermanentCommitsInfo.getCommitId(nodeIndex2);
                return graphColorManager.compareHeads(commitId2, commitId1);
            }
        });
        PermanentGraphImpl permanentGraphImpl = new PermanentGraphImpl(linearGraph, permanentGraphLayout, commitIdPermanentCommitsInfo, graphColorManager, branchesCommitId);
        if (permanentGraphImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "newInstance"));
        }
        return permanentGraphImpl;
    }

    public PermanentGraphImpl(@NotNull PermanentLinearGraphImpl permanentLinearGraph, @NotNull GraphLayoutImpl permanentGraphLayout, @NotNull PermanentCommitsInfoIml<CommitId> permanentCommitsInfo, @NotNull GraphColorManager<CommitId> graphColorManager, @NotNull Set<CommitId> branchesCommitId) {
        if (permanentLinearGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentLinearGraph", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "<init>"));
        }
        if (permanentGraphLayout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraphLayout", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "<init>"));
        }
        if (permanentCommitsInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentCommitsInfo", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "<init>"));
        }
        if (graphColorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphColorManager", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "<init>"));
        }
        if (branchesCommitId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchesCommitId", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "<init>"));
        }
        this.myPermanentGraphLayout = permanentGraphLayout;
        this.myPermanentCommitsInfo = permanentCommitsInfo;
        this.myPermanentLinearGraph = permanentLinearGraph;
        this.myGraphColorManager = graphColorManager;
        this.myBranchesCommitId = branchesCommitId;
        this.myBranchNodeIds = permanentCommitsInfo.convertToNodeIds(branchesCommitId);
        this.myReachableNodes = new ReachableNodes(LinearGraphUtils.asLiteLinearGraph(permanentLinearGraph));
        this.myBekIntMap = BekSorter.createBekMap(this.myPermanentLinearGraph, this.myPermanentGraphLayout, this.myPermanentCommitsInfo.getTimestampGetter());
    }

    @NotNull
    public VisibleGraph<CommitId> createVisibleGraph(@NotNull PermanentGraph.SortType sortType, @Nullable Set<CommitId> visibleHeads, @Nullable Set<CommitId> matchingCommits) {
        CascadeController controller;
        if (sortType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortType", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "createVisibleGraph"));
        }
        CascadeController baseController = sortType == PermanentGraph.SortType.Normal ? new BaseController(this) : (sortType == PermanentGraph.SortType.LinearBek ? new LinearBekController(new BekBaseController(this, this.myBekIntMap), (PermanentGraphInfo)this) : new BekBaseController(this, this.myBekIntMap));
        if (matchingCommits != null) {
            controller = new FilteredController(baseController, this, this.myPermanentCommitsInfo.convertToNodeIds(matchingCommits));
        } else if (sortType == PermanentGraph.SortType.LinearBek) {
            controller = visibleHeads != null ? new BranchFilterController(baseController, this, this.myPermanentCommitsInfo.convertToNodeIds(visibleHeads)) : baseController;
        } else {
            Set<Integer> idOfVisibleBranches = null;
            if (visibleHeads != null) {
                idOfVisibleBranches = this.myPermanentCommitsInfo.convertToNodeIds(visibleHeads);
            }
            controller = new CollapsedController(baseController, this, idOfVisibleBranches);
        }
        VisibleGraphImpl visibleGraphImpl = new VisibleGraphImpl(controller, this);
        if (visibleGraphImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "createVisibleGraph"));
        }
        return visibleGraphImpl;
    }

    @NotNull
    public List<GraphCommit<CommitId>> getAllCommits() {
        ArrayList result = ContainerUtil.newArrayList();
        for (int index = 0; index < this.myPermanentLinearGraph.nodesCount(); ++index) {
            CommitId commitId = this.myPermanentCommitsInfo.getCommitId(index);
            List<Integer> downNodes = LinearGraphUtils.getDownNodesIncludeNotLoad(this.myPermanentLinearGraph, index);
            List<CommitId> parentsCommitIds = this.myPermanentCommitsInfo.convertToCommitIdList(downNodes);
            GraphCommitImpl<CommitId> graphCommit = new GraphCommitImpl<CommitId>(commitId, parentsCommitIds, this.myPermanentCommitsInfo.getTimestamp(index));
            result.add(graphCommit);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getAllCommits"));
        }
        return arrayList;
    }

    @NotNull
    public List<CommitId> getChildren(@NotNull CommitId commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getChildren"));
        }
        int commitIndex = this.myPermanentCommitsInfo.getNodeId(commit);
        List<CommitId> list = this.myPermanentCommitsInfo.convertToCommitIdList(LinearGraphUtils.getUpNodes(this.myPermanentLinearGraph, commitIndex));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getChildren"));
        }
        return list;
    }

    @NotNull
    public Set<CommitId> getContainingBranches(@NotNull CommitId commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getContainingBranches"));
        }
        int commitIndex = this.myPermanentCommitsInfo.getNodeId(commit);
        Set<CommitId> set = this.myPermanentCommitsInfo.convertToCommitIdSet(this.myReachableNodes.getContainingBranches(commitIndex, this.myBranchNodeIds));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getContainingBranches"));
        }
        return set;
    }

    @NotNull
    public Condition<CommitId> getContainedInBranchCondition(@NotNull Collection<CommitId> heads) {
        if (heads == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heads", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getContainedInBranchCondition"));
        }
        List headIds = ContainerUtil.map(heads, (Function)new Function<CommitId, Integer>(){

            public Integer fun(CommitId head) {
                return PermanentGraphImpl.this.myPermanentCommitsInfo.getNodeId(head);
            }
        });
        if (!heads.isEmpty() && ContainerUtil.getFirstItem(heads) instanceof Integer) {
            final TIntHashSet branchNodes = new TIntHashSet();
            this.myReachableNodes.walk(headIds, new Consumer<Integer>(){

                public void consume(Integer node) {
                    branchNodes.add(((Integer)PermanentGraphImpl.this.myPermanentCommitsInfo.getCommitId(node)).intValue());
                }
            });
            Condition condition = new Condition<CommitId>(){

                public boolean value(CommitId commitId) {
                    return branchNodes.contains(((Integer)commitId).intValue());
                }
            };
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getContainedInBranchCondition"));
            }
            return condition;
        }
        final HashSet branchNodes = ContainerUtil.newHashSet();
        this.myReachableNodes.walk(headIds, new Consumer<Integer>(){

            public void consume(Integer node) {
                branchNodes.add(PermanentGraphImpl.this.myPermanentCommitsInfo.getCommitId(node));
            }
        });
        Condition condition = new Condition<CommitId>(){

            public boolean value(CommitId commitId) {
                return branchNodes.contains(commitId);
            }
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getContainedInBranchCondition"));
        }
        return condition;
    }

    @Override
    @NotNull
    public PermanentCommitsInfoIml<CommitId> getPermanentCommitsInfo() {
        PermanentCommitsInfoIml<CommitId> permanentCommitsInfoIml = this.myPermanentCommitsInfo;
        if (permanentCommitsInfoIml == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getPermanentCommitsInfo"));
        }
        return permanentCommitsInfoIml;
    }

    @Override
    @NotNull
    public PermanentLinearGraphImpl getPermanentLinearGraph() {
        PermanentLinearGraphImpl permanentLinearGraphImpl = this.myPermanentLinearGraph;
        if (permanentLinearGraphImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getPermanentLinearGraph"));
        }
        return permanentLinearGraphImpl;
    }

    @Override
    @NotNull
    public GraphLayoutImpl getPermanentGraphLayout() {
        GraphLayoutImpl graphLayoutImpl = this.myPermanentGraphLayout;
        if (graphLayoutImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getPermanentGraphLayout"));
        }
        return graphLayoutImpl;
    }

    @Override
    @NotNull
    public GraphColorManager<CommitId> getGraphColorManager() {
        GraphColorManager<CommitId> graphColorManager = this.myGraphColorManager;
        if (graphColorManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getGraphColorManager"));
        }
        return graphColorManager;
    }

    @NotNull
    public Set<CommitId> getBranchesCommitId() {
        Set<CommitId> set = this.myBranchesCommitId;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getBranchesCommitId"));
        }
        return set;
    }

    @Override
    @NotNull
    public Set<Integer> getBranchNodeIds() {
        Set<Integer> set = this.myBranchNodeIds;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl", "getBranchNodeIds"));
        }
        return set;
    }
}

